/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.resolver;

import java.util.Collection;
import java.util.List;
import org.jboss.profileservice.bootstrap.ProfileActivationCallback;
import org.jboss.profileservice.profile.metadata.plugin.EmptyProfileMetaData;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.repository.ProfileMetaDataRepository;
import org.jboss.profileservice.resolver.AbstractRequirementResolver;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.dependency.ProfileRequirementResolver;
import org.jboss.profileservice.spi.dependency.ProfileRequirementResolverFactory;

public class BasicResolverFactory
implements ProfileRequirementResolverFactory {
    private final ProfileMetaDataRepository profileRepository;
    private final ProfileActivationCallback callback;

    public BasicResolverFactory(ProfileMetaDataRepository profileRepository, ProfileActivationCallback callback) {
        this.profileRepository = profileRepository;
        this.callback = callback;
    }

    public ProfileRequirementResolver createResolver(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null profile name");
        }
        EmptyProfileMetaData metaData = new EmptyProfileMetaData(name);
        ProfileMetaDataContext ctx = this.profileRepository.registerMetaData(metaData);
        return new ProfileResolverFacade(ctx, this.callback);
    }

    public class ProfileResolverFacade
    implements ProfileRequirementResolver {
        private final ProfileMetaDataContext context;
        private final ProfileActivationCallback callback;
        private List<ProfileMetaDataContext> resolved;

        public ProfileResolverFacade(ProfileMetaDataContext context, ProfileActivationCallback callback) {
            this.context = context;
            this.callback = callback;
        }

        public void addRequirement(ProfileRequirement requirement) {
            this.context.addRequirement(requirement);
        }

        public void deploy() throws Exception {
            if (this.resolved != null && !this.resolved.isEmpty()) {
                for (ProfileMetaDataContext context : this.resolved) {
                    this.callback.activate(context);
                }
            }
        }

        public Collection<ProfileRequirement> getUnsatisfiedRequirements() {
            return null;
        }

        public boolean resolve() {
            AbstractRequirementResolver resolver = new AbstractRequirementResolver(BasicResolverFactory.this.profileRepository);
            resolver.resolve(this.context);
            this.resolved = resolver.sort();
            return true;
        }
    }
}

