/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.core.channelfactory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.ha.core.channelfactory.ProtocolParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolData {
    private final Map<String, ProtocolParameter> mParameters = new HashMap<String, ProtocolParameter>();
    private final String mProtocolName;
    private final String mClassName;

    public ProtocolData(String protocolName, String className, List<ProtocolParameter> params) {
        this(protocolName, className, params.toArray(new ProtocolParameter[params.size()]));
    }

    public ProtocolData(String protocolName, String className, ProtocolParameter[] params) {
        this.mProtocolName = protocolName;
        this.mClassName = className;
        if (params != null) {
            this.override(params);
        }
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getProtocolName() {
        return this.mProtocolName;
    }

    @Deprecated
    public static String getDescription() {
        return "n/a";
    }

    public Map<String, ProtocolParameter> getParameters() {
        return this.mParameters;
    }

    @Deprecated
    public static boolean isOverride() {
        return false;
    }

    public ProtocolParameter[] getParametersAsArray() {
        ProtocolParameter[] result = new ProtocolParameter[this.mParameters.size()];
        Iterator<String> it = this.mParameters.keySet().iterator();
        for (int i = 0; i < result.length; ++i) {
            String key = it.next();
            result[i] = this.mParameters.get(key);
        }
        return result;
    }

    public void override(ProtocolParameter[] params) {
        for (ProtocolParameter param : params) {
            this.mParameters.put(param.getName(), param);
        }
    }

    public String getProtocolString() {
        StringBuilder buf = new StringBuilder(this.mClassName);
        if (!this.mParameters.isEmpty()) {
            buf.append('(');
            Iterator<String> i = this.mParameters.keySet().iterator();
            while (i.hasNext()) {
                String key = i.next();
                ProtocolParameter param = this.mParameters.get(key);
                buf.append(param.getParameterString());
                if (!i.hasNext()) continue;
                buf.append(';');
            }
            buf.append(')');
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.mProtocolName.hashCode();
    }

    public boolean equals(Object another) {
        return another instanceof ProtocolData && this.getProtocolName().equals(((ProtocolData)another).getProtocolName());
    }
}

