/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.core.framework.server;

import java.net.InetAddress;
import org.jboss.ha.core.framework.server.AddressPort;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jgroups.Address;

public class ClusterNodeImpl
implements ClusterNode {
    private static final long serialVersionUID = -1831036833785680731L;
    private final String id;
    private final Address jgAddress;
    private final AddressPort address;

    ClusterNodeImpl(String id, Address jgAddress, AddressPort addressPort) {
        if (id == null) {
            throw new IllegalArgumentException("Null id");
        }
        if (addressPort == null) {
            throw new IllegalArgumentException("Null addressPort");
        }
        this.id = id;
        this.address = addressPort;
        this.jgAddress = jgAddress;
    }

    public String getName() {
        return this.id;
    }

    public InetAddress getIpAddress() {
        return this.address.getInetAddress();
    }

    public int getPort() {
        return this.address.getPort();
    }

    Address getOriginalJGAddress() {
        return this.jgAddress;
    }

    public int compareTo(ClusterNode o) {
        if (o == null) {
            throw new ClassCastException("Comparison to null value");
        }
        if (!(o instanceof ClusterNodeImpl)) {
            throw new ClassCastException("Comparison between different classes");
        }
        return this.id.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClusterNodeImpl)) {
            return false;
        }
        ClusterNodeImpl other = (ClusterNodeImpl)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

