/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.plugin;

import java.io.File;
import org.rhq.core.system.SystemInfo;

public class PluginContext {
    private final String pluginName;
    private final SystemInfo systemInformation;
    private final File temporaryDirectory;
    private final File dataDirectory;
    private final String pluginContainerName;

    public PluginContext(String pluginName, SystemInfo systemInfo, File temporaryDirectory, File dataDirectory, String pluginContainerName) {
        this.pluginName = pluginName;
        this.systemInformation = systemInfo;
        this.dataDirectory = dataDirectory;
        this.pluginContainerName = pluginContainerName;
        if (temporaryDirectory == null) {
            this.temporaryDirectory = new File(System.getProperty("java.io.tmpdir"), "AGENT_TMP");
            this.temporaryDirectory.mkdirs();
        } else {
            this.temporaryDirectory = temporaryDirectory;
        }
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public SystemInfo getSystemInformation() {
        return this.systemInformation;
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public String getPluginContainerName() {
        return this.pluginContainerName;
    }
}

