/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.mc.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.injection.injector.metadata.EnvironmentEntryType;
import org.jboss.injection.injector.metadata.InjectionTargetType;
import org.jboss.injection.injector.metadata.JndiEnvironmentRefsGroup;
import org.jboss.injection.injector.metadata.impl.EnvironmentEntryImpl;
import org.jboss.injection.injector.metadata.impl.InjectionTarget;
import org.jboss.injection.injector.util.EnvironmentEntryUtil;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiEnvironmentImpl
implements JndiEnvironmentRefsGroup {
    private Environment delegate;
    private Collection<EnvironmentEntryType> envEntries;
    private ClassLoader classLoader;

    public JndiEnvironmentImpl(Environment environment, ClassLoader classloader) {
        if (environment == null) {
            throw new IllegalArgumentException("Cannot create " + this.getClass().getName() + " from a null " + Environment.class);
        }
        this.delegate = environment;
        this.classLoader = classloader;
        this.initEnvironmentReferences();
    }

    public Collection<EnvironmentEntryType> getEntries() {
        return this.envEntries;
    }

    private void initEnvironmentReferences() {
        ServiceReferencesMetaData serviceRefs;
        MessageDestinationReferencesMetaData messageDestRefs;
        ResourceReferencesMetaData resourceRefs;
        ResourceEnvironmentReferencesMetaData resourceEnvRefs;
        PersistenceContextReferencesMetaData persistenceCtxRefs;
        PersistenceUnitReferencesMetaData persistenceUnitRefs;
        EJBReferencesMetaData ejbRefs;
        EJBLocalReferencesMetaData ejbLocalRefs;
        AnnotatedEJBReferencesMetaData annotatedEjbRefs;
        this.envEntries = new ArrayList<EnvironmentEntryType>();
        EnvironmentEntriesMetaData envEntries = this.delegate.getEnvironmentEntries();
        if (envEntries != null) {
            for (EnvironmentEntryMetaData envEntry : envEntries) {
                Collection<InjectionTargetType> injectionTargets;
                if (envEntry.getValue() == null && envEntry.getLookupName() == null || (injectionTargets = this.convertInjectionTargets(envEntry.getInjectionTargets())).isEmpty()) continue;
                String encName = EnvironmentEntryUtil.getENCName((String)envEntry.getName());
                this.envEntries.add((EnvironmentEntryType)new EnvironmentEntryImpl(encName, injectionTargets));
            }
        }
        if ((annotatedEjbRefs = this.delegate.getAnnotatedEjbReferences()) != null) {
            for (AnnotatedEJBReferenceMetaData annotatedEjbRef : annotatedEjbRefs) {
                Collection<InjectionTargetType> injectionTargets = this.convertInjectionTargets(annotatedEjbRef.getInjectionTargets());
                if (injectionTargets.isEmpty()) continue;
                String encName = EnvironmentEntryUtil.getENCName((String)annotatedEjbRef.getName());
                this.envEntries.add((EnvironmentEntryType)new EnvironmentEntryImpl(encName, injectionTargets));
            }
        }
        if ((ejbLocalRefs = this.delegate.getEjbLocalReferences()) != null) {
            for (EJBLocalReferenceMetaData ejbLocalRef : ejbLocalRefs) {
                Collection<InjectionTargetType> injectionTargets = this.convertInjectionTargets(ejbLocalRef.getInjectionTargets());
                if (injectionTargets.isEmpty()) continue;
                String encName = EnvironmentEntryUtil.getENCName((String)ejbLocalRef.getName());
                this.envEntries.add((EnvironmentEntryType)new EnvironmentEntryImpl(encName, injectionTargets));
            }
        }
        if ((ejbRefs = this.delegate.getEjbReferences()) != null) {
            for (EJBReferenceMetaData ejbRef : ejbRefs) {
                Collection<InjectionTargetType> injectionTargets = this.convertInjectionTargets(ejbRef.getInjectionTargets());
                if (injectionTargets.isEmpty()) continue;
                String encName = EnvironmentEntryUtil.getENCName((String)ejbRef.getName());
                this.envEntries.add((EnvironmentEntryType)new EnvironmentEntryImpl(encName, injectionTargets));
            }
        }
        if ((persistenceUnitRefs = this.delegate.getPersistenceUnitRefs()) != null) {
            for (PersistenceUnitReferenceMetaData persistenceUnitRef : persistenceUnitRefs) {
                Collection<InjectionTargetType> injectionTargets = this.convertInjectionTargets(persistenceUnitRef.getInjectionTargets());
                if (injectionTargets.isEmpty()) continue;
                String encName = EnvironmentEntryUtil.getENCName((String)persistenceUnitRef.getName());
                this.envEntries.add((EnvironmentEntryType)new EnvironmentEntryImpl(encName, injectionTargets));
            }
        }
        if ((persistenceCtxRefs = this.delegate.getPersistenceContextRefs()) != null) {
            for (PersistenceContextReferenceMetaData persistenceCtxRef : persistenceCtxRefs) {
                Collection<InjectionTargetType> injectionTargets = this.convertInjectionTargets(persistenceCtxRef.getInjectionTargets());
                if (injectionTargets.isEmpty()) continue;
                String encName = EnvironmentEntryUtil.getENCName((String)persistenceCtxRef.getName());
                this.envEntries.add((EnvironmentEntryType)new EnvironmentEntryImpl(encName, injectionTargets));
            }
        }
        if ((resourceEnvRefs = this.delegate.getResourceEnvironmentReferences()) != null) {
            for (ResourceEnvironmentReferenceMetaData resourceEnvRef : resourceEnvRefs) {
                Collection<InjectionTargetType> injectionTargets = this.convertInjectionTargets(resourceEnvRef.getInjectionTargets());
                if (injectionTargets.isEmpty()) continue;
                String encName = EnvironmentEntryUtil.getENCName((String)resourceEnvRef.getName());
                this.envEntries.add((EnvironmentEntryType)new EnvironmentEntryImpl(encName, injectionTargets));
            }
        }
        if ((resourceRefs = this.delegate.getResourceReferences()) != null) {
            for (ResourceReferenceMetaData resourceRef : resourceRefs) {
                Collection<InjectionTargetType> injectionTargets = this.convertInjectionTargets(resourceRef.getInjectionTargets());
                if (injectionTargets.isEmpty()) continue;
                String encName = EnvironmentEntryUtil.getENCName((String)resourceRef.getName());
                this.envEntries.add((EnvironmentEntryType)new EnvironmentEntryImpl(encName, injectionTargets));
            }
        }
        if ((messageDestRefs = this.delegate.getMessageDestinationReferences()) != null) {
            for (MessageDestinationReferenceMetaData messageDestRef : messageDestRefs) {
                Collection<InjectionTargetType> injectionTargets = this.convertInjectionTargets(messageDestRef.getInjectionTargets());
                if (injectionTargets.isEmpty()) continue;
                String encName = EnvironmentEntryUtil.getENCName((String)messageDestRef.getName());
                this.envEntries.add((EnvironmentEntryType)new EnvironmentEntryImpl(encName, injectionTargets));
            }
        }
        if ((serviceRefs = this.delegate.getServiceReferences()) != null) {
            for (ServiceReferenceMetaData serviceRef : serviceRefs) {
                Collection<InjectionTargetType> injectionTargets = this.convertInjectionTargets(serviceRef.getInjectionTargets());
                if (injectionTargets.isEmpty()) continue;
                String encName = EnvironmentEntryUtil.getENCName((String)serviceRef.getName());
                this.envEntries.add((EnvironmentEntryType)new EnvironmentEntryImpl(encName, injectionTargets));
            }
        }
    }

    private Collection<InjectionTargetType> convertInjectionTargets(Collection<ResourceInjectionTargetMetaData> resourceInjectionTargets) {
        if (resourceInjectionTargets == null || resourceInjectionTargets.isEmpty()) {
            return new HashSet<InjectionTargetType>();
        }
        HashSet<InjectionTargetType> injectionTargets = new HashSet<InjectionTargetType>();
        for (ResourceInjectionTargetMetaData resourceInjectionTarget : resourceInjectionTargets) {
            Class<?> targetClass;
            try {
                targetClass = this.classLoader.loadClass(resourceInjectionTarget.getInjectionTargetClass());
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load injection target class: " + resourceInjectionTarget.getInjectionTargetClass(), cnfe);
            }
            injectionTargets.add((InjectionTargetType)new InjectionTarget(targetClass, resourceInjectionTarget.getInjectionTargetName()));
        }
        return injectionTargets;
    }
}

