/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.container;

import java.lang.reflect.Constructor;
import org.jacorb.config.Configuration;
import org.jacorb.notification.container.BiDirGiopPOAComponentAdapter;
import org.jacorb.notification.container.ConfigurationComponentAdapter;
import org.jacorb.notification.container.CurrentTimeUtilComponentAdapter;
import org.jacorb.notification.container.DynAnyFactoryComponentAdapter;
import org.jacorb.notification.container.FilterFactoryComponentAdapter;
import org.jacorb.notification.container.LocalParameterComponentAdapter;
import org.jacorb.notification.container.POAComponentAdapter;
import org.jacorb.notification.container.PushTaskExecutorFactoryComponentAdapter;
import org.jacorb.notification.container.RepositoryComponentAdapter;
import org.jacorb.notification.engine.ConfigurablePushTaskExecutorFactory;
import org.jacorb.notification.engine.DefaultTaskFactory;
import org.jacorb.notification.engine.DefaultTaskProcessor;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.filter.impl.DefaultETCLEvaluator;
import org.jacorb.notification.impl.DefaultEvaluationContextFactory;
import org.jacorb.notification.impl.DefaultMessageFactory;
import org.jacorb.notification.impl.PoolingEvaluationContextFactory;
import org.jacorb.notification.interfaces.EvaluationContextFactory;
import org.jacorb.orb.ORB;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.BasicComponentParameter;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.CachingComponentAdapterFactory;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.slf4j.Logger;

public class PicoContainerFactory {
    public static MutablePicoContainer createRootContainer(ORB oRB) {
        return PicoContainerFactory.createRootContainer(null, oRB);
    }

    public static MutablePicoContainer createRootContainer(MutablePicoContainer mutablePicoContainer, ORB oRB) {
        Configuration configuration = oRB.getConfiguration();
        Logger logger = configuration.getLogger(PicoContainerFactory.class.getName());
        MutablePicoContainer mutablePicoContainer2 = mutablePicoContainer == null ? PicoContainerFactory.createContainer(logger) : PicoContainerFactory.createContainer(mutablePicoContainer, logger);
        mutablePicoContainer2.registerComponentInstance(org.omg.CORBA.ORB.class, (Object)oRB);
        PicoContainerFactory.registerORBServices(mutablePicoContainer2);
        PicoContainerFactory.registerCoreServices(mutablePicoContainer2);
        return mutablePicoContainer2;
    }

    private static void registerCoreServices(MutablePicoContainer mutablePicoContainer) {
        mutablePicoContainer.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new PushTaskExecutorFactoryComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter(PushTaskExecutorFactory.class, ConfigurablePushTaskExecutorFactory.class))));
        mutablePicoContainer.registerComponentImplementation(DefaultETCLEvaluator.class);
        mutablePicoContainer.registerComponentImplementation(DefaultMessageFactory.class);
        mutablePicoContainer.registerComponentImplementation(DefaultTaskFactory.class);
        mutablePicoContainer.registerComponentImplementation(DefaultTaskProcessor.class);
        PicoContainerFactory.registerEvaluationContextFactory(mutablePicoContainer);
    }

    private static void registerEvaluationContextFactory(MutablePicoContainer mutablePicoContainer) {
        ConstructorInjectionComponentAdapter constructorInjectionComponentAdapter = new ConstructorInjectionComponentAdapter(DefaultEvaluationContextFactory.class, DefaultEvaluationContextFactory.class);
        ConstructorInjectionComponentAdapter constructorInjectionComponentAdapter2 = new ConstructorInjectionComponentAdapter(EvaluationContextFactory.class, PoolingEvaluationContextFactory.class, new Parameter[]{BasicComponentParameter.BASIC_DEFAULT, new BasicComponentParameter(DefaultEvaluationContextFactory.class)});
        LocalParameterComponentAdapter localParameterComponentAdapter = new LocalParameterComponentAdapter((ComponentAdapter)constructorInjectionComponentAdapter2, new ComponentAdapter[]{constructorInjectionComponentAdapter});
        CachingComponentAdapter cachingComponentAdapter = new CachingComponentAdapter((ComponentAdapter)localParameterComponentAdapter);
        mutablePicoContainer.registerComponent((ComponentAdapter)cachingComponentAdapter);
    }

    private static void registerORBServices(MutablePicoContainer mutablePicoContainer) {
        mutablePicoContainer.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new BiDirGiopPOAComponentAdapter((ComponentAdapter)new POAComponentAdapter())));
        mutablePicoContainer.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new DynAnyFactoryComponentAdapter()));
        mutablePicoContainer.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new ConfigurationComponentAdapter()));
        mutablePicoContainer.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new FilterFactoryComponentAdapter()));
        mutablePicoContainer.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new RepositoryComponentAdapter()));
        mutablePicoContainer.registerComponent((ComponentAdapter)new CurrentTimeUtilComponentAdapter());
    }

    private static MutablePicoContainer createContainer(MutablePicoContainer mutablePicoContainer, Logger logger) {
        MutablePicoContainer mutablePicoContainer2 = mutablePicoContainer.makeChildContainer();
        logger.debug("Created Container with Parent");
        return mutablePicoContainer2;
    }

    private static MutablePicoContainer createContainer(Logger logger) {
        ConstructorInjectionComponentAdapterFactory constructorInjectionComponentAdapterFactory = new ConstructorInjectionComponentAdapterFactory();
        CachingComponentAdapterFactory cachingComponentAdapterFactory = new CachingComponentAdapterFactory((ComponentAdapterFactory)constructorInjectionComponentAdapterFactory);
        DefaultPicoContainer defaultPicoContainer = new DefaultPicoContainer((ComponentAdapterFactory)cachingComponentAdapterFactory);
        defaultPicoContainer.registerComponentInstance(ComponentAdapterFactory.class, (Object)constructorInjectionComponentAdapterFactory);
        logger.debug("Created Top Level Container");
        return defaultPicoContainer;
    }

    public static MutablePicoContainer createChildContainer(MutablePicoContainer mutablePicoContainer) {
        return mutablePicoContainer.makeChildContainer();
    }

    public static void dumpDependencies(PicoContainer picoContainer, Class clazz) {
        try {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < constructorArray.length; ++i) {
                Constructor<?> constructor = constructorArray[i];
                stringBuffer.append(constructor);
                stringBuffer.append("\n");
                Class<?>[] classArray = constructor.getParameterTypes();
                for (int j = 0; j < classArray.length; ++j) {
                    Class<?> clazz2 = classArray[j];
                    boolean bl = picoContainer.getComponentInstanceOfType(clazz2) != null;
                    stringBuffer.append(j);
                    stringBuffer.append(": ");
                    stringBuffer.append(clazz2);
                    stringBuffer.append(" -> ");
                    stringBuffer.append(bl);
                    stringBuffer.append("\n");
                }
            }
            System.err.println(stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

