/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.adapter.impl.configuration;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.plugins.jbossas5.adapter.api.AbstractPropertyListAdapter;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapter;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListToCollectionValueAdapter
extends AbstractPropertyListAdapter
implements PropertyAdapter<PropertyList, PropertyDefinitionList> {
    private static final Log LOG = LogFactory.getLog(PropertyListToCollectionValueAdapter.class);

    @Override
    public void populateMetaValueFromProperty(PropertyList property, MetaValue metaValue, PropertyDefinitionList propertyDefinition) {
        PropertyDefinition listMemberPropDef = propertyDefinition.getMemberDefinition();
        List listMemberProps = property.getList();
        CollectionValueSupport collectionValue = (CollectionValueSupport)metaValue;
        MetaType listMemberMetaType = collectionValue.getMetaType().getElementType();
        MetaValue[] listMemberValues = new MetaValue[listMemberProps.size()];
        PropertyAdapter propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(listMemberMetaType);
        int memberIndex = 0;
        for (Property listMemberProp : listMemberProps) {
            MetaValue listMemberValue = propertyAdapter.convertToMetaValue(listMemberProp, listMemberPropDef, listMemberMetaType);
            listMemberValues[memberIndex++] = listMemberValue;
        }
        collectionValue.setElements(listMemberValues);
    }

    @Override
    public MetaValue convertToMetaValue(PropertyList propertyList, PropertyDefinitionList propertyListDefinition, MetaType metaType) {
        LOG.debug((Object)("GetMetaValue for property: " + propertyList.getName() + " values: " + propertyList.getList().toString()));
        CollectionMetaType collectionMetaType = (CollectionMetaType)metaType;
        MetaType memberMetaType = collectionMetaType.getElementType();
        CollectionMetaType collectionType = new CollectionMetaType(propertyListDefinition.getName(), memberMetaType);
        CollectionValueSupport collectionValue = new CollectionValueSupport(collectionType);
        this.populateMetaValueFromProperty(propertyList, (MetaValue)collectionValue, propertyListDefinition);
        return collectionValue;
    }

    @Override
    public void populatePropertyFromMetaValue(PropertyList propList, MetaValue metaValue, PropertyDefinitionList propDefList) {
        PropertyDefinition memberPropDef = propDefList.getMemberDefinition();
        if (propList != null) {
            propList.getList().clear();
            if (metaValue != null) {
                CollectionValue collectionValue = (CollectionValue)metaValue;
                MetaType listMemberMetaType = collectionValue.getMetaType().getElementType();
                MetaValue[] listMemberValues = collectionValue.getElements();
                PropertyAdapter propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(listMemberMetaType);
                for (MetaValue listMemberValue : listMemberValues) {
                    Object listMemberProp = propertyAdapter.convertToProperty(listMemberValue, memberPropDef);
                    propList.add(listMemberProp);
                }
            }
        }
    }
}

