/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.mc.deployer;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.bean.metadata.ManagedBeanDeploymentMetaData;
import org.jboss.managed.bean.metadata.ManagedBeanMetaData;
import org.jboss.managed.bean.metadata.jbmeta.ManagedBeanMetaDataImpl;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.switchboard.mc.deployer.AbstractSwitchBoardDeployer;
import org.jboss.switchboard.spi.Barrier;

public class ManagedBeanSwitchBoardDeployer
extends AbstractSwitchBoardDeployer {
    private static Logger logger = Logger.getLogger(ManagedBeanSwitchBoardDeployer.class);

    public ManagedBeanSwitchBoardDeployer(JavaEEComponentInformer informer) {
        super(informer);
        this.setInput(ManagedBeanDeploymentMetaData.class);
        this.setOutput(BeanMetaData.class);
        this.addOutput(Barrier.class);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        ManagedBeanDeploymentMetaData managedBeanDeployment = (ManagedBeanDeploymentMetaData)unit.getAttachment(ManagedBeanDeploymentMetaData.class);
        Collection managedBeans = managedBeanDeployment.getManagedBeans();
        if (managedBeans == null || managedBeans.isEmpty()) {
            return;
        }
        HashSet<EnvironmentRefsGroupMetaData> environments = new HashSet<EnvironmentRefsGroupMetaData>();
        for (ManagedBeanMetaData managedBean : managedBeans) {
            ManagedBeanMetaDataImpl mbMetadata;
            if (!(managedBean instanceof ManagedBeanMetaDataImpl) || (mbMetadata = (ManagedBeanMetaDataImpl)managedBean).getEnvironment() == null) continue;
            environments.add(mbMetadata.getEnvironment());
        }
        this.process(unit, environments);
    }

    protected void attachBarrier(DeploymentUnit deploymentUnit, Barrier switchBoard) {
        deploymentUnit.addAttachment(Barrier.class, (Object)switchBoard);
    }

    protected void attachSwitchBoardBMD(DeploymentUnit deploymentUnit, BeanMetaData switchBoardBMD) {
        deploymentUnit.addAttachment(BeanMetaData.class + ":" + switchBoardBMD.getName(), (Object)switchBoardBMD);
    }
}

