/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.helpers;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.structure.spi.helpers.DeployerTracking;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingMutableAttachments
implements MutableAttachments {
    private static final long serialVersionUID = 1L;
    private MutableAttachments delegate;
    private Map<String, String> createdDeployer = new ConcurrentHashMap<String, String>();
    private Map<String, Set<String>> referencedDeployer = new ConcurrentHashMap<String, Set<String>>();

    public TrackingMutableAttachments(MutableAttachments delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
    }

    public String getCreated(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        return this.createdDeployer.get(name);
    }

    public Set<String> getReferenced(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        Set<String> result = this.referencedDeployer.get(name);
        if (result == null) {
            return null;
        }
        return Collections.unmodifiableSet(result);
    }

    void created(String name) {
        this.createdDeployer.put(name, DeployerTracking.getCurrentDeployer());
    }

    void referenced(String name) {
        Set<String> deployers = this.referencedDeployer.get(name);
        if (deployers == null) {
            deployers = new CopyOnWriteArraySet<String>();
            this.referencedDeployer.put(name, deployers);
        }
        deployers.add(DeployerTracking.getCurrentDeployer());
    }

    public <T> T addAttachment(Class<T> type, T attachment) {
        Object result = this.delegate.addAttachment(type, attachment);
        if (result == null) {
            this.created(type.getName());
        } else {
            this.referenced(type.getName());
        }
        return (T)result;
    }

    public Object addAttachment(String name, Object attachment) {
        Object result = this.delegate.addAttachment(name, attachment);
        if (result == null) {
            this.created(name);
        } else {
            this.referenced(name);
        }
        return result;
    }

    public <T> T addAttachment(String name, T attachment, Class<T> expectedType) {
        Object result = this.delegate.addAttachment(name, attachment, expectedType);
        if (result == null) {
            this.created(name);
        } else {
            this.referenced(name);
        }
        return (T)result;
    }

    public void clear() {
        this.createdDeployer.clear();
        this.referencedDeployer.clear();
        this.delegate.clear();
    }

    public void clearChangeCount() {
        this.delegate.clearChangeCount();
    }

    public <T> T getAttachment(Class<T> type) {
        Object result = this.delegate.getAttachment(type);
        if (result != null) {
            this.referenced(type.getName());
        }
        return (T)result;
    }

    public <T> T getAttachment(String name, Class<T> expectedType) {
        Object result = this.delegate.getAttachment(name, expectedType);
        if (result != null) {
            this.referenced(name);
        }
        return (T)result;
    }

    public Object getAttachment(String name) {
        Object result = this.delegate.getAttachment(name);
        if (result != null) {
            this.referenced(name);
        }
        return result;
    }

    public Map<String, Object> getAttachments() {
        return this.delegate.getAttachments();
    }

    public int getChangeCount() {
        return this.delegate.getChangeCount();
    }

    public boolean hasAttachments() {
        return this.delegate.hasAttachments();
    }

    public boolean isAttachmentPresent(Class<?> type) {
        boolean result = this.delegate.isAttachmentPresent(type);
        if (result) {
            this.referenced(type.getName());
        }
        return result;
    }

    public boolean isAttachmentPresent(String name, Class<?> expectedType) {
        boolean result = this.delegate.isAttachmentPresent(name, expectedType);
        if (result) {
            this.referenced(name);
        }
        return result;
    }

    public boolean isAttachmentPresent(String name) {
        boolean result = this.delegate.isAttachmentPresent(name);
        if (result) {
            this.referenced(name);
        }
        return result;
    }

    public <T> T removeAttachment(Class<T> type) {
        Object result = this.delegate.removeAttachment(type);
        if (result != null) {
            this.referenced(type.getName());
        }
        return (T)result;
    }

    public <T> T removeAttachment(String name, Class<T> expectedType) {
        Object result = this.delegate.removeAttachment(name, expectedType);
        if (result != null) {
            this.referenced(name);
        }
        return (T)result;
    }

    public Object removeAttachment(String name) {
        Object result = this.delegate.removeAttachment(name);
        if (result != null) {
            this.referenced(name);
        }
        return result;
    }

    public void setAttachments(Map<String, Object> map) {
        this.delegate.setAttachments(map);
        this.createdDeployer.clear();
        this.referencedDeployer.clear();
    }
}

