/*************************************************************************

    Lock-On hardware

*************************************************************************/

/* Calculated from CRT controller writes */
#define PIXEL_CLOCK            (XTAL_21MHz / 3)
#define FRAMEBUFFER_CLOCK      XTAL_10MHz
#define HBSTART                320
#define HBEND                  0
#define HTOTAL                 448
#define VBSTART                240
#define VBEND                  0
#define VTOTAL                 280


class lockon_state : public driver_device
{
public:
	lockon_state(running_machine &machine, const driver_device_config_base &config)
		: driver_device(machine, config) { }

	/* memory pointers */
	UINT16	*m_char_ram;
	UINT16	*m_hud_ram;
	UINT16	*m_scene_ram;
	UINT16	*m_ground_ram;
	UINT16	*m_object_ram;

	size_t	m_hudram_size;
	size_t	m_objectram_size;
	size_t	m_groundram_size;

	/* video-related */
	tilemap_t   *m_tilemap;
	UINT8	      m_ground_ctrl;
	UINT16      m_scroll_h;
	UINT16      m_scroll_v;
	bitmap_t    *m_front_buffer;
	bitmap_t    *m_back_buffer;
	emu_timer   *m_bufend_timer;
	emu_timer   *m_cursor_timer;

	/* Rotation Control */
	UINT16      m_xsal;
	UINT16      m_x0ll;
	UINT16      m_dx0ll;
	UINT16      m_dxll;
	UINT16      m_ysal;
	UINT16      m_y0ll;
	UINT16      m_dy0ll;
	UINT16      m_dyll;

	/* Object palette RAM control */
	UINT32      m_iden;
	UINT8	*     m_obj_pal_ram;
	UINT32      m_obj_pal_latch;
	UINT32      m_obj_pal_addr;

	/* misc */
	UINT8       m_ctrl_reg;
	UINT32      m_main_inten;

	/* devices */
	device_t *m_maincpu;
	device_t *m_audiocpu;
	device_t *m_ground;
	device_t *m_object;
	device_t *m_f2203_1l;
	device_t *m_f2203_2l;
	device_t *m_f2203_3l;
	device_t *m_f2203_1r;
	device_t *m_f2203_2r;
	device_t *m_f2203_3r;
};


/*----------- defined in video/lockon.c -----------*/

PALETTE_INIT( lockon );
VIDEO_START( lockon );
SCREEN_UPDATE( lockon );
SCREEN_EOF( lockon );
READ16_HANDLER( lockon_crtc_r );
WRITE16_HANDLER( lockon_crtc_w );
WRITE16_HANDLER( lockon_rotate_w );
WRITE16_HANDLER( lockon_fb_clut_w );
WRITE16_HANDLER( lockon_scene_h_scr_w );
WRITE16_HANDLER( lockon_scene_v_scr_w );
WRITE16_HANDLER( lockon_ground_ctrl_w );
WRITE16_HANDLER( lockon_char_w );

WRITE16_HANDLER( lockon_tza112_w );
READ16_HANDLER( lockon_obj_4000_r );
WRITE16_HANDLER( lockon_obj_4000_w );
