/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.dialog.DialogHinweisUpdate;
import mediathek.tool.MVFunctionSys;

public class ProgrammUpdateSuchen {
    private static final String PROGRAM_VERSION = "Program_Version";
    private static final String PROGRAM_RELEASE_INFO = "Program_Release_Info";
    private static final String DOWNLOAD_PROGRAM = "Download_Programm";
    private static final String INFO = "Info";
    private static final String INFO_NO = "number";
    private final LinkedList<String[]> listInfos = new LinkedList();
    private String version;
    private String release;
    private String downloadUrlProgramm;
    private String[] ret;
    private boolean anzeigen;
    private boolean hinweis;
    private boolean hinweiseAlleAnzeigen;
    private boolean neueVersion = false;

    public boolean checkVersion(boolean aanzeigen, boolean hhinweis, boolean hhinweiseAlleAnzeigen) {
        this.anzeigen = aanzeigen;
        this.hinweis = hhinweis;
        this.hinweiseAlleAnzeigen = hhinweiseAlleAnzeigen;
        this.neueVersion = false;
        try {
            this.ret = this.suchen();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public synchronized void run() {
                    if (ProgrammUpdateSuchen.this.hinweis) {
                        ProgrammUpdateSuchen.this.hinweiseAnzeigen(ProgrammUpdateSuchen.this.hinweiseAlleAnzeigen);
                    }
                    ProgrammUpdateSuchen.this.version = ProgrammUpdateSuchen.this.ret[0];
                    ProgrammUpdateSuchen.this.release = ProgrammUpdateSuchen.this.ret[1];
                    ProgrammUpdateSuchen.this.downloadUrlProgramm = ProgrammUpdateSuchen.this.ret[2];
                    if (!ProgrammUpdateSuchen.this.version.equals("")) {
                        Daten.mVConfig.add("BuildNr", MVFunctionSys.getBuildNr());
                        Daten.mVConfig.add("update-datum", new SimpleDateFormat("yyyyMMdd").format(new Date()));
                        if (ProgrammUpdateSuchen.this.checkObNeueVersion(ProgrammUpdateSuchen.this.version, "11")) {
                            ProgrammUpdateSuchen.this.neueVersion = true;
                            new DialogHinweisUpdate(null, true, "Eine neue Version liegt vor", "   ==================================================\n   Neue Version:\n   " + ProgrammUpdateSuchen.this.version + "\n\n" + "   ==================================================\n" + "   \u00c4nderungen:\n" + "   " + ProgrammUpdateSuchen.this.release + "\n\n" + "   ==================================================\n" + "   URL:\n" + "   " + ProgrammUpdateSuchen.this.downloadUrlProgramm + "\n\n").setVisible(true);
                        } else {
                            DialogHinweisUpdate dialog = new DialogHinweisUpdate(null, true, "Update suchen", "Alles aktuell!");
                            if (ProgrammUpdateSuchen.this.anzeigen) {
                                dialog.setVisible(true);
                            }
                        }
                    } else {
                        new DialogHinweisUpdate(null, true, "Fehler bei der Versionspr\u00fcfung!", "Es ist ein Fehler aufgetreten!\n\n").setVisible(true);
                    }
                }
            });
        }
        catch (Exception ex) {
            Log.fehlerMeldung(159002583, ex);
        }
        return this.neueVersion;
    }

    private void hinweiseAnzeigen(boolean alleAnzeigen) {
        if (this.listInfos.size() > 0) {
            try {
                StringBuilder text = new StringBuilder();
                int angezeigt = 0;
                if (Daten.mVConfig.get("Hinweis-Nr-angezeigt").equals("")) {
                    Daten.mVConfig.add("Hinweis-Nr-angezeigt", Integer.toString(-1));
                } else {
                    angezeigt = Integer.parseInt(Daten.mVConfig.get("Hinweis-Nr-angezeigt"));
                }
                for (String[] h : this.listInfos) {
                    if (!alleAnzeigen && angezeigt >= Integer.parseInt(h[0])) continue;
                    text.append("=======================================\n");
                    text.append(h[1]);
                    text.append("\n");
                    text.append("\n");
                }
                if (text.length() > 0) {
                    new DialogHinweisUpdate(null, true, "Infos", text.toString()).setVisible(true);
                    Daten.mVConfig.add("Hinweis-Nr-angezeigt", Integer.toString(this.listInfos.size()));
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(693298731, ex);
            }
        } else if (alleAnzeigen) {
            new DialogHinweisUpdate(null, true, "Infos", "keine vorhanden").setVisible(true);
        }
    }

    private boolean checkObNeueVersion(String infoVersion, String currentVersion) {
        try {
            int info = Integer.parseInt(infoVersion);
            int ich = Integer.parseInt(currentVersion);
            if (info > ich) {
                return true;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(683021193, ex);
        }
        return false;
    }

    private String[] suchen() throws IOException, XMLStreamException {
        String[] ret = new String[]{"", "", ""};
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        int timeout = 10000;
        URLConnection conn = new URL("http://zdfmediathk.sourceforge.net/prog-info.xml").openConnection();
        conn.setRequestProperty("User-Agent", Daten.getUserAgent());
        conn.setReadTimeout(timeout);
        conn.setConnectTimeout(timeout);
        InputStreamReader inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
        XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
        while (parser.hasNext()) {
            int event = parser.next();
            if (event != 1) continue;
            if (parser.getLocalName().equals(PROGRAM_VERSION)) {
                ret[0] = parser.getElementText();
                continue;
            }
            if (parser.getLocalName().equals(PROGRAM_RELEASE_INFO)) {
                ret[1] = parser.getElementText();
                continue;
            }
            if (parser.getLocalName().equals(DOWNLOAD_PROGRAM)) {
                ret[2] = parser.getElementText();
                continue;
            }
            if (!parser.getLocalName().equals(INFO)) continue;
            int count = parser.getAttributeCount();
            String nummer = "";
            for (int i = 0; i < count; ++i) {
                if (!parser.getAttributeName(i).toString().equals(INFO_NO)) continue;
                nummer = parser.getAttributeValue(i);
            }
            String info = parser.getElementText();
            if (nummer.equals("") || info.equals("")) continue;
            this.listInfos.add(new String[]{nummer, info});
        }
        return ret;
    }
}

