/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import com.jidesoft.utils.SystemInfo;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mediathek.controller.Log;
import mediathek.res.GetIcon;
import mediathek.tool.EscBeenden;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVMessageDialog;

public class DialogProgrammOrdnerOeffnen
extends JDialog {
    public boolean ok = false;
    public String ziel;
    private Frame parentComponent = null;
    private JButton jButtonAbbrechen;
    private JButton jButtonOk;
    private JButton jButtonZiel;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldProgramm;

    public DialogProgrammOrdnerOeffnen(Frame parent, boolean modal, String zziel, String titel, String text) {
        super(parent, modal);
        this.parentComponent = parent;
        this.initComponents();
        this.jButtonZiel.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.setTitle(titel);
        this.jTextArea1.setText(text);
        this.jButtonOk.addActionListener(new OkBeobachter());
        this.jButtonAbbrechen.addActionListener(new AbbrechenBeobachter());
        this.jButtonZiel.addActionListener(new ZielBeobachter());
        this.jTextFieldProgramm.setText(zziel);
        this.ziel = zziel;
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogProgrammOrdnerOeffnen.this.ok = false;
                DialogProgrammOrdnerOeffnen.this.beenden();
            }
        };
    }

    private boolean check() {
        boolean ret = false;
        String programm = this.jTextFieldProgramm.getText();
        if (!programm.equals("")) {
            try {
                if (!new File(programm).exists()) {
                    MVMessageDialog.showMessageDialog(this.parentComponent, "Das Programm:  \"" + programm + "\"" + "  existiert nicht!", "Fehler", 0);
                } else if (!new File(programm).canExecute()) {
                    MVMessageDialog.showMessageDialog(this.parentComponent, "Das Programm:  \"" + programm + "\"" + "  kann nicht ausgef\u00fchrt werden!", "Fehler", 0);
                } else {
                    this.ziel = programm;
                    ret = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this.jButtonZiel = new JButton();
        this.jTextFieldProgramm = new JTextField();
        JLabel jLabel1 = new JLabel();
        this.jButtonAbbrechen = new JButton();
        this.jButtonOk = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(2);
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonZiel.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        jLabel1.setText("Programm:");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldProgramm, -1, 368, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonZiel).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel1).addComponent(this.jTextFieldProgramm, -2, -1, -2).addComponent(this.jButtonZiel)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonZiel, this.jTextFieldProgramm);
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jButtonOk.setText("Ok");
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(4);
        this.jTextArea1.setText("\n Der Dateimanager zum Anzeigen des Speicherordners wird nicht gefunden.\n Dateimanager selbst ausw\u00e4hlen.\n");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen)).addComponent(this.jScrollPane1)).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 113, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAbbrechen).addComponent(this.jButtonOk)).addContainerGap()));
        this.pack();
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                FileDialog chooser = new FileDialog(DialogProgrammOrdnerOeffnen.this.parentComponent, "Dateimanager suchen");
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        DialogProgrammOrdnerOeffnen.this.jTextFieldProgramm.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(398762109, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!DialogProgrammOrdnerOeffnen.this.jTextFieldProgramm.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(DialogProgrammOrdnerOeffnen.this.jTextFieldProgramm.getText()));
                } else {
                    chooser.setCurrentDirectory(new File(GuiFunktionen.getHomePath()));
                }
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        DialogProgrammOrdnerOeffnen.this.jTextFieldProgramm.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(107458930, ex);
                    }
                }
            }
        }
    }

    private class AbbrechenBeobachter
    implements ActionListener {
        private AbbrechenBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogProgrammOrdnerOeffnen.this.ok = false;
            DialogProgrammOrdnerOeffnen.this.beenden();
        }
    }

    private class OkBeobachter
    implements ActionListener {
        private OkBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DialogProgrammOrdnerOeffnen.this.check()) {
                DialogProgrammOrdnerOeffnen.this.ok = true;
                DialogProgrammOrdnerOeffnen.this.beenden();
            }
        }
    }
}

