/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mediathek.controller.starter.MVBandwidthTokenBucket;

public class MVInputStream
extends InputStream {
    private final InputStream iStream;
    private MVBandwidthTokenBucket bucket = null;
    private final BandwidthCalculationTask calculationTask;

    public MVInputStream(InputStream in, Timer calculationTimer) {
        this.iStream = in;
        this.bucket = new MVBandwidthTokenBucket();
        this.bucket.ensureBucketThreadIsRunning();
        this.calculationTask = new BandwidthCalculationTask();
        calculationTimer.scheduleAtFixedRate((TimerTask)this.calculationTask, 0L, 1000L);
    }

    @Override
    public void close() throws IOException {
        this.iStream.close();
        super.close();
        this.calculationTask.cancel();
    }

    @Override
    public int read() throws IOException {
        this.bucket.takeBlocking();
        int bytesRead = this.iStream.read();
        if (bytesRead != -1) {
            this.calculationTask.incrementBytesRead(1);
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.bucket.takeBlocking(b.length);
        int bytesRead = this.iStream.read(b);
        if (bytesRead != -1) {
            this.calculationTask.incrementBytesRead(bytesRead);
        }
        return bytesRead;
    }

    public long getBandwidth() {
        return this.calculationTask.getBandwidth();
    }

    public String toString() {
        long bytesRead = this.calculationTask.getTotalBytesRead();
        long bandwidth = this.calculationTask.getBandwidth();
        return "Download: gelesen: " + (bytesRead > 0L ? bytesRead / 1000L : 0L) + " kB, " + "Bandbreite: " + (bandwidth > 0L ? bandwidth / 1000L : 0L) + " kB/s ";
    }

    private class BandwidthCalculationTask
    extends TimerTask {
        private long oldTotalBytes = 0L;
        private long totalBytesRead = 0L;
        private long bandwidth = 0L;
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        private BandwidthCalculationTask() {
        }

        @Override
        public void run() {
            this.lock.writeLock().lock();
            this.bandwidth = this.totalBytesRead - this.oldTotalBytes;
            this.oldTotalBytes = this.totalBytesRead;
            this.lock.writeLock().unlock();
        }

        public void incrementBytesRead(int value) {
            this.lock.writeLock().lock();
            this.totalBytesRead += (long)value;
            this.lock.writeLock().unlock();
        }

        public long getTotalBytesRead() {
            this.lock.readLock().lock();
            long res = this.totalBytesRead;
            this.lock.readLock().unlock();
            return res;
        }

        public long getBandwidth() {
            this.lock.readLock().lock();
            long bw = this.bandwidth;
            this.lock.readLock().unlock();
            return bw;
        }
    }
}

