/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekNdr
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "NDR";
    private MSStringBuilder seiteAlle = new MSStringBuilder(65536);

    public MediathekNdr(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 250, startPrio);
    }

    @Override
    void addToList() {
        String ADRESSE = "http://www.ndr.de/mediathek/sendungen_a-z/index.html";
        String MUSTER_URL1 = "<li><a href=\"/mediathek/mediatheksuche105_broadcast-";
        this.listeThemen.clear();
        this.meldungStart();
        MSStringBuilder seite = new MSStringBuilder(65536);
        seite = this.getUrlIo.getUri(SENDERNAME, "http://www.ndr.de/mediathek/sendungen_a-z/index.html", "UTF-8", 5, seite, "");
        int pos = 0;
        String url = "";
        String thema = "";
        while ((pos = seite.indexOf("<li><a href=\"/mediathek/mediatheksuche105_broadcast-", pos)) != -1) {
            try {
                int pos1 = pos += "<li><a href=\"/mediathek/mediatheksuche105_broadcast-".length();
                int pos2 = seite.indexOf("\"", pos);
                if (pos2 != -1) {
                    url = seite.substring(pos1, pos2);
                }
                pos1 = seite.indexOf(">", pos);
                pos2 = seite.indexOf("<", pos);
                if (pos1 != -1 && pos2 != -1 && pos1 < pos2) {
                    thema = seite.substring(pos1 + 1, pos2);
                }
                if (url.equals("")) {
                    MSLog.fehlerMeldung(210367600, "keine Url");
                    continue;
                }
                String url_ = "http://www.ndr.de/mediathek/mediatheksuche105_broadcast-" + url;
                String[] add = new String[]{url_, thema};
                if (MSConfig.loadLongMax()) {
                    if (this.alleSeiteSuchen(url_, thema)) continue;
                    this.listeThemen.addUrl(add);
                    continue;
                }
                this.listeThemen.addUrl(add);
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(332945670, ex);
            }
        }
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatter2 = new SimpleDateFormat("dd.MM.yyyy");
        int maxTage = MSConfig.loadLongMax() ? 30 : 20;
        for (int i = 0; i < maxTage; ++i) {
            String URL2 = "http://www.ndr.de/mediathek/sendung_verpasst/epg1490_date-";
            String tag = formatter1.format(new Date().getTime() - (long)(86400000 * i));
            String date = formatter2.format(new Date().getTime() - (long)(86400000 * i));
            String urlString = "http://www.ndr.de/mediathek/sendung_verpasst/epg1490_date-" + tag + "_display-all.html";
            this.listeThemen.addUrl(new String[]{urlString, date});
        }
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private boolean alleSeiteSuchen(String strUrlFeed, String tthema) {
        boolean ret = false;
        this.seiteAlle = this.getUrlIo.getUri(SENDERNAME, strUrlFeed, "UTF-8", 3, this.seiteAlle, "Thema: " + tthema);
        int pos1 = 0;
        int anz2 = 0;
        try {
            String WEITER = " title=\"Zeige Seite ";
            while ((pos1 = this.seiteAlle.indexOf(" title=\"Zeige Seite ", pos1)) != -1) {
                int pos2 = this.seiteAlle.indexOf("\"", pos1 += " title=\"Zeige Seite ".length());
                if (pos2 == -1) continue;
                String anz = this.seiteAlle.substring(pos1, pos2);
                try {
                    int anz1 = Integer.parseInt(anz);
                    if (anz2 >= anz1) continue;
                    anz2 = anz1;
                }
                catch (Exception ex) {
                    MSLog.fehlerMeldung(643208979, strUrlFeed);
                }
            }
            for (int i = 2; i <= anz2 && i <= 10; ++i) {
                String url_ = strUrlFeed.replace(".html", "_page-" + i + ".html");
                this.listeThemen.addUrl(new String[]{url_, tthema});
                ret = true;
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(913047821, strUrlFeed);
        }
        return ret;
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private MSStringBuilder seite1;
        private MSStringBuilder seite2;
        private MSStringBuilder seite3;
        private ArrayList<String> liste;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekNdr.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
            this.liste = new ArrayList();
        }

        @Override
        public synchronized void run() {
            try {
                String[] link;
                MediathekNdr.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekNdr.this.listeThemen.getListeThemen()) != null) {
                    try {
                        MediathekNdr.this.meldungProgress(link[1]);
                        this.feedEinerSeiteSuchen(link[0], link[1]);
                    }
                    catch (Exception ex) {
                        MSLog.fehlerMeldung(336901211, ex);
                    }
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(554632590, ex);
            }
            MediathekNdr.this.meldungThreadUndFertig();
        }

        /*
         * Unable to fully structure code
         */
        void feedEinerSeiteSuchen(String strUrlFeed, String tthema) {
            MUSTER_URL = "<a href=\"";
            this.seite1 = MediathekNdr.this.getUrlIo.getUri("NDR", strUrlFeed, "UTF-8", 3, this.seite1, "Thema: " + tthema);
            pos = 0;
            thema = tthema;
            datum = "";
            zeit = "";
            durationInSeconds = 0L;
            tage = false;
            try {
                MediathekNdr.this.meldung(strUrlFeed);
                if (this.seite1.indexOf("<strong class=\"time\">") != -1) {
                    muster = "<strong class=\"time\">";
                    tage = true;
                } else {
                    muster = "<span class=\"icon icon_video\"></span>";
                }
                while (!MSConfig.getStop() && (pos = this.seite1.indexOf(muster, pos)) != -1) {
                    url = this.seite1.extract("<a href=\"", "\"", pos += muster.length());
                    if (url.equals("")) {
                        MSLog.fehlerMeldung(659210274, "keine Url feedEinerSeiteSuchen" + strUrlFeed);
                        continue;
                    }
                    if (!url.startsWith("http")) {
                        url = "http://www.ndr.de" + url;
                    }
                    if (tage) {
                        thema = this.seite1.extract("<a href=\"", " title=\"", "\"", pos);
                        titel = this.seite1.extract("<a href=\"", ">", "<", pos);
                        if (titel.contains("(Wdh.)")) continue;
                        if (thema.equals(titel) && thema.contains(" - ")) {
                            thema = thema.substring(0, thema.indexOf(" - ")).trim();
                            titel = titel.substring(titel.indexOf(" - "));
                            titel = titel.replace(" - ", "").trim();
                        }
                    } else {
                        titel = this.seite1.extract(" title=\"", "\"", pos);
                        titel = titel.replace("Zum Video:", "").trim();
                    }
                    if (tage) {
                        tmp = this.seite1.substring(pos, this.seite1.indexOf("<", pos));
                        datum = tthema;
                        try {
                            sdfIn = new SimpleDateFormat("HH:mm");
                            filmDate = sdfIn.parse(tmp);
                            zeit = new SimpleDateFormat("HH:mm:ss").format(filmDate);
                        }
                        catch (Exception ex) {
                            MSLog.fehlerMeldung(795623017, "convertDatum: " + strUrlFeed);
                        }
                    } else {
                        tmp = this.seite1.extract("<div class=\"subline\">", "<", pos);
                        tmp = tmp.replace("Uhr", "").trim();
                        try {
                            sdfIn = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                            filmDate = sdfIn.parse(tmp);
                            datum = new SimpleDateFormat("dd.MM.yyyy").format(filmDate);
                            zeit = new SimpleDateFormat("HH:mm:ss").format(filmDate);
                        }
                        catch (Exception ex) {
                            MSLog.fehlerMeldung(623657941, "convertDatum: " + strUrlFeed);
                        }
                    }
                    if (tage) {
                        duration = this.seite1.extract("\"L&auml;nge\"></span>", "<", pos).trim();
                        try {
                            if (duration.equals("")) ** GOTO lbl84
                            parts = duration.split(":");
                            power = 1L;
                            durationInSeconds = 0L;
                            for (i = parts.length - 1; i >= 0; --i) {
                                durationInSeconds += Long.parseLong(parts[i]) * power;
                                power *= 60L;
                            }
                        }
                        catch (Exception ex) {
                            MSLog.fehlerMeldung(369015497, ex, strUrlFeed);
                        }
                    } else {
                        duration = this.seite1.extract("Video (", ")", pos);
                        duration = duration.replace("min", "").trim();
                        try {
                            if (!duration.equals("")) {
                                parts = duration.split(":");
                                power = 1L;
                                durationInSeconds = 0L;
                                for (i = parts.length - 1; i >= 0; --i) {
                                    durationInSeconds += Long.parseLong(parts[i]) * power;
                                    power *= 60L;
                                }
                            }
                        }
                        catch (Exception ex) {
                            MSLog.fehlerMeldung(369015497, ex, strUrlFeed);
                        }
                    }
lbl84:
                    // 5 sources

                    this.filmSuchen_1(strUrlFeed, thema, titel, url, datum, zeit, durationInSeconds, tage);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(693219870, strUrlFeed);
            }
        }

        void filmSuchen_1(String strUrlThema, String thema, String titel, String filmWebsite, String datum, String zeit, long durationInSeconds, boolean onlyUrl) {
            String MUSTER_URL = "3: {src:'http://";
            this.seite2 = this.getUrl.getUri_Utf(MediathekNdr.SENDERNAME, filmWebsite, this.seite2, "strUrlThema: " + strUrlThema);
            String description = this.extractDescription(this.seite2);
            String[] keywords = this.extractKeywords(this.seite2);
            String subtitle = this.seite2.extract(",tracks: [{ src: \"", "\"");
            if (!subtitle.isEmpty()) {
                subtitle = "http://www.ndr.de" + subtitle;
            }
            MediathekNdr.this.meldung(filmWebsite);
            try {
                int pos1 = this.seite2.indexOf("3: {src:'http://");
                if (pos1 != -1) {
                    int pos2 = this.seite2.indexOf("'", pos1 += "3: {src:'http://".length());
                    if (pos2 != -1) {
                        String url = this.seite2.substring(pos1, pos2);
                        if (!url.equals("")) {
                            url = "http://" + url;
                            if (url.contains("http://media.ndr.de/progressive") && url.contains("hi.mp4")) {
                                url = url.replace("hi.mp4", "hq.mp4");
                            }
                            if (thema.equals("")) {
                                thema = this.seite2.extract("<h1>", "<div class=\"subline\">", "<");
                                if (thema.contains("|")) {
                                    thema = thema.substring(0, thema.lastIndexOf("|"));
                                    thema = thema.trim();
                                }
                                if (thema.contains("-")) {
                                    thema = thema.substring(0, thema.lastIndexOf("-"));
                                    thema = thema.trim();
                                }
                                if (thema.contains("Uhr")) {
                                    thema = "";
                                }
                                if (thema.equals("")) {
                                    thema = MediathekNdr.SENDERNAME;
                                }
                            }
                            DatenFilm film = new DatenFilm(MediathekNdr.SENDERNAME, thema, filmWebsite, titel, url, "", datum, zeit, durationInSeconds, description);
                            film.addUrlSubtitle(subtitle);
                            if (url.contains(".hq.")) {
                                String urlKlein = url.replace(".hq.", ".hi.");
                                film.addUrlKlein(urlKlein, "");
                            }
                            MediathekNdr.this.addFilm(film, onlyUrl);
                        } else {
                            MSLog.fehlerMeldung(623657941, "keine URL: " + filmWebsite);
                        }
                    }
                } else {
                    String json = this.seite2.extract("-player_image-", "_");
                    String pp = this.seite2.extract("id=\"pp_", "\"");
                    if (json.isEmpty() || pp.isEmpty()) {
                        MSLog.fehlerMeldung(915230214, "auch keine json-Url: " + filmWebsite);
                    } else {
                        json = "http://www.ndr.de/fernsehen/" + pp + "-ppjson_image-" + json + ".json";
                        this.filmSuchen_2(strUrlThema, thema, titel, filmWebsite, json, datum, zeit, durationInSeconds, description, subtitle);
                    }
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(699830157, ex);
            }
        }

        void filmSuchen_2(String strUrlThema, String thema, String titel, String filmWebsite, String json, String datum, String zeit, long durationInSeconds, String description, String subtitle) {
            this.seite3 = this.getUrl.getUri_Utf(MediathekNdr.SENDERNAME, json, this.seite3, "strUrlThema: " + strUrlThema);
            String url_hd = "";
            String url_xl = "";
            String url_m = "";
            this.seite3.extractList("\"src\": \"http://media.ndr.de", "\"", 0, "http://media.ndr.de", this.liste);
            for (String s : this.liste) {
                if (s.endsWith(".hd.mp4")) {
                    url_hd = s;
                    continue;
                }
                if (s.endsWith(".hq.mp4")) {
                    url_xl = s;
                    continue;
                }
                if (!s.endsWith(".hi.mp4")) continue;
                url_m = s;
            }
            this.liste.clear();
            if (url_xl.isEmpty()) {
                url_xl = url_m;
                url_m = "";
            }
            if (!url_xl.isEmpty()) {
                DatenFilm film = new DatenFilm(MediathekNdr.SENDERNAME, thema, filmWebsite, titel, url_xl, "", datum, zeit, durationInSeconds, description);
                if (!subtitle.isEmpty()) {
                    film.addUrlSubtitle(subtitle);
                }
                if (!url_hd.isEmpty()) {
                    film.addUrlHd(url_hd, "");
                }
                if (!url_m.isEmpty()) {
                    film.addUrlKlein(url_m, "");
                }
                MediathekNdr.this.addFilm(film);
            } else {
                MSLog.fehlerMeldung(915234210, "keine URL im json: " + filmWebsite);
            }
        }

        private String extractDescription(MSStringBuilder page) {
            String desc = this.extractString(page, "<meta property=\"og:description\" content=\"", "\"");
            if (desc == null) {
                return "";
            }
            return desc;
        }

        private String[] extractKeywords(MSStringBuilder page) {
            String keywords = this.extractString(page, "<meta name=\"keywords\"  lang=\"de\" content=\"", "\"");
            if (keywords == null) {
                return new String[]{""};
            }
            String[] k = keywords.split(",");
            for (int i = 0; i < k.length; ++i) {
                k[i] = k[i].trim();
            }
            return k;
        }

        private String extractString(MSStringBuilder source, String startMarker, String endMarker) {
            int start = source.indexOf(startMarker);
            if (start == -1) {
                return null;
            }
            int end = source.indexOf(endMarker, start += startMarker.length());
            if (end == -1) {
                return null;
            }
            return source.substring(start, end);
        }
    }
}

