/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmlisten;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipInputStream;
import javax.swing.event.EventListenerList;
import msearch.daten.DatenFilm;
import msearch.daten.ListeFilme;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import org.tukaani.xz.XZInputStream;

public class MSFilmlisteLesen {
    private static WorkMode workMode = WorkMode.NORMAL;
    private final EventListenerList listeners = new EventListenerList();
    private int max = 0;
    private int progress = 0;
    private static final int TIMEOUT = 10000;
    private static final int PROGRESS_MAX = 100;
    private long seconds = 0L;

    public void addAdListener(MSListenerFilmeLaden listener) {
        this.listeners.add(MSListenerFilmeLaden.class, listener);
    }

    public static void setWorkMode(WorkMode mode) {
        workMode = mode;
    }

    private InputStream getInputStreamForLocation(String source) throws Exception {
        InputStream in;
        long size = 0L;
        if (source.startsWith("http")) {
            URI uri = new URI(source);
            HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("User-Agent", MSConfig.getUserAgent());
            if (conn.getResponseCode() < 400) {
                size = conn.getContentLengthLong();
            }
            in = new SizeInputStream(conn.getInputStream(), size, uri.toASCIIString());
        } else {
            this.notifyProgress(source, "Download", 100);
            in = new FileInputStream(source);
        }
        return in;
    }

    private InputStream selectDecompressor(String source, InputStream in) throws Exception {
        if (source.endsWith(".xz")) {
            in = new XZInputStream(in);
        } else if (source.endsWith(".zip")) {
            ZipInputStream zipInputStream = new ZipInputStream(in);
            zipInputStream.getNextEntry();
            in = zipInputStream;
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFilmListe(String source, ListeFilme listeFilme, int days) {
        MSLog.systemMeldung("Liste Filme lesen von: " + source);
        String sender = "";
        String thema = "";
        JsonParser jp = null;
        listeFilme.clear();
        this.notifyStart(source, 100);
        if (days > 0) {
            long maxDays = 86400000L * (long)days;
            this.seconds = new Date().getTime() - maxDays;
        } else {
            this.seconds = 0L;
        }
        try {
            JsonToken jsonToken;
            InputStream in = this.selectDecompressor(source, this.getInputStreamForLocation(source));
            jp = new JsonFactory().createParser(in);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                throw new IllegalStateException("Expected data to start with an Object");
            }
            while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
                if (!jp.isExpectedStartArrayToken()) continue;
                for (int k = 0; k < 5; ++k) {
                    listeFilme.metaDaten[k] = jp.nextTextValue();
                }
            }
            while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
                if (!jp.isExpectedStartArrayToken()) continue;
                jp.nextToken();
                break;
            }
            while (!MSConfig.getStop() && (jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
                if (!jp.isExpectedStartArrayToken()) continue;
                DatenFilm datenFilm = new DatenFilm();
                for (int i = 0; i < DatenFilm.COLUMN_NAMES_JSON.length; ++i) {
                    if (workMode == WorkMode.FASTAUTO && (DatenFilm.COLUMN_NAMES_JSON[i] == 10 || DatenFilm.COLUMN_NAMES_JSON[i] == 13 || DatenFilm.COLUMN_NAMES_JSON[i] == 11)) {
                        jp.nextToken();
                        continue;
                    }
                    datenFilm.arr[DatenFilm.COLUMN_NAMES_JSON[i]] = jp.nextTextValue();
                    if (datenFilm.arr[DatenFilm.COLUMN_NAMES_JSON[i]] != null) continue;
                    datenFilm.arr[DatenFilm.COLUMN_NAMES_JSON[i]] = "";
                }
                if (datenFilm.arr[1].isEmpty()) {
                    datenFilm.arr[1] = sender;
                } else {
                    sender = datenFilm.arr[1];
                }
                if (datenFilm.arr[2].isEmpty()) {
                    datenFilm.arr[2] = thema;
                } else {
                    thema = datenFilm.arr[2];
                }
                listeFilme.importFilmliste(datenFilm);
                if (this.seconds <= 0L || this.checkDate(datenFilm)) continue;
                listeFilme.remove(datenFilm);
            }
            jp.close();
        }
        catch (FileNotFoundException ex) {
            MSLog.fehlerMeldung(894512369, (Exception)ex, "FilmListe: " + source);
            listeFilme.clear();
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(945123641, ex, "FilmListe: " + source);
            listeFilme.clear();
        }
        finally {
            try {
                if (jp != null) {
                    jp.close();
                }
            }
            catch (Exception ex) {}
        }
        if (MSConfig.getStop()) {
            MSLog.systemMeldung("--> Abbruch");
            listeFilme.clear();
        }
        this.notifyFertig(source, listeFilme);
    }

    private boolean checkDate(DatenFilm film) {
        try {
            if (film.datumFilm.getTime() != 0L && film.datumFilm.getTime() < this.seconds) {
                return false;
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(495623014, ex);
        }
        return true;
    }

    private void notifyStart(String url, int mmax) {
        this.max = mmax;
        this.progress = 0;
        for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])this.listeners.getListeners(MSListenerFilmeLaden.class)) {
            l.start(new MSListenerFilmeLadenEvent(url, "", this.max, 0, 0, false));
        }
    }

    private void notifyProgress(String url, String text, int p) {
        this.progress = p;
        if (this.progress > this.max) {
            this.progress = this.max;
        }
        for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])this.listeners.getListeners(MSListenerFilmeLaden.class)) {
            l.progress(new MSListenerFilmeLadenEvent(url, text, this.max, this.progress, 0, false));
        }
    }

    private void notifyFertig(String url, ListeFilme liste) {
        MSLog.systemMeldung("Liste Filme gelesen am: " + new SimpleDateFormat("dd.MM.yyyy, HH:mm").format(new Date()));
        MSLog.systemMeldung("  erstellt am: " + liste.genDate());
        MSLog.systemMeldung("  Anzahl Filme: " + liste.size());
        for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])this.listeners.getListeners(MSListenerFilmeLaden.class)) {
            l.fertig(new MSListenerFilmeLadenEvent(url, "", this.max, this.progress, 0, false));
        }
    }

    private class SizeInputStream
    extends InputStream {
        private final long size;
        private long bytesRead = 0L;
        private InputStream in = null;
        private long progress;
        private long oldProgress;
        private final String from;

        public SizeInputStream(InputStream in, long size, String from) {
            this.in = in;
            this.size = size;
            this.from = from;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b != -1) {
                ++this.bytesRead;
                this.progress();
            }
            return b;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int read = this.in.read(b);
            this.bytesRead += (long)read;
            this.progress();
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.in.read(b, off, len);
            this.bytesRead += (long)read;
            this.progress();
            return read;
        }

        private void progress() {
            if (this.size > 0L) {
                this.progress = this.bytesRead * 100L / this.size;
                if (this.progress != this.oldProgress) {
                    this.oldProgress = this.progress;
                    MSFilmlisteLesen.this.notifyProgress(this.from, "Download", (int)this.progress);
                }
            }
        }
    }

    public static enum WorkMode {
        NORMAL,
        FASTAUTO;

    }
}

