/*
 * Decompiled with CFR 0.152.
 */
package msearch.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.gui.MSearchGui;
import msearch.gui.MSearchGuiLoad;
import msearch.tool.MSConfig;

public class PanelSenderSearch
extends JPanel {
    private JButton[] buttonSender;
    private final String[] senderArray;
    private final MSearchGuiLoad filmeLaden;
    private JButton jButtonStop;
    private JLabel jLabel1;
    private JLabel jLabelAnzahl;
    private JLabel jLabelProgress;
    private JProgressBar jProgressBar1;
    private JPanel panelSender;

    public PanelSenderSearch(MSearchGuiLoad filmeLaden_) {
        this.initComponents();
        this.filmeLaden = filmeLaden_;
        this.jLabelAnzahl.setText("");
        this.senderArray = this.filmeLaden.getSenderNamen();
        this.buttonSender = new JButton[this.senderArray.length];
        for (int i = 0; i < this.filmeLaden.getSenderNamen().length; ++i) {
            this.buttonSender[i] = new JButton(this.senderArray[i]);
            this.buttonSender[i].addActionListener(new BeobSenderLaden(this.senderArray[i]));
        }
        this.addSender();
        this.jButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MSConfig.setStop(true);
            }
        });
        this.filmeLaden.addAdListener(new MSListenerFilmeLaden(){

            @Override
            public void progress(MSListenerFilmeLadenEvent event) {
                if (event.max == 0) {
                    PanelSenderSearch.this.jProgressBar1.setIndeterminate(true);
                    PanelSenderSearch.this.jProgressBar1.setMaximum(0);
                    PanelSenderSearch.this.jProgressBar1.setMinimum(0);
                    PanelSenderSearch.this.jProgressBar1.setValue(0);
                    PanelSenderSearch.this.jProgressBar1.setStringPainted(false);
                } else {
                    PanelSenderSearch.this.jProgressBar1.setIndeterminate(false);
                    PanelSenderSearch.this.jProgressBar1.setMaximum(event.max);
                    PanelSenderSearch.this.jProgressBar1.setMinimum(0);
                    PanelSenderSearch.this.jProgressBar1.setValue(event.progress);
                    PanelSenderSearch.this.jProgressBar1.setStringPainted(true);
                }
                PanelSenderSearch.this.jLabelProgress.setText(PanelSenderSearch.textLaenge(80, event.text, true, false));
                PanelSenderSearch.this.jLabelAnzahl.setText(event.count + "");
            }

            @Override
            public void fertig(MSListenerFilmeLadenEvent event) {
                PanelSenderSearch.this.jProgressBar1.setIndeterminate(false);
                PanelSenderSearch.this.jProgressBar1.setMaximum(0);
                PanelSenderSearch.this.jProgressBar1.setMinimum(0);
                PanelSenderSearch.this.jProgressBar1.setValue(0);
                PanelSenderSearch.this.jProgressBar1.setStringPainted(false);
                PanelSenderSearch.this.jLabelProgress.setText("");
                MSearchGui.jLabelAnzahl.setText(MSearchGui.listeFilme.size() + "");
                for (JButton button : PanelSenderSearch.this.buttonSender) {
                    button.setEnabled(true);
                }
            }
        });
    }

    private void addSender() {
        this.panelSender.removeAll();
        this.panelSender.setLayout(new GridLayout(0, 5));
        int nr = 0;
        for (String sender : this.senderArray) {
            JButton btn = this.buttonSender[nr];
            btn.setText(sender);
            this.panelSender.add(btn);
            ++nr;
        }
        this.panelSender.repaint();
    }

    private static String textLaenge(int max, String text, boolean mitte, boolean addVorne) {
        if (text.length() > max) {
            text = mitte ? text.substring(0, 25) + " .... " + text.substring(text.length() - (max - 31)) : text.substring(0, max - 1);
        }
        while (text.length() < max) {
            if (addVorne) {
                text = " " + text;
                continue;
            }
            text = text + " ";
        }
        return text;
    }

    private void initComponents() {
        this.panelSender = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabelProgress = new JLabel();
        this.jButtonStop = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabelAnzahl = new JLabel();
        this.panelSender.setBorder(BorderFactory.createTitledBorder("Sender"));
        GroupLayout panelSenderLayout = new GroupLayout(this.panelSender);
        this.panelSender.setLayout(panelSenderLayout);
        panelSenderLayout.setHorizontalGroup(panelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 152, Short.MAX_VALUE));
        panelSenderLayout.setVerticalGroup(panelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 72, Short.MAX_VALUE));
        this.jLabelProgress.setText("Fortschritt!");
        this.jButtonStop.setText("Stop");
        this.jButtonStop.setToolTipText("Abbrechen");
        this.jLabel1.setText("Anzahl Filme (Suchen):");
        this.jLabelAnzahl.setText("-1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelProgress, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jProgressBar1, -1, 507, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStop)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelSender, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelAnzahl))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelSender, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 262, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar1, -2, 31, -2).addComponent(this.jButtonStop)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelProgress).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabelAnzahl)).addContainerGap()));
        layout.linkSize(1, this.jButtonStop, this.jProgressBar1);
    }

    private class BeobSenderLaden
    implements ActionListener {
        private final String sender;

        public BeobSenderLaden(String ssender) {
            this.sender = ssender;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanelSenderSearch.this.jLabelProgress.setText("");
            PanelSenderSearch.this.jLabelAnzahl.setText("");
            for (JButton aButtonSender : PanelSenderSearch.this.buttonSender) {
                aButtonSender.setEnabled(false);
            }
            PanelSenderSearch.this.filmeLaden.updateSender(new String[]{this.sender});
        }
    }
}

