/*
 * Decompiled with CFR 0.152.
 */
package msearch.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import msearch.tool.MSConfig;
import msearch.tool.MSFunktionen;
import org.apache.commons.lang3.StringUtils;

public class MSLog {
    private static final String FEHLER = "Fehler(MSearch): ";
    private static final LinkedList<Error> fehlerListe = new LinkedList();
    private static boolean progress = false;
    private static final Date startZeit = new Date(System.currentTimeMillis());
    private static File logFile = null;
    private static final ArrayList<String> logList = new ArrayList();

    public static synchronized void setLogfile(String logFileString) {
        logFile = new File(logFileString);
        File dir = new File(logFile.getParent());
        if (!dir.exists() && !dir.mkdirs()) {
            logFile = null;
            MSLog.fehlerMeldung(632012165, "Kann den Pfad nicht anlegen: " + dir.toString());
        }
    }

    public static synchronized void versionsMeldungen() {
        String[] java;
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung(".___  ___.  _______  _______   __       ___   .___________. __    __   _______  __  ___");
        MSLog.systemMeldung("|   \\/   | |   ____||       \\ |  |     /   \\  |           ||  |  |  | |   ____||  |/  /");
        MSLog.systemMeldung("|  \\  /  | |  |__   |  .--.  ||  |    /  ^  \\ `---|  |----`|  |__|  | |  |__   |  '  /");
        MSLog.systemMeldung("|  |\\/|  | |   __|  |  |  |  ||  |   /  /_\\  \\    |  |     |   __   | |   __|  |    <");
        MSLog.systemMeldung("|  |  |  | |  |____ |  '--'  ||  |  /  _____  \\   |  |     |  |  |  | |  |____ |  .  \\");
        MSLog.systemMeldung("|__|  |__| |_______||_______/ |__| /__/     \\__\\  |__|     |__|  |__| |_______||__|\\__\\");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("##################################################################################");
        MSLog.systemMeldung("##################################################################################");
        MSLog.systemMeldung("Programmstart: " + sdf.format(startZeit));
        MSLog.systemMeldung("##################################################################################");
        MSLog.systemMeldung("##################################################################################");
        long totalMem = Runtime.getRuntime().totalMemory();
        MSLog.systemMeldung("totalMemory: " + totalMem / 1000000L + " MB");
        long maxMem = Runtime.getRuntime().maxMemory();
        MSLog.systemMeldung("maxMemory: " + maxMem / 1000000L + " MB");
        long freeMem = Runtime.getRuntime().freeMemory();
        MSLog.systemMeldung("freeMemory: " + freeMem / 1000000L + " MB");
        MSLog.systemMeldung("##################################################################################");
        MSLog.systemMeldung("MSearch" + MSFunktionen.getProgVersionString());
        MSLog.systemMeldung("Compiled: " + MSFunktionen.getCompileDate());
        MSLog.systemMeldung("##################################################################################");
        MSLog.systemMeldung("Java");
        for (String ja : java = MSFunktionen.getJavaVersion()) {
            MSLog.systemMeldung(ja);
        }
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
    }

    public static synchronized void startMeldungen() {
        startZeit.setTime(System.currentTimeMillis());
        MSLog.versionsMeldungen();
        MSLog.systemMeldung("##################################################################################");
        MSLog.systemMeldung("Programmpfad: " + MSFunktionen.getPathJar());
        MSLog.systemMeldung("Filmliste: " + MSConfig.getPathFilmlist_json_akt(true));
        MSLog.systemMeldung("Useragent: " + MSConfig.getUserAgent());
        MSLog.systemMeldung("##################################################################################");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        if (MSConfig.loadLongMax()) {
            MSLog.systemMeldung("Laden:  alles");
        } else {
            MSLog.systemMeldung("Laden:  nur update");
        }
        if (MSConfig.updateFilmliste) {
            MSLog.systemMeldung("Filmliste:  nur updaten");
        } else {
            MSLog.systemMeldung("Filmliste:  neu erstellen");
        }
        MSLog.systemMeldung("ImportURL 1:  " + MSConfig.importUrl_1__anhaengen);
        MSLog.systemMeldung("ImportURL 2:  " + MSConfig.importUrl_2__anhaengen);
        MSLog.systemMeldung("ImportOLD:  " + MSConfig.importOld);
        if (MSConfig.nurSenderLaden != null) {
            MSLog.systemMeldung("Nur Sender laden:  " + StringUtils.join((Object[])MSConfig.nurSenderLaden, ','));
        }
        MSLog.systemMeldung("##################################################################################");
    }

    public static synchronized void endeMeldung() {
        int minuten;
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        ArrayList<String> ret = MSLog.fehlerMeldungen();
        for (String s : ret) {
            MSLog.systemMeldung(s);
        }
        Date stopZeit = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        try {
            minuten = Math.round((stopZeit.getTime() - startZeit.getTime()) / 60000L);
        }
        catch (Exception ex) {
            minuten = -1;
        }
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("##################################################################################");
        MSLog.systemMeldung("   --> Beginn: " + sdf.format(startZeit));
        MSLog.systemMeldung("   --> Fertig: " + sdf.format(stopZeit));
        MSLog.systemMeldung("   --> Dauer[Min]: " + (minuten == 0 ? "<1" : Integer.valueOf(minuten)));
        MSLog.systemMeldung("##################################################################################");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("   und Tschuess");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("");
        MSLog.systemMeldung("##################################################################################");
    }

    public static synchronized ArrayList<String> fehlerMeldungen() {
        int max = 0;
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("");
        retList.add("##################################################################################");
        if (fehlerListe.size() == 0) {
            retList.add(" Keine Fehler :)");
        } else {
            for (Error e : fehlerListe) {
                if (e.cl.length() <= max) continue;
                max = e.cl.length();
            }
            ++max;
            for (Error e : fehlerListe) {
                while (e.cl.length() < max) {
                    e.cl = e.cl + " ";
                }
            }
            for (int i = 1; i < fehlerListe.size(); ++i) {
                int i_2;
                int i_1;
                for (int k = i; k > 0 && (i_1 = MSLog.fehlerListe.get((int)(k - 1)).nr) < (i_2 = MSLog.fehlerListe.get((int)k).nr); --k) {
                    fehlerListe.add(k - 1, fehlerListe.remove(k));
                }
            }
            for (Error e : fehlerListe) {
                String strEx = e.ex ? "Ex! " : "    ";
                retList.add(strEx + e.cl + " Fehlernummer: " + e.nr + " Anzahl: " + e.count);
            }
        }
        retList.add("##################################################################################");
        return retList;
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, Exception ex) {
        MSLog.fehlermeldung_(fehlerNummer, ex, new String[0]);
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, Exception ex, String text) {
        MSLog.fehlermeldung_(fehlerNummer, ex, new String[]{text});
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, Exception ex, String[] text) {
        MSLog.fehlermeldung_(fehlerNummer, ex, text);
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, String text) {
        MSLog.fehlermeldung_(fehlerNummer, null, new String[]{text});
    }

    public static synchronized void fehlerMeldung(int fehlerNummer, String[] text) {
        MSLog.fehlermeldung_(fehlerNummer, null, text);
    }

    public static synchronized void systemMeldung(String[] text) {
        MSLog.systemmeldung_(text);
    }

    public static synchronized void systemMeldung(String text) {
        MSLog.systemmeldung_(new String[]{text});
    }

    public static synchronized void progress(String texte) {
        progress = true;
        if (!texte.isEmpty()) {
            System.out.print(texte + "\r");
        }
    }

    private static void resetProgress() {
        if (progress) {
            System.out.print("                                                                                                             \r");
            progress = false;
        }
    }

    private static void addFehlerNummer(int nr, String classs, boolean exception) {
        for (Error e : fehlerListe) {
            if (e.nr != nr) continue;
            ++e.count;
            return;
        }
        fehlerListe.add(new Error(nr, classs, exception));
    }

    private static void fehlermeldung_(int fehlerNummer, Exception ex, String[] texte) {
        String kl;
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[2];
        String klasse = methodCaller.getClassName() + "." + methodCaller.getMethodName();
        try {
            kl = klasse;
            while (kl.contains(".") && !Character.isUpperCase(kl.charAt(0))) {
                kl = kl.substring(kl.indexOf(".") + 1);
            }
        }
        catch (Exception ignored) {
            kl = klasse;
        }
        MSLog.addFehlerNummer(fehlerNummer, kl, ex != null);
        if (ex != null || MSConfig.debug) {
            MSLog.resetProgress();
            String x = ex != null ? "!" : "=";
            String z = "*";
            logList.add(x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x + x);
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                if (ex != null) {
                    ex.printStackTrace(pw);
                }
                pw.flush();
                sw.flush();
                logList.add(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            logList.add(z + " Fehlernr: " + fehlerNummer);
            if (ex != null) {
                logList.add(z + " Exception: " + ex.getMessage());
            }
            logList.add(z + " " + FEHLER + kl);
            for (String aTexte : texte) {
                logList.add(z + "           " + aTexte);
            }
            logList.add("");
            MSLog.printLog();
        }
    }

    private static void systemmeldung_(String[] texte) {
        MSLog.resetProgress();
        String z = ". ";
        if (texte.length <= 1) {
            logList.add(".  " + texte[0]);
        } else {
            String zeile = "---------------------------------------";
            logList.add(". " + zeile);
            for (String aTexte : texte) {
                String txt = "| " + aTexte;
                logList.add(". " + txt);
            }
            logList.add(". " + zeile);
        }
        MSLog.printLog();
    }

    private static void printLog() {
        for (String s : logList) {
            System.out.println(s);
        }
        if (logFile != null) {
            try {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(logFile, true), "UTF-8");
                for (String s : logList) {
                    out.write(s);
                    out.write("\n");
                }
                out.close();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
        logList.clear();
    }

    private static class Error {
        String cl = "";
        int nr = 0;
        int count = 0;
        boolean ex = false;

        public Error(int nr, String cl, boolean ex) {
            this.nr = nr;
            this.cl = cl;
            this.ex = ex;
            this.count = 1;
        }
    }
}

