/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.TristateButtonModel;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import sun.swing.plaf.synth.SynthIcon;

public class TristateCheckBoxIcon
implements Icon,
SynthConstants {
    private UIDefaults.LazyValue _originalIcon;
    private static Map<String, Boolean> _synthIconMap;

    public TristateCheckBoxIcon(UIDefaults.LazyValue originalIcon) {
        this._originalIcon = originalIcon;
    }

    protected boolean isSynthIconClassName(String name) {
        return name != null && name.contains("sun.swing.plaf.synth.SynthIcon");
    }

    private boolean isSynthIcon(Icon icon) {
        if (_synthIconMap == null) {
            _synthIconMap = new HashMap<String, Boolean>();
        }
        ArrayList<String> classNamesToPut = new ArrayList<String>();
        boolean isSynthIcon = false;
        for (Class<?> aClass = icon.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            String name = aClass.getCanonicalName();
            if (name == null) continue;
            Boolean value = _synthIconMap.get(name);
            if (value != null) {
                return value;
            }
            classNamesToPut.add(name);
            if (!this.isSynthIconClassName(name)) continue;
            isSynthIcon = true;
            break;
        }
        for (String name : classNamesToPut) {
            _synthIconMap.put(name, isSynthIcon);
        }
        return isSynthIcon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        if (this.isSynthIcon(icon)) {
            int state = this.getComponentState((JComponent)c);
            if (c instanceof TristateCheckBox && ((TristateCheckBox)c).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c).getModel()).isMixed()) {
                state &= 0xFFFFFDFF;
            }
            SynthContext context = new SynthContext((JComponent)c, Region.CHECK_BOX, SynthLookAndFeel.getStyle((JComponent)c, Region.CHECK_BOX), state);
            int w = ((SynthIcon)icon).getIconWidth(context);
            int h = ((SynthIcon)icon).getIconHeight(context);
            ((SynthIcon)icon).paintIcon(context, g, x, y, w, h);
        } else {
            if (c instanceof TristateCheckBox && ((TristateCheckBox)c).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c).getModel()).isMixed()) {
                ((TristateButtonModel)((TristateCheckBox)c).getModel()).internalSetSelected(false);
            }
            icon.paintIcon(c, g, x, y);
            if (c instanceof TristateCheckBox && ((TristateCheckBox)c).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c).getModel()).isMixed()) {
                ((TristateButtonModel)((TristateCheckBox)c).getModel()).internalSetSelected(true);
            }
        }
        g.setColor(UIManager.getColor("CheckBox.foreground"));
        if (c instanceof TristateCheckBox && ((TristateCheckBox)c).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c).getModel()).isMixed()) {
            this.drawSquare(c, g, x, y);
        }
    }

    private int getComponentState(JComponent c) {
        AbstractButton button;
        ButtonModel model;
        int state = 1;
        if (!c.isEnabled()) {
            state = 8;
        }
        if ((model = (button = (AbstractButton)c).getModel()).isPressed()) {
            state = model.isArmed() ? 4 : 2;
        }
        if (model.isRollover()) {
            state |= 2;
        }
        if (model.isSelected()) {
            state |= 0x200;
        }
        if (c.isFocusOwner() && button.isFocusPainted()) {
            state |= 0x100;
        }
        if (c instanceof JButton && ((JButton)c).isDefaultButton()) {
            state |= 0x400;
        }
        return state;
    }

    @Override
    public int getIconWidth() {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        return icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        return icon.getIconHeight();
    }

    protected void drawSquare(Component c, Graphics g, int x, int y) {
        int w = Math.min(this.getIconWidth(), this.getIconHeight());
        int h = Math.min(this.getIconWidth(), this.getIconHeight());
        int xMargin = w / 3;
        int yMargin = h / 3;
        g.fillRect(x + xMargin, y + yMargin, w - xMargin * 2, h - yMargin * 2);
    }
}

