/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;

public class ShareProvider {
    private static final String URL_INPUT_TOKEN = "[L]";
    private static final String TITLE_INPUT_TOKEN = "[T]";
    private final String fId;
    private final String fPluginId;
    private final int fIndex;
    private final String fName;
    private final String fIconPath;
    private final String fUrl;
    private final int fMaxTitleLength;
    private boolean fEnabled;

    public ShareProvider(String id, String pluginId, int index, String name, String iconPath, String url, String maxTitleLength, boolean enabled) {
        this.fId = id;
        this.fPluginId = pluginId;
        this.fIndex = index;
        this.fName = name;
        this.fIconPath = iconPath;
        this.fUrl = url;
        this.fEnabled = enabled;
        this.fMaxTitleLength = maxTitleLength != null ? Integer.parseInt(maxTitleLength) : Integer.MAX_VALUE;
    }

    public String getId() {
        return this.fId;
    }

    public String getPluginId() {
        return this.fPluginId;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public String getName() {
        return this.fName;
    }

    public String getIconPath() {
        return this.fIconPath;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public String toShareUrl(INews news) {
        String link = CoreUtils.getLink((INews)news);
        String title = CoreUtils.getHeadline((INews)news, (boolean)true);
        return this.toShareUrl(link, title);
    }

    public String toShareUrl(IBookMark mark) {
        String link = URIUtils.toHTTP((String)mark.getFeedLinkReference().getLinkAsText());
        String title = mark.getName();
        return this.toShareUrl(link, title);
    }

    public String toShareUrl(String link, String title) {
        if (!StringUtils.isSet((String)link)) {
            link = "";
        }
        if (!StringUtils.isSet((String)title)) {
            title = "";
        }
        if (title.length() > this.fMaxTitleLength) {
            title = StringUtils.smartTrim((String)title, (int)this.fMaxTitleLength);
        }
        link = URIUtils.urlEncode((String)link);
        title = URIUtils.urlEncode((String)title);
        String shareUrl = this.fUrl;
        int linkIndex = this.fUrl.indexOf(URL_INPUT_TOKEN);
        int titleIndex = this.fUrl.indexOf(TITLE_INPUT_TOKEN);
        if (linkIndex >= 0) {
            shareUrl = StringUtils.replaceAll((String)shareUrl, (String)URL_INPUT_TOKEN, (String)link);
        }
        if (titleIndex >= 0) {
            shareUrl = StringUtils.replaceAll((String)shareUrl, (String)TITLE_INPUT_TOKEN, (String)title);
        }
        return shareUrl;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShareProvider other = (ShareProvider)obj;
        return !(this.fId == null ? other.fId != null : !this.fId.equals(other.fId));
    }
}

