/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.WebsiteListDialog;
import org.rssowl.ui.internal.dialogs.preferences.Messages;
import org.rssowl.ui.internal.util.CBrowser;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.util.LayoutUtils;

public class BrowserPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.rssowl.ui.BrowserPreferencesPage";
    private IPreferenceScope fGlobalScope;
    private Text fCustomBrowserInput;
    private Button fUseCustomExternalBrowser;
    private Button fUseDefaultExternalBrowser;
    private Button fUseInternalBrowser;
    private Button fCustomBrowserSearchButton;
    private Button fReOpenBrowserTabs;
    private Button fOpenLinksInNewTab;
    private Button fLoadBrowserTabInBackground;
    private Button fAlwaysReuseBrowser;
    private Button fEnablePopupBlockerCheck;
    private Button fDisableJavaScriptCheck;
    private Button fDisableJavaScriptExceptionsButton;
    private IPreferenceScope fEclipseScope;
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());

    public BrowserPreferencePage() {
        this.fGlobalScope = Owl.getPreferenceService().getGlobalScope();
        this.fEclipseScope = Owl.getPreferenceService().getEclipseScope();
        this.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/browser.gif"));
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateApplyEnablement(false);
    }

    public void dispose() {
        super.dispose();
        this.fResources.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite container = this.createComposite(parent);
        this.createBrowserOptions(container);
        this.applyDialogFont(container);
        return container;
    }

    private void createBrowserOptions(Composite container) {
        Composite browserGroup = new Composite(container, 0);
        browserGroup.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        browserGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label = new Label(browserGroup, 0);
        label.setText(Messages.BrowserPreferencePage_BROWSER_SELECTION);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Composite group = new Composite(browserGroup, 0);
        group.setLayout((Layout)LayoutUtils.createGridLayout(2, 7, 3));
        ((GridLayout)group.getLayout()).marginBottom = 5;
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fUseInternalBrowser = new Button(group, 16);
        this.fUseInternalBrowser.setText(Messages.BrowserPreferencePage_USE_EMBEDDED_BROWSER);
        this.fUseInternalBrowser.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fUseInternalBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserPreferencePage.this.updateEnablement();
            }
        });
        this.fUseDefaultExternalBrowser = new Button(group, 16);
        String name = this.getDefaultBrowserName();
        if (StringUtils.isSet((String)name)) {
            this.fUseDefaultExternalBrowser.setText(NLS.bind((String)Messages.BrowserPreferencePage_USE_STANDARD_BROWSER_N, (Object)name));
        } else {
            this.fUseDefaultExternalBrowser.setText(Messages.BrowserPreferencePage_USE_STANDARD_BROWSER);
        }
        this.fUseDefaultExternalBrowser.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fUseDefaultExternalBrowser.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.USE_DEFAULT_EXTERNAL_BROWSER));
        this.fUseCustomExternalBrowser = new Button(group, 16);
        this.fUseCustomExternalBrowser.setText(Messages.BrowserPreferencePage_USE_EXTERNAL_BROWSER);
        this.fUseCustomExternalBrowser.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fUseCustomExternalBrowser.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.USE_CUSTOM_EXTERNAL_BROWSER));
        this.fUseCustomExternalBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserPreferencePage.this.fCustomBrowserInput.setEnabled(BrowserPreferencePage.this.fUseCustomExternalBrowser.getSelection());
                BrowserPreferencePage.this.fCustomBrowserSearchButton.setEnabled(BrowserPreferencePage.this.fUseCustomExternalBrowser.getSelection());
            }
        });
        this.fUseInternalBrowser.setSelection(!this.fUseDefaultExternalBrowser.getSelection() && !this.fUseCustomExternalBrowser.getSelection());
        this.fCustomBrowserInput = new Text(group, 2048);
        OwlUI.makeAccessible((Control)this.fCustomBrowserInput, (Control)this.fUseCustomExternalBrowser);
        this.fCustomBrowserInput.setEnabled(this.fUseCustomExternalBrowser.getSelection());
        this.fCustomBrowserInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ControlDecoration controlDeco = new ControlDecoration((Control)this.fCustomBrowserInput, 16512);
        controlDeco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        controlDeco.setDescriptionText(Messages.BrowserPreferencePage_BROWSER_PARAMETER_SUPPORT);
        controlDeco.setShowOnlyOnFocus(true);
        String customBrowserValue = this.fGlobalScope.getString(DefaultPreferences.CUSTOM_BROWSER_PATH);
        if (customBrowserValue != null) {
            this.fCustomBrowserInput.setText(customBrowserValue);
        }
        this.fCustomBrowserSearchButton = new Button(group, 8);
        this.fCustomBrowserSearchButton.setText(Messages.BrowserPreferencePage_BROWSE);
        Dialog.applyDialogFont((Control)this.fCustomBrowserSearchButton);
        this.setButtonLayoutData(this.fCustomBrowserSearchButton);
        this.fCustomBrowserSearchButton.setEnabled(this.fUseCustomExternalBrowser.getSelection());
        this.fCustomBrowserSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(BrowserPreferencePage.this.getShell(), 4096);
                dialog.setFileName(BrowserPreferencePage.this.fCustomBrowserInput.getText());
                String path = dialog.open();
                if (path != null) {
                    BrowserPreferencePage.this.fCustomBrowserInput.setText(path);
                }
            }
        });
        label = new Label(browserGroup, 0);
        label.setText(Messages.BrowserPreferencePage_TABBED_BROWSING);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        group = new Composite(browserGroup, 0);
        group.setLayout((Layout)LayoutUtils.createGridLayout(1, 7, 3));
        ((GridLayout)group.getLayout()).marginBottom = 5;
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fOpenLinksInNewTab = new Button(group, 32);
        this.fOpenLinksInNewTab.setText(Messages.BrowserPreferencePage_OPEN_LINKS_IN_TABS);
        this.fOpenLinksInNewTab.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fOpenLinksInNewTab.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.OPEN_LINKS_IN_NEW_TAB));
        this.fReOpenBrowserTabs = new Button(group, 32);
        this.fReOpenBrowserTabs.setText(Messages.BrowserPreferencePage_REOPEN_WEBSITE);
        this.fReOpenBrowserTabs.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fReOpenBrowserTabs.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.REOPEN_BROWSER_TABS));
        this.fLoadBrowserTabInBackground = new Button(group, 32);
        this.fLoadBrowserTabInBackground.setText(Messages.BrowserPreferencePage_OPEN_IN_BACKGROUND);
        this.fLoadBrowserTabInBackground.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fLoadBrowserTabInBackground.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.OPEN_BROWSER_IN_BACKGROUND));
        this.fAlwaysReuseBrowser = new Button(group, 32);
        this.fAlwaysReuseBrowser.setText(Messages.BrowserPreferencePage_OPEN_IN_SAME_TAB);
        this.fAlwaysReuseBrowser.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fAlwaysReuseBrowser.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.ALWAYS_REUSE_BROWSER));
        if (!Application.IS_WINDOWS || !CBrowser.isMozillaRunningOnWindows()) {
            label = new Label(browserGroup, 0);
            label.setText(Messages.BrowserPreferencePage_CONTENT);
            label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            group = new Composite(browserGroup, 0);
            group.setLayout((Layout)LayoutUtils.createGridLayout(2, 7, 3));
            group.setLayoutData((Object)new GridData(4, 1, true, false));
            if (Application.IS_WINDOWS) {
                this.fEnablePopupBlockerCheck = new Button(group, 32);
                this.fEnablePopupBlockerCheck.setText(Messages.BrowserPreferencePage_BLOCK_POPUPS);
                this.fEnablePopupBlockerCheck.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
                this.fEnablePopupBlockerCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.ENABLE_IE_POPUP_BLOCKER));
            }
            Composite jsContainer = new Composite(group, 0);
            jsContainer.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
            jsContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
            this.fDisableJavaScriptCheck = new Button(jsContainer, 32);
            this.fDisableJavaScriptCheck.setText(Messages.BrowserPreferencePage_DISABLE_JS);
            this.fDisableJavaScriptCheck.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            this.fDisableJavaScriptCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.DISABLE_JAVASCRIPT));
            this.fDisableJavaScriptCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowserPreferencePage.this.fDisableJavaScriptExceptionsButton.setEnabled(BrowserPreferencePage.this.fDisableJavaScriptCheck.getSelection());
                }
            });
            this.fDisableJavaScriptExceptionsButton = new Button(jsContainer, 8);
            this.fDisableJavaScriptExceptionsButton.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
            this.fDisableJavaScriptExceptionsButton.setText(Messages.BrowserPreferencePage_EXCEPTIONS);
            Dialog.applyDialogFont((Control)this.fDisableJavaScriptExceptionsButton);
            this.setButtonLayoutData(this.fDisableJavaScriptExceptionsButton);
            this.fDisableJavaScriptExceptionsButton.setEnabled(this.fDisableJavaScriptCheck.getSelection());
            this.fDisableJavaScriptExceptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new WebsiteListDialog(BrowserPreferencePage.this.getShell()).open();
                }
            });
            if (Application.IS_WINDOWS) {
                Composite infoContainer = new Composite(group, 0);
                infoContainer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
                ((GridLayout)infoContainer.getLayout()).marginTop = 5;
                Label infoImg = new Label(infoContainer, 0);
                infoImg.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/info.gif"));
                infoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                Link infoText = new Link(infoContainer, 64);
                infoText.setText(Messages.BrowserPreferencePage_INTERNET_OPTIONS);
                infoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                infoText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Program.launch((String)"inetcpl.cpl");
                    }
                });
            }
        }
        this.updateEnablement();
        OwlUI.runOnSelection(new Runnable(){

            public void run() {
                BrowserPreferencePage.this.updateApplyEnablement(true);
            }
        }, new Control[]{browserGroup});
    }

    private String getDefaultBrowserName() {
        String name;
        Program program = Program.findProgram((String)"html");
        if (program != null && StringUtils.isSet((String)(name = program.getName()))) {
            if ((name = name.toLowerCase()).contains("firefox")) {
                return "Mozilla Firefox";
            }
            if (name.contains("mozilla")) {
                return "Mozilla";
            }
            if (name.contains("opera")) {
                return "Opera";
            }
            if (name.contains("safari")) {
                return "Safari";
            }
            if (name.contains("chrome")) {
                return "Google Chrome";
            }
            if (name.equals("html document") && Application.IS_WINDOWS) {
                return "Internet Explorer";
            }
            if (name.contains("internet explorer") && Application.IS_WINDOWS) {
                return "Internet Explorer";
            }
            if (name.contains("netscape")) {
                return "Netscape";
            }
            if (name.contains("konqueror")) {
                return "Konqueror";
            }
            if (name.contains("camino")) {
                return "Camino";
            }
        }
        return null;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        return composite;
    }

    public boolean performOk() {
        this.fGlobalScope.putBoolean(DefaultPreferences.OPEN_LINKS_IN_NEW_TAB, this.fOpenLinksInNewTab.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.REOPEN_BROWSER_TABS, this.fReOpenBrowserTabs.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.ALWAYS_REUSE_BROWSER, this.fAlwaysReuseBrowser.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.OPEN_BROWSER_IN_BACKGROUND, this.fLoadBrowserTabInBackground.getSelection());
        if (this.fDisableJavaScriptCheck != null) {
            this.fGlobalScope.putBoolean(DefaultPreferences.DISABLE_JAVASCRIPT, this.fDisableJavaScriptCheck.getSelection());
            this.fDisableJavaScriptExceptionsButton.setEnabled(this.fDisableJavaScriptCheck.getSelection());
        }
        if (this.fEnablePopupBlockerCheck != null) {
            this.fGlobalScope.putBoolean(DefaultPreferences.ENABLE_IE_POPUP_BLOCKER, this.fEnablePopupBlockerCheck.getSelection());
        }
        boolean wasUseDefaultExternalBrowser = this.fGlobalScope.getBoolean(DefaultPreferences.USE_DEFAULT_EXTERNAL_BROWSER);
        boolean wasUseCustomExternalBrowser = this.fGlobalScope.getBoolean(DefaultPreferences.USE_CUSTOM_EXTERNAL_BROWSER);
        boolean updateForEmbeddedBrowser = wasUseDefaultExternalBrowser != this.fUseDefaultExternalBrowser.getSelection() || wasUseCustomExternalBrowser != this.fUseCustomExternalBrowser.getSelection();
        this.fGlobalScope.putBoolean(DefaultPreferences.USE_DEFAULT_EXTERNAL_BROWSER, this.fUseDefaultExternalBrowser.getSelection());
        this.fGlobalScope.putBoolean(DefaultPreferences.USE_CUSTOM_EXTERNAL_BROWSER, this.fUseCustomExternalBrowser.getSelection());
        this.fGlobalScope.putString(DefaultPreferences.CUSTOM_BROWSER_PATH, this.fCustomBrowserInput.getText());
        if (updateForEmbeddedBrowser) {
            EditorUtils.updateToolbarVisibility();
        }
        return super.performOk();
    }

    protected void performApply() {
        super.performApply();
        this.updateApplyEnablement(false);
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        this.fOpenLinksInNewTab.setSelection(defaultScope.getBoolean(DefaultPreferences.OPEN_LINKS_IN_NEW_TAB));
        this.fReOpenBrowserTabs.setSelection(defaultScope.getBoolean(DefaultPreferences.REOPEN_BROWSER_TABS));
        this.fAlwaysReuseBrowser.setSelection(defaultScope.getBoolean(DefaultPreferences.ALWAYS_REUSE_BROWSER));
        this.fLoadBrowserTabInBackground.setSelection(defaultScope.getBoolean(DefaultPreferences.OPEN_BROWSER_IN_BACKGROUND));
        if (this.fDisableJavaScriptCheck != null) {
            this.fDisableJavaScriptCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.DISABLE_JAVASCRIPT));
            this.fDisableJavaScriptExceptionsButton.setEnabled(this.fDisableJavaScriptCheck.getSelection());
        }
        if (this.fEnablePopupBlockerCheck != null) {
            this.fEnablePopupBlockerCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.ENABLE_IE_POPUP_BLOCKER));
        }
        this.fUseDefaultExternalBrowser.setSelection(defaultScope.getBoolean(DefaultPreferences.USE_DEFAULT_EXTERNAL_BROWSER));
        this.fUseCustomExternalBrowser.setSelection(defaultScope.getBoolean(DefaultPreferences.USE_CUSTOM_EXTERNAL_BROWSER));
        this.fUseInternalBrowser.setSelection(!this.fUseDefaultExternalBrowser.getSelection() && !this.fUseDefaultExternalBrowser.getSelection());
        this.fCustomBrowserInput.setEnabled(this.fUseCustomExternalBrowser.getSelection());
        this.fCustomBrowserSearchButton.setEnabled(this.fUseCustomExternalBrowser.getSelection());
        this.updateEnablement();
        this.updateApplyEnablement(true);
    }

    private void updateApplyEnablement(boolean enable) {
        Button applyButton = this.getApplyButton();
        if (applyButton != null && !applyButton.isDisposed() && applyButton.isEnabled() != enable) {
            applyButton.setEnabled(enable);
        }
    }

    private void updateEnablement() {
        boolean autoCloseTab = this.fEclipseScope.getBoolean(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS);
        int autoCloseTabCount = this.fEclipseScope.getInteger(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS_THRESHOLD);
        boolean enable = this.fUseInternalBrowser.getSelection() && (!autoCloseTab || autoCloseTabCount > 1);
        this.fAlwaysReuseBrowser.setEnabled(enable);
        this.fLoadBrowserTabInBackground.setEnabled(enable);
        this.fReOpenBrowserTabs.setEnabled(enable);
        this.fOpenLinksInNewTab.setEnabled(enable);
    }

    public void applyData(Object data) {
        if (Boolean.TRUE.equals(data) && this.fDisableJavaScriptExceptionsButton != null && !this.fDisableJavaScriptExceptionsButton.isDisposed()) {
            this.fDisableJavaScriptExceptionsButton.setFocus();
        }
    }
}

