/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.properties;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.rssowl.core.internal.persist.NewsContainer;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.dialogs.properties.IEntityPropertyPage;
import org.rssowl.ui.dialogs.properties.IPropertyDialogSite;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.dialogs.properties.Messages;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.UIBackgroundJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformationPropertyPage
implements IEntityPropertyPage {
    private List<IEntity> fEntities;
    private final DateFormat fDateFormat = OwlUI.getShortDateFormat();
    private boolean fInfoComputed = false;
    private Composite fContainer;
    private Label fDescriptionLabel;
    private Link fHomepageLink;
    private IPropertyDialogSite fSite;

    @Override
    public void init(IPropertyDialogSite site, List<IEntity> entities) {
        Assert.isTrue((!entities.isEmpty() ? 1 : 0) != 0);
        this.fSite = site;
        this.fEntities = entities;
    }

    @Override
    public Control createContents(Composite parent) {
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10));
        IEntity entity = this.fEntities.get(0);
        if (entity instanceof INewsMark) {
            INewsMark newsmark = (INewsMark)this.fEntities.get(0);
            if (newsmark instanceof IBookMark) {
                this.fillBookMarkInfo((IBookMark)this.fEntities.get(0));
            }
            if (newsmark.getCreationDate() != null) {
                this.createLabel(this.fContainer, Messages.InformationPropertyPage_CREATED, true);
                this.createLabel(this.fContainer, this.fDateFormat.format(newsmark.getCreationDate()), false);
            }
            this.createLabel(this.fContainer, Messages.InformationPropertyPage_LAST_VISITED, true);
            if (newsmark.getLastVisitDate() != null) {
                this.createLabel(this.fContainer, this.fDateFormat.format(newsmark.getLastVisitDate()), false);
            } else {
                this.createLabel(this.fContainer, Messages.InformationPropertyPage_NEVER, false);
            }
        } else if (entity instanceof IFolder) {
            IFolder folder = (IFolder)this.fEntities.get(0);
            AtomicInteger folders = new AtomicInteger();
            AtomicInteger bookmarks = new AtomicInteger();
            AtomicInteger newsbins = new AtomicInteger();
            AtomicInteger searches = new AtomicInteger();
            this.countFolderChilds(folder, folders, bookmarks, newsbins, searches);
            this.createLabel(this.fContainer, Messages.InformationPropertyPage_FOLDERS, true);
            this.createLabel(this.fContainer, String.valueOf(folders.get()), false);
            this.createLabel(this.fContainer, Messages.InformationPropertyPage_BOOKMARKS, true);
            this.createLabel(this.fContainer, String.valueOf(bookmarks.get()), false);
            this.createLabel(this.fContainer, Messages.InformationPropertyPage_NEWSBINS, true);
            this.createLabel(this.fContainer, String.valueOf(newsbins.get()), false);
            this.createLabel(this.fContainer, Messages.InformationPropertyPage_SEARCHES, true);
            this.createLabel(this.fContainer, String.valueOf(searches.get()), false);
        }
        this.createLabel(this.fContainer, Messages.InformationPropertyPage_NEWS_COUNT, true);
        return this.fContainer;
    }

    private void countFolderChilds(IFolder folder, AtomicInteger folders, AtomicInteger bookmarks, AtomicInteger newsbins, AtomicInteger searches) {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof IFolder) {
                folders.incrementAndGet();
                this.countFolderChilds((IFolder)child, folders, bookmarks, newsbins, searches);
                continue;
            }
            if (child instanceof IBookMark) {
                bookmarks.incrementAndGet();
                continue;
            }
            if (child instanceof ISearchMark) {
                searches.incrementAndGet();
                continue;
            }
            if (!(child instanceof INewsBin)) continue;
            newsbins.incrementAndGet();
        }
    }

    private void fillBookMarkInfo(final IBookMark bm) {
        String message;
        boolean isSynchronized = SyncUtils.isSynchronized((IBookMark)bm);
        this.createLabel(this.fContainer, Messages.InformationPropertyPage_STATUS, true);
        message = bm.isErrorLoading() ? (!StringUtils.isSet((String)(message = (String)bm.getProperty("org.rssowl.ui.internal.LoadErrorKey"))) ? (isSynchronized ? Messages.InformationPropertyPage_LOAD_FAILED_UNKNOWN_SYNCED : Messages.InformationPropertyPage_LOAD_FAILED_UNKNOWN) : (isSynchronized ? NLS.bind((String)Messages.InformationPropertyPage_LOAD_FAILED_REASON_SYNCED, (Object)message) : NLS.bind((String)Messages.InformationPropertyPage_LOAD_FAILED_REASON, (Object)message))) : (bm.getMostRecentNewsDate() == null ? (isSynchronized ? Messages.InformationPropertyPage_NOT_SYNCED : Messages.InformationPropertyPage_NOT_LOADED) : (isSynchronized ? Messages.InformationPropertyPage_SYNCED_OK : Messages.InformationPropertyPage_LOADED_OK));
        Label msgLabel = new Label(this.fContainer, 64);
        msgLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        ((GridData)msgLabel.getLayoutData()).widthHint = 200;
        msgLabel.setText(message);
        if (bm.isErrorLoading()) {
            new Label(this.fContainer, 0);
            Link findOutMoreLink = new Link(this.fContainer, 0);
            findOutMoreLink.setLayoutData((Object)new GridData(1, 1, false, false));
            findOutMoreLink.setText(Messages.InformationPropertyPage_FIND_OUT_MORE);
            findOutMoreLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Object errorLink = bm.getProperty("org.rssowl.ui.internal.LoadErrorLinkKey");
                        URI uri = errorLink != null ? new URI(errorLink.toString()) : (SyncUtils.isSynchronized((IBookMark)bm) ? new URI("https://reader.google.com") : new URI("http://www.feedvalidator.org/check.cgi?url=" + URIUtils.urlEncode((String)URIUtils.toHTTP((String)bm.getFeedLinkReference().getLinkAsText()))));
                        OpenInBrowserAction action = new OpenInBrowserAction();
                        action.selectionChanged(null, (ISelection)new StructuredSelection((Object)uri));
                        action.run();
                    }
                    catch (URISyntaxException ex) {
                        Activator.safeLogError(ex.getMessage(), ex);
                    }
                }
            });
        }
        this.createLabel(this.fContainer, Messages.InformationPropertyPage_DESCRIPTION, true);
        this.fDescriptionLabel = new Label(this.fContainer, 64);
        this.fDescriptionLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        ((GridData)this.fDescriptionLabel.getLayoutData()).widthHint = 200;
        this.createLabel(this.fContainer, Messages.InformationPropertyPage_HOMEPAGE, true);
        this.fHomepageLink = new Link(this.fContainer, 0);
        this.fHomepageLink.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    @Override
    public ImageDescriptor getImage() {
        if (!this.fEntities.isEmpty() && this.fEntities.get(0) instanceof IBookMark && ((IBookMark)this.fEntities.get(0)).isErrorLoading()) {
            return OwlUI.getImageDescriptor("icons/ovr16/error.gif");
        }
        return null;
    }

    private void createLabel(Composite parent, String text, boolean bold) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        if (bold) {
            label.setFont(OwlUI.getBold("org.eclipse.jface.dialogfont"));
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean performOk(Set<IEntity> entitiesToSave) {
        return true;
    }

    @Override
    public void setFocus() {
        if (!this.fInfoComputed) {
            this.fInfoComputed = true;
            JobRunner.runUIUpdater(new UIBackgroundJob((Control)this.fContainer){
                private String description;
                private URI homepage;
                private int totalCount;
                private int newCount;
                private int unreadCount;
                private int updatedCount;

                protected void runInBackground(IProgressMonitor monitor) {
                    IEntity entity = (IEntity)InformationPropertyPage.this.fEntities.get(0);
                    if (entity instanceof IBookMark) {
                        IFeed feed = ((IBookMark)entity).getFeedLinkReference().resolve();
                        if (feed != null) {
                            this.description = StringUtils.stripTags((String)feed.getDescription(), (boolean)true);
                            this.homepage = feed.getHomepage();
                            List news = feed.getVisibleNews();
                            this.totalCount = news.size();
                            for (INews newsitem : news) {
                                switch (newsitem.getState()) {
                                    case NEW: {
                                        ++this.newCount;
                                        break;
                                    }
                                    case UNREAD: {
                                        ++this.unreadCount;
                                        break;
                                    }
                                    case UPDATED: {
                                        ++this.updatedCount;
                                    }
                                }
                            }
                        }
                    } else if (entity instanceof INewsMark) {
                        INewsMark newsmark = (INewsMark)entity;
                        this.totalCount = newsmark.getNewsCount(INews.State.getVisible());
                        this.newCount = newsmark.getNewsCount(EnumSet.of(INews.State.NEW));
                        this.unreadCount = newsmark.getNewsCount(EnumSet.of(INews.State.UNREAD));
                        this.updatedCount = newsmark.getNewsCount(EnumSet.of(INews.State.UPDATED));
                    } else if (entity instanceof IFolder) {
                        IFolder folder = (IFolder)entity;
                        FolderNewsMark resolver = new FolderNewsMark(folder);
                        NewsContainer newsContainer = resolver.resolveNewsContainer(monitor);
                        this.totalCount = newsContainer.getNewsCount(INews.State.getVisible());
                        this.newCount = newsContainer.getNewsCount(EnumSet.of(INews.State.NEW));
                        this.unreadCount = newsContainer.getNewsCount(EnumSet.of(INews.State.UNREAD));
                        this.updatedCount = newsContainer.getNewsCount(EnumSet.of(INews.State.UPDATED));
                    }
                }

                protected void runInUI(IProgressMonitor monitor) {
                    if (InformationPropertyPage.this.fEntities.get(0) instanceof IBookMark) {
                        InformationPropertyPage.this.fDescriptionLabel.setText(StringUtils.isSet((String)this.description) ? this.description : Messages.InformationPropertyPage_NONE);
                    }
                    if (InformationPropertyPage.this.fEntities.get(0) instanceof IBookMark) {
                        InformationPropertyPage.this.fHomepageLink.setText(this.homepage != null ? "<a>" + this.homepage.toString() + "</a>" : Messages.InformationPropertyPage_NONE);
                        if (this.homepage != null) {
                            InformationPropertyPage.this.fHomepageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    OpenInBrowserAction action = new OpenInBrowserAction();
                                    action.selectionChanged(null, (ISelection)new StructuredSelection((Object)homepage));
                                    action.run();
                                }
                            });
                        }
                    }
                    if (this.newCount != 0 && this.unreadCount != 0 && this.updatedCount != 0) {
                        InformationPropertyPage.this.createLabel(InformationPropertyPage.this.fContainer, NLS.bind((String)Messages.InformationPropertyPage_N_NEW_UNREAD_UPDATED, (Object[])new Object[]{this.totalCount, this.newCount, this.unreadCount, this.updatedCount}), false);
                    } else if (this.newCount != 0 && this.unreadCount != 0) {
                        InformationPropertyPage.this.createLabel(InformationPropertyPage.this.fContainer, NLS.bind((String)Messages.InformationPropertyPage_N_NEW_UNREAD, (Object[])new Object[]{this.totalCount, this.newCount, this.unreadCount}), false);
                    } else if (this.unreadCount != 0 && this.updatedCount != 0) {
                        InformationPropertyPage.this.createLabel(InformationPropertyPage.this.fContainer, NLS.bind((String)Messages.InformationPropertyPage_N_UNREAD_UPDATED, (Object[])new Object[]{this.totalCount, this.unreadCount, this.updatedCount}), false);
                    } else if (this.newCount != 0 && this.updatedCount != 0) {
                        InformationPropertyPage.this.createLabel(InformationPropertyPage.this.fContainer, NLS.bind((String)Messages.InformationPropertyPage_N_NEW_UPDATED, (Object[])new Object[]{this.totalCount, this.newCount, this.updatedCount}), false);
                    } else if (this.newCount != 0) {
                        InformationPropertyPage.this.createLabel(InformationPropertyPage.this.fContainer, NLS.bind((String)Messages.InformationPropertyPage_N_NEW, (Object[])new Object[]{this.totalCount, this.newCount}), false);
                    } else if (this.unreadCount != 0) {
                        InformationPropertyPage.this.createLabel(InformationPropertyPage.this.fContainer, NLS.bind((String)Messages.InformationPropertyPage_N_UNREAD, (Object[])new Object[]{this.totalCount, this.unreadCount}), false);
                    } else if (this.updatedCount != 0) {
                        InformationPropertyPage.this.createLabel(InformationPropertyPage.this.fContainer, NLS.bind((String)Messages.InformationPropertyPage_N_UPDATED, (Object[])new Object[]{this.totalCount, this.updatedCount}), false);
                    } else {
                        InformationPropertyPage.this.createLabel(InformationPropertyPage.this.fContainer, String.valueOf(this.totalCount), false);
                    }
                    InformationPropertyPage.this.fContainer.layout(true, true);
                    InformationPropertyPage.this.fSite.contentsChanged();
                }
            });
        }
    }
}

