/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.RetentionStrategy;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.ui.dialogs.properties.IEntityPropertyPage;
import org.rssowl.ui.dialogs.properties.IPropertyDialogSite;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.properties.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetentionPropertyPage
implements IEntityPropertyPage {
    private IPropertyDialogSite fSite;
    private List<IEntity> fEntities;
    private Spinner fMaxCountSpinner;
    private Spinner fMaxAgeSpinner;
    private Button fDeleteNewsByCountCheck;
    private Button fDeleteNewsByAgeCheck;
    private Button fDeleteReadNewsCheck;
    private Button fNeverDeleteUnreadNewsCheck;
    private Button fNeverDeleteLabeledNewsCheck;
    private boolean fSettingsChanged;
    private List<IPreferenceScope> fEntityPreferences;
    private boolean fPrefDeleteNewsByCountState;
    private int fPrefDeleteNewsByCountValue;
    private boolean fPrefDeleteNewsByAgeState;
    private int fPrefDeleteNewsByAgeValue;
    private boolean fPrefDeleteReadNews;
    private boolean fPrefNeverDeleteUnReadNews;
    private boolean fPrefNeverDeleteLabeledNews;

    @Override
    public void init(IPropertyDialogSite site, List<IEntity> entities) {
        Assert.isTrue((!entities.isEmpty() ? 1 : 0) != 0);
        this.fSite = site;
        this.fEntities = entities;
        this.fEntityPreferences = new ArrayList<IPreferenceScope>(this.fEntities.size());
        for (IEntity entity : entities) {
            this.fEntityPreferences.add(Owl.getPreferenceService().getEntityScope(entity));
        }
        this.loadInitialSettings();
    }

    private void loadInitialSettings() {
        IPreferenceScope firstScope = this.fEntityPreferences.get(0);
        this.fPrefDeleteNewsByCountState = firstScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE);
        this.fPrefDeleteNewsByCountValue = firstScope.getInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE);
        this.fPrefDeleteNewsByAgeState = firstScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE);
        this.fPrefDeleteNewsByAgeValue = firstScope.getInteger(DefaultPreferences.DEL_NEWS_BY_AGE_VALUE);
        this.fPrefDeleteReadNews = firstScope.getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE);
        this.fPrefNeverDeleteUnReadNews = firstScope.getBoolean(DefaultPreferences.NEVER_DEL_UNREAD_NEWS_STATE);
        this.fPrefNeverDeleteLabeledNews = firstScope.getBoolean(DefaultPreferences.NEVER_DEL_LABELED_NEWS_STATE);
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        int i = 1;
        while (i < this.fEntityPreferences.size()) {
            IPreferenceScope otherScope = this.fEntityPreferences.get(i);
            if (otherScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE) != this.fPrefDeleteNewsByCountState) {
                this.fPrefDeleteNewsByCountState = defaultScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE);
            }
            if (otherScope.getInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE) != this.fPrefDeleteNewsByCountValue) {
                this.fPrefDeleteNewsByCountValue = defaultScope.getInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE);
            }
            if (otherScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE) != this.fPrefDeleteNewsByAgeState) {
                this.fPrefDeleteNewsByAgeState = defaultScope.getBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE);
            }
            if (otherScope.getInteger(DefaultPreferences.DEL_NEWS_BY_AGE_VALUE) != this.fPrefDeleteNewsByAgeValue) {
                this.fPrefDeleteNewsByAgeValue = defaultScope.getInteger(DefaultPreferences.DEL_NEWS_BY_AGE_VALUE);
            }
            if (otherScope.getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE) != this.fPrefDeleteReadNews) {
                this.fPrefDeleteReadNews = defaultScope.getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE);
            }
            if (otherScope.getBoolean(DefaultPreferences.NEVER_DEL_UNREAD_NEWS_STATE) != this.fPrefNeverDeleteUnReadNews) {
                this.fPrefNeverDeleteUnReadNews = defaultScope.getBoolean(DefaultPreferences.NEVER_DEL_UNREAD_NEWS_STATE);
            }
            if (otherScope.getBoolean(DefaultPreferences.NEVER_DEL_LABELED_NEWS_STATE) != this.fPrefNeverDeleteLabeledNews) {
                this.fPrefNeverDeleteLabeledNews = defaultScope.getBoolean(DefaultPreferences.NEVER_DEL_LABELED_NEWS_STATE);
            }
            ++i;
        }
    }

    @Override
    public Control createContents(Composite parent) {
        boolean isSynchronized = this.isSynchronized(this.fEntities);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10, 5, 5, false));
        Label explanationLabel = new Label(container, 64);
        explanationLabel.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        explanationLabel.setText(Messages.RetentionPropertyPage_CLEANUP_INFO);
        this.fDeleteNewsByCountCheck = new Button(container, 32);
        this.fDeleteNewsByCountCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fDeleteNewsByCountCheck.setSelection(this.fPrefDeleteNewsByCountState);
        this.fDeleteNewsByCountCheck.setText(isSynchronized ? Messages.RetentionPropertyPage_MAX_NUMBER_SYNCHRONIZED : Messages.RetentionPropertyPage_MAX_NUMBER);
        this.fDeleteNewsByCountCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetentionPropertyPage.this.fMaxCountSpinner.setEnabled(RetentionPropertyPage.this.fDeleteNewsByCountCheck.getSelection());
            }
        });
        this.fMaxCountSpinner = new Spinner(container, 2048);
        this.fMaxCountSpinner.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fMaxCountSpinner.setEnabled(this.fDeleteNewsByCountCheck.getSelection());
        this.fMaxCountSpinner.setMinimum(0);
        this.fMaxCountSpinner.setMaximum(99999);
        this.fMaxCountSpinner.setSelection(this.fPrefDeleteNewsByCountValue);
        this.fDeleteNewsByAgeCheck = new Button(container, 32);
        this.fDeleteNewsByAgeCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fDeleteNewsByAgeCheck.setSelection(this.fPrefDeleteNewsByAgeState);
        this.fDeleteNewsByAgeCheck.setText(isSynchronized ? Messages.RetentionPropertyPage_MAX_AGE_SYNCHRONIZED : Messages.RetentionPropertyPage_MAX_AGE);
        this.fDeleteNewsByAgeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetentionPropertyPage.this.fMaxAgeSpinner.setEnabled(RetentionPropertyPage.this.fDeleteNewsByAgeCheck.getSelection());
            }
        });
        this.fMaxAgeSpinner = new Spinner(container, 2048);
        this.fMaxAgeSpinner.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fMaxAgeSpinner.setEnabled(this.fDeleteNewsByAgeCheck.getSelection());
        this.fMaxAgeSpinner.setMinimum(0);
        this.fMaxAgeSpinner.setMaximum(99999);
        this.fMaxAgeSpinner.setSelection(this.fPrefDeleteNewsByAgeValue);
        this.fDeleteReadNewsCheck = new Button(container, 32);
        this.fDeleteReadNewsCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fDeleteReadNewsCheck.setText(Messages.RetentionPropertyPage_DELETE_READ);
        this.fDeleteReadNewsCheck.setSelection(this.fPrefDeleteReadNews);
        this.fNeverDeleteUnreadNewsCheck = new Button(container, 32);
        this.fNeverDeleteUnreadNewsCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fNeverDeleteUnreadNewsCheck.setText(Messages.RetentionPropertyPage_DELETE_UNREAD);
        this.fNeverDeleteUnreadNewsCheck.setSelection(this.fPrefNeverDeleteUnReadNews);
        this.fNeverDeleteLabeledNewsCheck = new Button(container, 32);
        this.fNeverDeleteLabeledNewsCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.fNeverDeleteLabeledNewsCheck.setText(Messages.RetentionPropertyPage_NEVER_DELETE_LABELED);
        this.fNeverDeleteLabeledNewsCheck.setSelection(this.fPrefNeverDeleteLabeledNews);
        Composite infoContainer = new Composite(container, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        ((GridLayout)infoContainer.getLayout()).marginTop = 5;
        Label infoImg = new Label(infoContainer, 0);
        infoImg.setImage(OwlUI.getImage(this.fSite.getResourceManager(), "icons/obj16/info.gif"));
        infoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label infoText = new Label(infoContainer, 64);
        infoText.setText(Messages.RetentionPropertyPage_CLEANUP_NOTE);
        infoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return container;
    }

    private boolean isSynchronized(List<IEntity> entities) {
        for (IEntity entity : entities) {
            if (entity instanceof IFolder) {
                IFolder folder = (IFolder)entity;
                if (this.isSynchronized(folder)) continue;
                return false;
            }
            if (entity instanceof IBookMark) {
                IBookMark bm = (IBookMark)entity;
                if (SyncUtils.isSynchronized((IBookMark)bm)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isSynchronized(IFolder folder) {
        for (IFolderChild child : folder.getChildren()) {
            if (child instanceof IFolder) {
                IFolder childFolder = (IFolder)child;
                if (this.isSynchronized(childFolder)) continue;
                return false;
            }
            if (child instanceof IBookMark) {
                IBookMark bm = (IBookMark)child;
                if (SyncUtils.isSynchronized((IBookMark)bm)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public ImageDescriptor getImage() {
        return null;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public boolean performOk(Set<IEntity> entitiesToSave) {
        for (IPreferenceScope scope : this.fEntityPreferences) {
            if (!this.updatePreferences(scope)) continue;
            IEntity entityToSave = this.fEntities.get(this.fEntityPreferences.indexOf(scope));
            entitiesToSave.add(entityToSave);
            this.fSettingsChanged = true;
        }
        for (IEntity entity : this.fEntities) {
            if (!this.fSettingsChanged || !(entity instanceof IFolder)) continue;
            this.updateChildPreferences((IFolder)entity);
        }
        return true;
    }

    private void updateChildPreferences(IFolder folder) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (!(mark instanceof IBookMark)) continue;
            IPreferenceScope scope = Owl.getPreferenceService().getEntityScope((IEntity)mark);
            this.updatePreferences(scope);
        }
        List folders = folder.getFolders();
        for (IFolder childFolder : folders) {
            IPreferenceScope scope = Owl.getPreferenceService().getEntityScope((IEntity)childFolder);
            this.updatePreferences(scope);
            this.updateChildPreferences(childFolder);
        }
    }

    private boolean updatePreferences(IPreferenceScope scope) {
        int iVal;
        boolean changed = false;
        boolean bVal = this.fDeleteNewsByCountCheck.getSelection();
        if (this.fPrefDeleteNewsByCountState != bVal) {
            scope.putBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE, bVal);
            changed = true;
        }
        if (this.fPrefDeleteNewsByCountValue != (iVal = this.fMaxCountSpinner.getSelection())) {
            scope.putInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE, iVal);
            changed = true;
        }
        if (this.fPrefDeleteNewsByAgeState != (bVal = this.fDeleteNewsByAgeCheck.getSelection())) {
            scope.putBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE, bVal);
            changed = true;
        }
        if (this.fPrefDeleteNewsByAgeValue != (iVal = this.fMaxAgeSpinner.getSelection())) {
            scope.putInteger(DefaultPreferences.DEL_NEWS_BY_AGE_VALUE, iVal);
            changed = true;
        }
        if (this.fPrefDeleteReadNews != (bVal = this.fDeleteReadNewsCheck.getSelection())) {
            scope.putBoolean(DefaultPreferences.DEL_READ_NEWS_STATE, bVal);
            changed = true;
        }
        if (this.fPrefNeverDeleteUnReadNews != (bVal = this.fNeverDeleteUnreadNewsCheck.getSelection())) {
            scope.putBoolean(DefaultPreferences.NEVER_DEL_UNREAD_NEWS_STATE, bVal);
            changed = true;
        }
        if (this.fPrefNeverDeleteLabeledNews != (bVal = this.fNeverDeleteLabeledNewsCheck.getSelection())) {
            scope.putBoolean(DefaultPreferences.NEVER_DEL_LABELED_NEWS_STATE, bVal);
            changed = true;
        }
        return changed;
    }

    @Override
    public void finish() {
        if (this.fSettingsChanged) {
            final INewsMark activeFeedViewNewsMark = OwlUI.getActiveFeedViewNewsMark();
            Job retentionJob = new Job(Messages.RetentionPropertyPage_PERFORMING_CLEANUP){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        HashSet<IBookMark> bookmarks = new HashSet<IBookMark>();
                        for (IEntity entity : RetentionPropertyPage.this.fEntities) {
                            if (entity instanceof IBookMark) {
                                bookmarks.add((IBookMark)entity);
                                continue;
                            }
                            if (!(entity instanceof IFolder)) continue;
                            CoreUtils.fillBookMarks(bookmarks, Collections.singleton((IFolder)entity));
                        }
                        monitor.beginTask(Messages.RetentionPropertyPage_PERFORMING_CLEANUP, bookmarks.size());
                        for (IBookMark bookmark : bookmarks) {
                            if (Controller.getDefault().isShuttingDown()) break;
                            if (monitor.isCanceled()) {
                                break;
                            }
                            if (activeFeedViewNewsMark != null && (activeFeedViewNewsMark.equals(bookmark) || activeFeedViewNewsMark instanceof FolderNewsMark && ((FolderNewsMark)activeFeedViewNewsMark).contains((INewsMark)bookmark))) continue;
                            monitor.subTask(bookmark.getName());
                            RetentionStrategy.process((IBookMark)bookmark);
                            monitor.worked(1);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            retentionJob.schedule();
        }
    }
}

