/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.ReparentInfo;
import org.rssowl.ui.dialogs.properties.IEntityPropertyPage;
import org.rssowl.ui.dialogs.properties.IPropertyDialogSite;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.properties.Messages;
import org.rssowl.ui.internal.search.LocationControl;
import org.rssowl.ui.internal.search.SearchConditionList;
import org.rssowl.ui.internal.util.FolderChooser;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchMarkPropertyPage
implements IEntityPropertyPage {
    private IPropertyDialogSite fSite;
    private Text fNameInput;
    private Button fMatchAllRadio;
    private LocationControl fLocationControl;
    private SearchConditionList fSearchConditionList;
    private Button fMatchAnyRadio;
    private FolderChooser fFolderChooser;
    private boolean fSearchChanged;
    private List<IEntity> fEntities;

    @Override
    public void init(IPropertyDialogSite site, List<IEntity> entities) {
        this.fSite = site;
        this.fEntities = entities;
    }

    @Override
    public Control createContents(Composite parent) {
        if (this.fEntities.size() == 1) {
            return this.createContentsSingleSearch(parent);
        }
        return this.createContentsMultiSearch(parent);
    }

    @Override
    public ImageDescriptor getImage() {
        return null;
    }

    private Control createContentsSingleSearch(Composite parent) {
        ISearchMark mark = (ISearchMark)this.fEntities.get(0);
        Pair conditions = CoreUtils.splitScope((List)mark.getSearchConditions());
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10));
        Label nameLabel = new Label(container, 0);
        nameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        nameLabel.setText(Messages.SearchMarkPropertyPage_NAME);
        Composite nameContainer = new Composite(container, Application.IS_MAC ? 0 : 2048);
        nameContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        nameContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        if (!Application.IS_MAC) {
            nameContainer.setBackground(container.getDisplay().getSystemColor(25));
        }
        this.fNameInput = new Text(nameContainer, Application.IS_MAC ? 2048 : 0);
        OwlUI.makeAccessible((Control)this.fNameInput, (Control)nameLabel);
        this.fNameInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fNameInput.setText(mark.getName());
        ToolBar generateTitleBar = new ToolBar(nameContainer, 0x800000);
        OwlUI.makeAccessible((Control)generateTitleBar, Messages.SearchMarkPropertyPage_NAME_FROM_CONDITION);
        if (!Application.IS_MAC) {
            generateTitleBar.setBackground(container.getDisplay().getSystemColor(25));
        }
        ToolItem generateTitleItem = new ToolItem(generateTitleBar, 8);
        generateTitleItem.setImage(OwlUI.getImage(this.fSite.getResourceManager(), "icons/etool16/info.gif"));
        generateTitleItem.setToolTipText(Messages.SearchMarkPropertyPage_NAME_FROM_CONDITION);
        generateTitleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchMarkPropertyPage.this.onGenerateName();
            }
        });
        Label locationLabel = new Label(container, 0);
        locationLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        locationLabel.setText(Messages.SearchMarkPropertyPage_LOCATION);
        this.fFolderChooser = new FolderChooser(container, mark.getParent(), 2048, true);
        this.fFolderChooser.setLayoutData(new GridData(4, 1, true, false));
        this.fFolderChooser.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 5, false));
        this.fFolderChooser.setBackground(container.getDisplay().getSystemColor(25));
        Composite topControlsContainer = new Composite(container, 0);
        topControlsContainer.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        topControlsContainer.setLayout((Layout)LayoutUtils.createGridLayout(4, 5, 0));
        ((GridLayout)topControlsContainer.getLayout()).marginTop = 10;
        this.fMatchAllRadio = new Button(topControlsContainer, 16);
        this.fMatchAllRadio.setText(Messages.SearchMarkPropertyPage_MATCH_ALL);
        this.fMatchAllRadio.setSelection(mark.matchAllConditions());
        this.fMatchAnyRadio = new Button(topControlsContainer, 16);
        this.fMatchAnyRadio.setText(Messages.SearchMarkPropertyPage_MATCH_ANY);
        this.fMatchAnyRadio.setSelection(!mark.matchAllConditions());
        Label sep = new Label(topControlsContainer, 514);
        sep.setLayoutData((Object)new GridData(-1, 16));
        Composite scopeContainer = new Composite(topControlsContainer, 0);
        scopeContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        scopeContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 5, false));
        ((GridLayout)scopeContainer.getLayout()).marginLeft = 2;
        Label scopeLabel = new Label(scopeContainer, 0);
        scopeLabel.setText(Messages.SearchMarkPropertyPage_SEARCH_IN);
        this.fLocationControl = new LocationControl(scopeContainer, 64){

            protected String getDefaultLabel() {
                return Messages.SearchMarkPropertyPage_ALL_NEWS;
            }
        };
        this.fLocationControl.setLayoutData(new GridData(4, 0x1000000, true, true));
        ((GridData)this.fLocationControl.getLayoutData()).widthHint = 100;
        this.fLocationControl.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        if (conditions.getFirst() != null && ((ISearchCondition)conditions.getFirst()).getValue() instanceof Long[][]) {
            this.fLocationControl.select((Long[][])((ISearchCondition)conditions.getFirst()).getValue());
        }
        Composite conditionsContainer = new Composite(container, 2048);
        conditionsContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        conditionsContainer.setLayout((Layout)LayoutUtils.createGridLayout(1));
        conditionsContainer.setBackground(container.getDisplay().getSystemColor(25));
        conditionsContainer.setBackgroundMode(2);
        this.fSearchConditionList = new SearchConditionList(conditionsContainer, 0, (List)conditions.getSecond());
        this.fSearchConditionList.setLayoutData(new GridData(4, 4, true, true));
        if (((List)conditions.getSecond()).size() <= 3) {
            this.fSearchConditionList.setVisibleItemCount(3);
        } else {
            this.fSearchConditionList.setVisibleItemCount(Math.min(7, ((List)conditions.getSecond()).size()));
        }
        if (CoreUtils.isLocationConflict((List)mark.getSearchConditions())) {
            this.fSite.setMessage(Messages.SearchMarkPropertyPage_LOCATION_WARNING, IPropertyDialogSite.MessageType.WARNING);
        }
        return container;
    }

    private Control createContentsMultiSearch(Composite parent) {
        boolean separateFromTop = false;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10));
        IFolder sameParent = this.getSameParent(this.fEntities);
        if (sameParent != null) {
            separateFromTop = true;
            Label locationLabel = new Label(container, 0);
            locationLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            locationLabel.setText(Messages.SearchMarkPropertyPage_LOCATION);
            this.fFolderChooser = new FolderChooser(container, sameParent, null, 2048, true);
            this.fFolderChooser.setLayoutData(new GridData(4, 1, true, false));
            this.fFolderChooser.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 5, false));
            this.fFolderChooser.setBackground(container.getDisplay().getSystemColor(25));
        }
        Composite otherSettingsContainer = new Composite(container, 0);
        otherSettingsContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        otherSettingsContainer.setLayoutData((Object)new GridData(4, 1, true, true, 2, 1));
        if (separateFromTop) {
            ((GridLayout)otherSettingsContainer.getLayout()).marginTop = 15;
        }
        Label nameLabel = new Label(otherSettingsContainer, 0);
        nameLabel.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
        nameLabel.setText(NLS.bind((String)Messages.SearchMarkPropertyPage_ADD_TO_ALL, (Object)this.fEntities.size()));
        Composite conditionsContainer = new Composite(otherSettingsContainer, 2048);
        conditionsContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        conditionsContainer.setLayout((Layout)LayoutUtils.createGridLayout(1));
        conditionsContainer.setBackground(container.getDisplay().getSystemColor(25));
        conditionsContainer.setBackgroundMode(2);
        this.fSearchConditionList = new SearchConditionList(conditionsContainer, 0, this.getDefaultConditions());
        this.fSearchConditionList.setLayoutData(new GridData(4, 4, true, true));
        this.fSearchConditionList.setVisibleItemCount(3);
        return container;
    }

    private IFolder getSameParent(List<IEntity> entities) {
        IFolder parent = null;
        for (IEntity entity : entities) {
            if (!(entity instanceof IFolderChild)) {
                return null;
            }
            IFolderChild folderChild = (IFolderChild)entity;
            IFolder folder = folderChild.getParent();
            if (parent == null) {
                parent = folder;
                continue;
            }
            if (parent == folder) continue;
            return null;
        }
        return parent;
    }

    private List<ISearchCondition> getDefaultConditions() {
        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(1);
        IModelFactory factory = Owl.getModelFactory();
        ISearchField field = factory.createSearchField(-1, INews.class.getName());
        ISearchCondition condition = factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)"");
        conditions.add(condition);
        return conditions;
    }

    void onGenerateName() {
        String name;
        List<ISearchCondition> conditions = this.fSearchConditionList.createConditions();
        ISearchCondition locationCondition = this.fLocationControl.toScopeCondition();
        if (locationCondition != null) {
            conditions.add(locationCondition);
        }
        if ((name = CoreUtils.getName(conditions, (boolean)this.fMatchAllRadio.getSelection())).length() > 0) {
            this.fNameInput.setText(name);
            this.fNameInput.selectAll();
        }
    }

    @Override
    public void setFocus() {
        if (this.fNameInput != null) {
            this.fNameInput.setFocus();
            this.fNameInput.selectAll();
        }
    }

    @Override
    public boolean performOk(Set<IEntity> entitiesToSave) {
        if (this.fEntities.size() == 1) {
            return this.performOkSingleSearch(entitiesToSave);
        }
        return this.performOkMultiSearch(entitiesToSave);
    }

    private boolean performOkSingleSearch(Set<IEntity> entitiesToSave) {
        ISearchMark mark = (ISearchMark)this.fEntities.get(0);
        if (this.fNameInput.getText().length() == 0) {
            this.fSite.select(this);
            this.fNameInput.setFocus();
            this.fSite.setMessage(Messages.SearchMarkPropertyPage_SEARCH_NAME, IPropertyDialogSite.MessageType.ERROR);
            return false;
        }
        if (this.fSearchConditionList.isEmpty()) {
            this.fSite.select(this);
            this.fNameInput.setFocus();
            this.fSite.setMessage(Messages.SearchMarkPropertyPage_DEFINE_SEARCH, IPropertyDialogSite.MessageType.ERROR);
            return false;
        }
        if (!mark.getName().equals(this.fNameInput.getText())) {
            mark.setName(this.fNameInput.getText());
            entitiesToSave.add((IEntity)mark);
        }
        if (mark.matchAllConditions() != this.fMatchAllRadio.getSelection()) {
            mark.setMatchAllConditions(this.fMatchAllRadio.getSelection());
            entitiesToSave.add((IEntity)mark);
            this.fSearchChanged = true;
        }
        if (this.fSearchConditionList.isModified() || this.fLocationControl.isModified()) {
            entitiesToSave.add((IEntity)mark);
            this.fSearchChanged = true;
            List oldConditions = mark.getSearchConditions();
            for (ISearchCondition oldCondition : oldConditions) {
                mark.removeSearchCondition(oldCondition);
            }
            DynamicDAO.deleteAll((Collection)oldConditions);
            this.fSearchConditionList.createConditions(mark);
            ISearchCondition locationCondition = this.fLocationControl.toScopeCondition();
            if (locationCondition != null) {
                mark.addSearchCondition(locationCondition);
            }
        }
        if (this.fSearchChanged) {
            Controller.getDefault().getSavedSearchService().updateSavedSearches(Collections.singleton(mark), true);
        }
        return true;
    }

    private boolean performOkMultiSearch(Set<IEntity> entitiesToSave) {
        HashSet<ISearchMark> searchesToUpdate = new HashSet<ISearchMark>(this.fEntities.size());
        for (IEntity entity : this.fEntities) {
            ISearchMark mark = (ISearchMark)entity;
            List<ISearchCondition> conditions = this.fSearchConditionList.createConditions(mark);
            if (conditions.isEmpty()) continue;
            entitiesToSave.add(entity);
            searchesToUpdate.add(mark);
        }
        if (!searchesToUpdate.isEmpty()) {
            Controller.getDefault().getSavedSearchService().updateSavedSearches(searchesToUpdate, true);
        }
        return true;
    }

    @Override
    public void finish() {
        for (IEntity entity : this.fEntities) {
            ISearchMark mark = (ISearchMark)entity;
            if (mark.getParent() == this.fFolderChooser.getFolder()) continue;
            ReparentInfo reparent = new ReparentInfo((Object)mark, (Object)this.fFolderChooser.getFolder(), null, null);
            CoreUtils.reparentWithProperties(Collections.singletonList(reparent));
        }
    }
}

