/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.filter.INewsActionPresentation;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.LabelDialog;
import org.rssowl.ui.internal.filter.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelNewsActionPresentation
implements INewsActionPresentation {
    private Combo fLabelCombo;
    private ComboViewer fViewer;
    private Composite fContainer;
    private static final Object NEW_LABEL_MARKER = new Object();

    @Override
    public void create(Composite parent, Object data) {
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 0, false));
        ((GridLayout)this.fContainer.getLayout()).marginLeft = 5;
        this.fContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fLabelCombo = new Combo(this.fContainer, 2056);
        this.fLabelCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fLabelCombo.setVisibleItemCount(15);
        this.fViewer = new ComboViewer(this.fLabelCombo);
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == NEW_LABEL_MARKER) {
                    return Messages.LabelNewsActionPresentation_NEW_LABEL;
                }
                return ((ILabel)element).getName();
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (NEW_LABEL_MARKER == selection.getFirstElement()) {
                    LabelNewsActionPresentation.this.onCreateLabel();
                }
            }
        });
        Set labels = CoreUtils.loadSortedLabels();
        this.updateInput(labels);
        if (this.fLabelCombo.getItemCount() > 0) {
            if (data != null) {
                for (ILabel label : labels) {
                    if (!label.getId().equals(data)) continue;
                    this.fViewer.setSelection((ISelection)new StructuredSelection((Object)label));
                    break;
                }
            }
            if (this.fLabelCombo.getSelectionIndex() == -1) {
                this.fLabelCombo.select(0);
            }
        }
    }

    private void updateInput(Collection<ILabel> labels) {
        ArrayList<Object> input = new ArrayList<Object>();
        input.addAll(labels);
        input.add(NEW_LABEL_MARKER);
        this.fViewer.setInput(input);
    }

    private void onCreateLabel() {
        LabelDialog dialog = new LabelDialog(this.fContainer.getShell(), LabelDialog.DialogMode.ADD, null);
        if (dialog.open() == 0) {
            String name = dialog.getName();
            RGB color = dialog.getColor();
            ILabel newLabel = Owl.getModelFactory().createLabel(null, name);
            newLabel.setColor(OwlUI.toString(color));
            newLabel.setOrder(this.fViewer.getCombo().getItemCount() - 1);
            DynamicDAO.save((IPersistable)newLabel);
            this.updateInput(CoreUtils.loadSortedLabels());
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)newLabel));
        } else {
            this.fLabelCombo.select(0);
        }
    }

    @Override
    public void dispose() {
        this.fContainer.dispose();
    }

    @Override
    public Long getData() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        Object object = selection.getFirstElement();
        if (object instanceof ILabel) {
            return ((ILabel)selection.getFirstElement()).getId();
        }
        return null;
    }
}

