/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.filter;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.filter.INewsActionPresentation;
import org.rssowl.ui.internal.filter.NewsActionDescriptor;
import org.rssowl.ui.internal.filter.NewsActionPresentationManager;
import org.rssowl.ui.internal.util.LayoutUtils;

public class NewsActionItem
extends Composite {
    private final IFilterAction fInitialFilterAction;
    private final IModelFactory fFactory = Owl.getModelFactory();
    private final NewsActionPresentationManager fNewsActionPresentationManager = NewsActionPresentationManager.getInstance();
    private ComboViewer fViewer;
    private INewsActionPresentation fShowingPresentation;

    public NewsActionItem(Composite parent, int style, IFilterAction initialFilterAction) {
        super(parent, style);
        Assert.isNotNull((Object)initialFilterAction);
        this.fInitialFilterAction = initialFilterAction;
        this.initComponents();
    }

    IFilterAction createFilterAction(boolean ignoreEmpty) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        NewsActionDescriptor descriptor = (NewsActionDescriptor)selection.getFirstElement();
        IFilterAction filterAction = this.fFactory.createFilterAction(descriptor.getActionId());
        if (this.fShowingPresentation != null) {
            Object data = this.fShowingPresentation.getData();
            if (data != null) {
                filterAction.setData(data);
            } else if (ignoreEmpty) {
                return null;
            }
        }
        return filterAction;
    }

    boolean hasValue() {
        if (this.fShowingPresentation == null) {
            return true;
        }
        return this.fShowingPresentation.getData() != null;
    }

    void focusInput() {
        this.fViewer.getCombo().setFocus();
    }

    private void initComponents() {
        this.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 5));
        Combo combo = new Combo((Composite)this, 2056);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fViewer = new ComboViewer(combo);
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((NewsActionDescriptor)element).getName();
            }
        });
        Collection<NewsActionDescriptor> actions = this.fNewsActionPresentationManager.getSortedNewsActions();
        this.fViewer.setInput(actions);
        combo.setVisibleItemCount(actions.size());
        NewsActionDescriptor selectedFilterAction = null;
        for (NewsActionDescriptor action : actions) {
            if (!action.getActionId().equals(this.fInitialFilterAction.getActionId())) continue;
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)action));
            selectedFilterAction = action;
            this.updateInfoControl(action);
            break;
        }
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                NewsActionDescriptor descriptor = (NewsActionDescriptor)selection.getFirstElement();
                NewsActionItem.this.showFilterAction(descriptor, null);
                NewsActionItem.this.updateInfoControl(descriptor);
            }
        });
        if (selectedFilterAction != null) {
            this.showFilterAction(selectedFilterAction, this.fInitialFilterAction.getData());
        }
    }

    private void updateInfoControl(NewsActionDescriptor descriptor) {
        if (StringUtils.isSet((String)descriptor.getDescription())) {
            this.fViewer.getControl().setToolTipText(descriptor.getDescription());
        } else {
            this.fViewer.getControl().setToolTipText(null);
        }
    }

    private void showFilterAction(NewsActionDescriptor action, Object data) {
        INewsActionPresentation presentation;
        if (this.fShowingPresentation != null) {
            this.fShowingPresentation.dispose();
        }
        if ((presentation = this.fNewsActionPresentationManager.getPresentation(action.getActionId())) != null) {
            presentation.create(this, data);
            this.fShowingPresentation = presentation;
        } else {
            this.fShowingPresentation = null;
        }
        this.fViewer.getControl().getParent().layout(true, true);
    }
}

