/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.notifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.notifier.Messages;
import org.rssowl.ui.internal.notifier.NewsNotificationItem;
import org.rssowl.ui.internal.notifier.NotificationItem;
import org.rssowl.ui.internal.notifier.NotificationService;
import org.rssowl.ui.internal.notifier.NotifierColors;
import org.rssowl.ui.internal.util.CCLabel;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationPopup
extends PopupDialog {
    private static final int CLABEL_HEIGHT = 22;
    private static final int MAX_ITEMS = 30;
    private static final int DEFAULT_WIDTH = 420;
    private static final int FADE_DELAY = 40;
    private static final int FADE_IN_INCREMENT = 20;
    private static boolean fgFadeSupported = true;
    private static final String DISABLE_TRANSPARENCY = "disableNotifierTransparency";
    private static final boolean FADE_ENABLED = System.getProperty("disableNotifierTransparency") == null;
    private Shell fShell;
    private final List<NotificationItem> fDisplayedItems = new ArrayList<NotificationItem>();
    private final ResourceManager fResources;
    private Image fCloseImageNormal;
    private Image fCloseImageHot;
    private Image fCloseImagePressed;
    private CLabel fTitleCircleLabel;
    private CLabel fFooterCircleLabel;
    private Composite fInnerContentCircle;
    private Composite fOuterContentCircle;
    private final Font fNormalTextFont;
    private final Font fBoldTextFont;
    private UIJob fAutoCloser;
    private MouseTrackListener fMouseTrackListner;
    private final IPreferenceScope fGlobalScope;
    private final int fVisibleItemsCount;
    private int fItemLimit;
    private NotifierColors fNotifierColors;
    private Region fLastUsedRegion;
    private Image fMarkReadIcon;
    private Image fMarkReadDisabledIcon;
    private Image fItemStickyIcon;
    private Image fItemNonStickyIcon;
    private Image fItemNonStickyDisabledIcon;
    private Color fStickyBgColor;
    private Image fPrevImageNormal;
    private Image fPrevImagePressed;
    private Image fPrevImageDisabled;
    private Image fNextImageNormal;
    private Image fNextImagePressed;
    private Image fNextImageDisabled;
    private Image fTitleBgImage;
    private Image fFooterBgImage;
    private CLabel fNextButton;
    private CLabel fPrevButton;
    private int fDisplayOffset;
    private boolean fMouseOverNotifier;
    private FadeJob fFadeJob;
    private Collection<NotificationItem> fInitialItems;
    private final NotificationService.Mode fMode;

    NotificationPopup(int visibleItemCount, NotificationService.Mode mode) {
        super(new Shell(PlatformUI.getWorkbench().getDisplay()), 16392, mode != NotificationService.Mode.INCOMING_AUTOMATIC, false, false, false, false, null, null);
        this.fMode = mode;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.fBoldTextFont = OwlUI.getThemeFont("org.rssowl.ui.NotificationPopupFont", 1);
        this.fNormalTextFont = OwlUI.getThemeFont("org.rssowl.ui.NotificationPopupFont", 0);
        this.fGlobalScope = Owl.getPreferenceService().getGlobalScope();
        this.fItemLimit = this.fGlobalScope.getInteger(DefaultPreferences.LIMIT_NOTIFICATION_SIZE);
        if (this.fItemLimit <= 0) {
            this.fItemLimit = 30;
        }
        this.fVisibleItemsCount = visibleItemCount > this.fItemLimit ? this.fItemLimit : visibleItemCount;
        this.createAutoCloser();
        this.createMouseTrackListener();
        this.initResources();
    }

    protected int getShellStyle() {
        return 16392;
    }

    public void create() {
        super.create();
        this.makeVisible(this.fInitialItems);
        if (this.shouldFadeIn() && this.fGlobalScope.getBoolean(DefaultPreferences.FADE_NOTIFIER)) {
            this.getShell().setAlpha(0);
        }
    }

    public int open(Collection<NotificationItem> items) {
        Assert.isLegal((items != null && !items.isEmpty() ? 1 : 0) != 0);
        this.fInitialItems = items;
        int res = super.open();
        if (this.shouldFadeIn() && this.fGlobalScope.getBoolean(DefaultPreferences.FADE_NOTIFIER)) {
            this.fadeIn();
        }
        return res;
    }

    private void fadeIn() {
        if (this.fFadeJob != null) {
            this.fFadeJob.cancel();
        }
        this.fFadeJob = new FadeJob();
        this.fFadeJob.schedule();
    }

    private void addRegion(Shell shell) {
        Region region = new Region();
        Point s = shell.getSize();
        region.add(0, 0, s.x, s.y);
        region.subtract(0, 0, 5, 1);
        region.subtract(0, 1, 3, 1);
        region.subtract(0, 2, 2, 1);
        region.subtract(0, 3, 1, 1);
        region.subtract(0, 4, 1, 1);
        region.subtract(s.x - 5, 0, 5, 1);
        region.subtract(s.x - 3, 1, 3, 1);
        region.subtract(s.x - 2, 2, 2, 1);
        region.subtract(s.x - 1, 3, 1, 1);
        region.subtract(s.x - 1, 4, 1, 1);
        region.subtract(0, s.y, 5, 1);
        region.subtract(0, s.y - 1, 3, 1);
        region.subtract(0, s.y - 2, 2, 1);
        region.subtract(0, s.y - 3, 1, 1);
        region.subtract(0, s.y - 4, 1, 1);
        region.subtract(s.x - 5, 0, 5, 1);
        region.subtract(s.x - 3, 1, 3, 1);
        region.subtract(s.x - 2, 2, 2, 1);
        region.subtract(s.x - 1, 3, 1, 1);
        region.subtract(s.x - 1, 4, 1, 1);
        if (shell.getRegion() != null) {
            shell.getRegion().dispose();
        }
        shell.setRegion(region);
        this.fLastUsedRegion = region;
    }

    private void createAutoCloser() {
        this.fAutoCloser = new UIJob(PlatformUI.getWorkbench().getDisplay(), ""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!(NotificationPopup.this.fMouseOverNotifier || NotificationPopup.this.getShell() == null || NotificationPopup.this.getShell().isDisposed() || monitor.isCanceled())) {
                    NotificationPopup.this.doClose();
                }
                return Status.OK_STATUS;
            }
        };
        this.fAutoCloser.setSystem(true);
    }

    private void createMouseTrackListener() {
        this.fMouseTrackListner = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                NotificationPopup.this.fMouseOverNotifier = true;
                if (!NotificationPopup.this.fGlobalScope.getBoolean(DefaultPreferences.STICKY_NOTIFICATION_POPUP)) {
                    NotificationPopup.this.fAutoCloser.cancel();
                }
                if (NotificationPopup.this.shouldFadeIn() && NotificationPopup.this.fGlobalScope.getBoolean(DefaultPreferences.FADE_NOTIFIER) && NotificationPopup.this.getShell().getAlpha() < 255) {
                    if (NotificationPopup.this.fFadeJob != null) {
                        NotificationPopup.this.fFadeJob.cancel();
                    }
                    NotificationPopup.this.getShell().setAlpha(255);
                }
            }

            public void mouseExit(MouseEvent e) {
                NotificationPopup.this.fMouseOverNotifier = false;
                if (!NotificationPopup.this.fGlobalScope.getBoolean(DefaultPreferences.STICKY_NOTIFICATION_POPUP)) {
                    NotificationPopup.this.fAutoCloser.schedule((long)(NotificationPopup.this.fGlobalScope.getInteger(DefaultPreferences.AUTOCLOSE_NOTIFICATION_VALUE) * 1000));
                }
            }
        };
    }

    void makeVisible(Collection<NotificationItem> items) {
        if (!this.fGlobalScope.getBoolean(DefaultPreferences.STICKY_NOTIFICATION_POPUP)) {
            this.fAutoCloser.cancel();
            this.fAutoCloser.schedule((long)(this.fGlobalScope.getInteger(DefaultPreferences.AUTOCLOSE_NOTIFICATION_VALUE) * 1000));
        }
        for (NotificationItem item : items) {
            int indexOfItem = this.fDisplayedItems.indexOf(item);
            if (indexOfItem >= 0) {
                NotificationItem existingItem = this.fDisplayedItems.get(indexOfItem);
                if (existingItem.getColor() != null && item.getColor() == null) {
                    item.setColor(existingItem.getColor());
                }
                this.fDisplayedItems.set(indexOfItem, item);
                continue;
            }
            this.fDisplayedItems.add(item);
        }
        this.updateTitleLabel();
        this.updateContents(this.fDisplayOffset);
    }

    private void updateTitleLabel() {
        int totalPages = this.fDisplayedItems.size() / this.fItemLimit + (this.fDisplayedItems.size() % this.fItemLimit != 0 ? 1 : 0);
        int currentPage = this.fDisplayOffset / this.fItemLimit + 1;
        int newsCount = 0;
        int searchCount = 0;
        for (NotificationItem item : this.fDisplayedItems) {
            if (item instanceof NewsNotificationItem) {
                ++newsCount;
                continue;
            }
            ++searchCount;
        }
        String titlePart = this.fMode == NotificationService.Mode.RECENT ? Messages.NotificationPopup_RECENT_NEWS : (this.fMode == NotificationService.Mode.INCOMING_MANUAL ? Messages.NotificationPopup_INCOMING_NEWS : (newsCount == 0 && searchCount > 0 ? (searchCount == 1 ? NLS.bind((String)Messages.NotificationPopup_N_SEARCH_MATCH, (Object)searchCount) : NLS.bind((String)Messages.NotificationPopup_N_SEARCH_MATCHES, (Object)searchCount)) : NLS.bind((String)Messages.NotificationPopup_N_INCOMING, (Object)newsCount)));
        String footerPart = "";
        if (totalPages > 1) {
            footerPart = NLS.bind((String)Messages.NotificationPopup_PAGE_N_OF_M, (Object)currentPage, (Object)totalPages);
        }
        this.fTitleCircleLabel.setText(titlePart);
        this.fFooterCircleLabel.setText(footerPart);
    }

    private void updateContents(int offset) {
        Control[] children;
        Control[] controlArray = children = this.fInnerContentCircle.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        int i = offset;
        while (i < offset + this.fItemLimit && i < this.fDisplayedItems.size()) {
            this.renderItem(this.fDisplayedItems.get(i));
            ++i;
        }
        this.fOuterContentCircle.layout(true, true);
        Point oldSize = this.fShell.getSize();
        int newHeight = this.fShell.computeSize((int)420, (int)-1).y;
        newHeight = Math.max(oldSize.y, newHeight);
        Point newSize = new Point(oldSize.x, newHeight);
        Point newLocation = this.getInitialLocation(newSize);
        this.fShell.setBounds(newLocation.x, newLocation.y, newSize.x, newSize.y);
        this.addRegion(this.fShell);
        this.updateNavButtons();
    }

    private void updateItemColor(NotificationItem item, CCLabel itemLabel) {
        if (!OwlUI.isHighContrast()) {
            if (item.getColor() == null) {
                itemLabel.setForeground(itemLabel.getDisplay().getSystemColor(2));
            } else {
                itemLabel.setForeground(OwlUI.getColor(this.fResources, item.getColor()));
            }
        }
    }

    private void renderItem(final NotificationItem item) {
        CLabel imageLabel = new CLabel(this.fInnerContentCircle, 0);
        imageLabel.setBackground(this.fInnerContentCircle.getBackground());
        imageLabel.setCursor(imageLabel.getDisplay().getSystemCursor(21));
        imageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        imageLabel.addMouseTrackListener(this.fMouseTrackListner);
        imageLabel.setImage(OwlUI.getImage(this.fResources, item.getImage()));
        imageLabel.setToolTipText(item.getOrigin());
        final CCLabel itemLabel = new CCLabel(this.fInnerContentCircle, 0);
        itemLabel.setBackground(this.fInnerContentCircle.getBackground());
        itemLabel.setCursor(itemLabel.getDisplay().getSystemCursor(21));
        itemLabel.setLayoutData(new GridData(4, 0x1000000, true, false));
        itemLabel.setText(item.getText());
        itemLabel.setFont(item.isRead() ? this.fNormalTextFont : this.fBoldTextFont);
        this.updateItemColor(item, itemLabel);
        itemLabel.addMouseTrackListener(this.fMouseTrackListner);
        MouseTrackAdapter mouseTrackListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (!OwlUI.isHighContrast()) {
                    itemLabel.setForeground(itemLabel.getDisplay().getSystemColor(9));
                }
            }

            public void mouseExit(MouseEvent e) {
                NotificationPopup.this.updateItemColor(item, itemLabel);
            }
        };
        itemLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        imageLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (NotificationPopup.this.fGlobalScope.getBoolean(DefaultPreferences.CLOSE_NOTIFIER_ON_OPEN)) {
                    item.open(e);
                    NotificationPopup.this.doClose();
                } else {
                    item.setRead(true);
                    itemLabel.setFont(NotificationPopup.this.fNormalTextFont);
                    item.open(e);
                }
            }
        };
        itemLabel.addMouseListener((MouseListener)mouseListener);
        imageLabel.addMouseListener((MouseListener)mouseListener);
        CLabel markReadLabel = new CLabel(this.fInnerContentCircle, 0);
        markReadLabel.setImage(item.supportsMarkRead() ? this.fMarkReadIcon : this.fMarkReadDisabledIcon);
        markReadLabel.setBackground(this.fInnerContentCircle.getBackground());
        markReadLabel.addMouseTrackListener(this.fMouseTrackListner);
        markReadLabel.setEnabled(item.supportsMarkRead());
        markReadLabel.setCursor(this.fShell.getDisplay().getSystemCursor(21));
        markReadLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                boolean newStateRead = !item.isRead();
                itemLabel.setFont(newStateRead ? NotificationPopup.this.fNormalTextFont : NotificationPopup.this.fBoldTextFont);
                item.setRead(newStateRead);
            }
        });
        final CLabel markStickyLabel = new CLabel(this.fInnerContentCircle, 0);
        markStickyLabel.setImage(item.supportsSticky() ? this.fItemNonStickyIcon : this.fItemNonStickyDisabledIcon);
        markStickyLabel.setBackground(this.fInnerContentCircle.getBackground());
        markStickyLabel.setEnabled(item.supportsSticky());
        markStickyLabel.addMouseTrackListener(this.fMouseTrackListner);
        markStickyLabel.setCursor(this.fShell.getDisplay().getSystemCursor(21));
        markStickyLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                boolean newStateSticky;
                boolean bl = newStateSticky = !item.isSticky();
                if (!OwlUI.isHighContrast()) {
                    itemLabel.setRoundRectangleBackground(newStateSticky ? NotificationPopup.this.fStickyBgColor : null);
                }
                markStickyLabel.setImage(newStateSticky ? NotificationPopup.this.fItemStickyIcon : NotificationPopup.this.fItemNonStickyIcon);
                item.setSticky(newStateSticky);
            }
        });
        if (item.supportsSticky() && item.isSticky()) {
            if (!OwlUI.isHighContrast()) {
                itemLabel.setRoundRectangleBackground(this.fStickyBgColor);
            }
            markStickyLabel.setImage(this.fItemStickyIcon);
        }
        if (this.fGlobalScope.getBoolean(DefaultPreferences.SHOW_EXCERPT_IN_NOTIFIER)) {
            String description = item.getDescription();
            if (!StringUtils.isSet((String)description)) {
                description = Messages.NotificationPopup_NO_CONTENT;
            }
            final Composite descriptionContainer = new Composite(this.fInnerContentCircle, 0);
            descriptionContainer.setLayout((Layout)LayoutUtils.createGridLayout(1));
            ((GridLayout)descriptionContainer.getLayout()).marginBottom = 5;
            descriptionContainer.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
            descriptionContainer.addMouseTrackListener(this.fMouseTrackListner);
            descriptionContainer.setBackground(this.fInnerContentCircle.getBackground());
            descriptionContainer.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    Rectangle clArea = descriptionContainer.getClientArea();
                    gc.setForeground(NotificationPopup.this.fNotifierColors.getBorder());
                    gc.setBackground(NotificationPopup.this.fNotifierColors.getGradientEnd());
                    gc.fillGradientRectangle(4, 1, clArea.width, 1, false);
                }
            });
            Label descriptionText = new Label(descriptionContainer, 64);
            descriptionText.setLayoutData((Object)new GridData(4, 4, true, false));
            descriptionText.setFont(this.fNormalTextFont);
            descriptionText.setBackground(this.fInnerContentCircle.getBackground());
            descriptionText.setText(description);
            descriptionText.addMouseTrackListener(this.fMouseTrackListner);
        }
    }

    private void initResources() {
        this.fNotifierColors = new NotifierColors(this.getParentShell().getDisplay(), this.fResources);
        this.fStickyBgColor = OwlUI.getThemeColor("org.rssowl.ui.StickyBGColor", this.fResources, new RGB(255, 255, 180));
        this.fCloseImageNormal = OwlUI.getImage(this.fResources, "icons/etool16/close_normal.png");
        this.fCloseImageHot = OwlUI.getImage(this.fResources, "icons/etool16/close_hot.png");
        this.fCloseImagePressed = OwlUI.getImage(this.fResources, "icons/etool16/close_pressed.png");
        this.fMarkReadIcon = OwlUI.getImage(this.fResources, "icons/elcl16/mark_read_light16.gif");
        this.fMarkReadDisabledIcon = OwlUI.getImage(this.fResources, "icons/dlcl16/mark_read.gif");
        this.fItemStickyIcon = OwlUI.getImage(this.fResources, "icons/obj16/news_pinned_light16.gif");
        this.fItemNonStickyIcon = OwlUI.getImage(this.fResources, "icons/obj16/news_pin_light16.gif");
        this.fItemNonStickyDisabledIcon = OwlUI.getImage(this.fResources, "icons/obj16/news_pin_disabled.gif");
        this.fPrevImageNormal = OwlUI.getImage(this.fResources, "icons/etool16/prev_normal.png");
        this.fPrevImagePressed = OwlUI.getImage(this.fResources, "icons/etool16/prev_pressed.png");
        this.fPrevImageDisabled = OwlUI.getImage(this.fResources, "icons/etool16/prev_disabled.png");
        this.fNextImageNormal = OwlUI.getImage(this.fResources, "icons/etool16/next_normal.png");
        this.fNextImagePressed = OwlUI.getImage(this.fResources, "icons/etool16/next_pressed.png");
        this.fNextImageDisabled = OwlUI.getImage(this.fResources, "icons/etool16/next_disabled.png");
    }

    protected Control createContents(Composite parent) {
        this.fShell = parent.getShell();
        parent.setBackground(this.fNotifierColors.getBorder());
        return this.createDialogArea(parent);
    }

    protected Control createDialogArea(Composite parent) {
        ((GridLayout)parent.getLayout()).marginWidth = 1;
        ((GridLayout)parent.getLayout()).marginHeight = 1;
        Composite outerCircle = new Composite(parent, 524288);
        outerCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        outerCircle.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0));
        final Composite titleCircle = new Composite(outerCircle, 524288);
        titleCircle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        titleCircle.setBackgroundMode(2);
        titleCircle.setLayout((Layout)LayoutUtils.createGridLayout(2, 3, 0, 5, 3, false));
        titleCircle.addMouseTrackListener(this.fMouseTrackListner);
        titleCircle.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle clArea = titleCircle.getClientArea();
                Image oldBgImage = NotificationPopup.this.fTitleBgImage;
                NotificationPopup.this.fTitleBgImage = new Image((Device)titleCircle.getDisplay(), clArea.width, clArea.height);
                GC gc = new GC((Drawable)NotificationPopup.this.fTitleBgImage);
                this.drawGradient(gc, clArea);
                this.fixRegion(gc, clArea);
                gc.dispose();
                titleCircle.setBackgroundImage(NotificationPopup.this.fTitleBgImage);
                if (oldBgImage != null) {
                    oldBgImage.dispose();
                }
            }

            private void drawGradient(GC gc, Rectangle clArea) {
                gc.setForeground(NotificationPopup.this.fNotifierColors.getGradientBegin());
                gc.setBackground(NotificationPopup.this.fNotifierColors.getGradientEnd());
                gc.fillGradientRectangle(clArea.x, clArea.y, clArea.width, clArea.height, true);
            }

            private void fixRegion(GC gc, Rectangle clArea) {
                gc.setForeground(NotificationPopup.this.fNotifierColors.getBorder());
                gc.drawPoint(2, 0);
                gc.drawPoint(3, 0);
                gc.drawPoint(1, 1);
                gc.drawPoint(0, 2);
                gc.drawPoint(0, 3);
                gc.drawPoint(clArea.width - 4, 0);
                gc.drawPoint(clArea.width - 3, 0);
                gc.drawPoint(clArea.width - 2, 1);
                gc.drawPoint(clArea.width - 1, 2);
                gc.drawPoint(clArea.width - 1, 3);
            }
        });
        this.fTitleCircleLabel = new CLabel(titleCircle, 524288);
        this.fTitleCircleLabel.setImage(OwlUI.getImage(this.fResources, "icons/product/24x24.png"));
        this.fTitleCircleLabel.setText("RSSOwl");
        this.fTitleCircleLabel.setFont(this.fBoldTextFont);
        this.fTitleCircleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fTitleCircleLabel.addMouseTrackListener(this.fMouseTrackListner);
        this.fTitleCircleLabel.setCursor(this.fShell.getDisplay().getSystemCursor(21));
        this.fTitleCircleLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                NotificationPopup.this.doRestore();
            }
        });
        final CLabel closeButton = new CLabel(titleCircle, 524288);
        closeButton.setLayoutData((Object)new GridData(128));
        closeButton.setImage(this.fCloseImageNormal);
        closeButton.setCursor(this.fShell.getDisplay().getSystemCursor(21));
        closeButton.addMouseTrackListener(this.fMouseTrackListner);
        closeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                NotificationPopup.this.doClose();
            }

            public void mouseDown(MouseEvent e) {
                closeButton.setImage(NotificationPopup.this.fCloseImagePressed);
            }
        });
        closeButton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                closeButton.setImage(NotificationPopup.this.fCloseImageHot);
            }

            public void mouseExit(MouseEvent e) {
                closeButton.setImage(NotificationPopup.this.fCloseImageNormal);
            }
        });
        this.fOuterContentCircle = new Composite(outerCircle, 0);
        this.fOuterContentCircle.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        this.fOuterContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fOuterContentCircle.setBackground(outerCircle.getBackground());
        Composite middleContentCircle = new Composite(this.fOuterContentCircle, 524288);
        middleContentCircle.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        ((GridLayout)middleContentCircle.getLayout()).marginTop = 1;
        ((GridLayout)middleContentCircle.getLayout()).marginBottom = 1;
        middleContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        middleContentCircle.setBackground(this.fNotifierColors.getBorder());
        this.fInnerContentCircle = new Composite(middleContentCircle, 524288);
        this.fInnerContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fInnerContentCircle.setLayout((Layout)LayoutUtils.createGridLayout(4, 0, 5, 0, 0, false));
        ((GridLayout)this.fInnerContentCircle.getLayout()).marginLeft = 5;
        ((GridLayout)this.fInnerContentCircle.getLayout()).marginRight = 2;
        this.fInnerContentCircle.addMouseTrackListener(this.fMouseTrackListner);
        this.fInnerContentCircle.setBackground(this.fShell.getDisplay().getSystemColor(25));
        final Composite footerCircle = new Composite(outerCircle, 524288);
        footerCircle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        footerCircle.setBackgroundMode(2);
        footerCircle.setLayout((Layout)LayoutUtils.createGridLayout(3, 3, 0, 5, 3, false));
        footerCircle.addMouseTrackListener(this.fMouseTrackListner);
        footerCircle.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle clArea = footerCircle.getClientArea();
                Image oldBgImage = NotificationPopup.this.fFooterBgImage;
                NotificationPopup.this.fFooterBgImage = new Image((Device)footerCircle.getDisplay(), clArea.width, clArea.height);
                GC gc = new GC((Drawable)NotificationPopup.this.fFooterBgImage);
                this.drawGradient(gc, clArea);
                this.fixRegion(gc, clArea);
                gc.dispose();
                footerCircle.setBackgroundImage(NotificationPopup.this.fFooterBgImage);
                if (oldBgImage != null) {
                    oldBgImage.dispose();
                }
            }

            private void drawGradient(GC gc, Rectangle clArea) {
                gc.setBackground(NotificationPopup.this.fNotifierColors.getGradientBegin());
                gc.setForeground(NotificationPopup.this.fNotifierColors.getGradientEnd());
                gc.fillGradientRectangle(clArea.x, clArea.y, clArea.width, clArea.height, true);
            }

            private void fixRegion(GC gc, Rectangle clArea) {
                gc.setForeground(NotificationPopup.this.fNotifierColors.getBorder());
                gc.drawPoint(2, clArea.height - 0);
                gc.drawPoint(3, clArea.height - 0);
                gc.drawPoint(1, clArea.height - 1);
                gc.drawPoint(0, clArea.height - 2);
                gc.drawPoint(0, clArea.height - 3);
                gc.drawPoint(clArea.width - 4, clArea.height - 0);
                gc.drawPoint(clArea.width - 3, clArea.height - 0);
                gc.drawPoint(clArea.width - 2, clArea.height - 1);
                gc.drawPoint(clArea.width - 1, clArea.height - 2);
                gc.drawPoint(clArea.width - 1, clArea.height - 3);
            }
        });
        this.fFooterCircleLabel = new CLabel(footerCircle, 524288);
        this.fFooterCircleLabel.setFont(this.fBoldTextFont);
        this.fFooterCircleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fPrevButton = new CLabel(footerCircle, 524288);
        this.fPrevButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        this.fPrevButton.setCursor(this.fShell.getDisplay().getSystemCursor(21));
        this.fPrevButton.addMouseTrackListener(this.fMouseTrackListner);
        this.fPrevButton.setImage(this.fPrevImageDisabled);
        this.fPrevButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                NotificationPopup.this.onNavPrevious();
            }

            public void mouseDown(MouseEvent e) {
                if (NotificationPopup.this.canNavPrevious()) {
                    NotificationPopup.this.fPrevButton.setImage(NotificationPopup.this.fPrevImagePressed);
                }
            }
        });
        this.fNextButton = new CLabel(footerCircle, this.fMode == NotificationService.Mode.INCOMING_AUTOMATIC ? 524288 : 0);
        this.fNextButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        this.fNextButton.addMouseTrackListener(this.fMouseTrackListner);
        this.fNextButton.setCursor(this.fShell.getDisplay().getSystemCursor(21));
        this.fNextButton.setImage(this.fNextImageDisabled);
        this.fNextButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                NotificationPopup.this.onNavNext();
            }

            public void mouseDown(MouseEvent e) {
                if (NotificationPopup.this.canNavNext()) {
                    NotificationPopup.this.fNextButton.setImage(NotificationPopup.this.fNextImagePressed);
                }
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NotificationPopup.this.handleUserAction();
                if (e.keyCode == 0x1000003 || e.keyCode == 0x1000001 || e.keyCode == 0x1000005) {
                    NotificationPopup.this.onNavPrevious();
                } else if (e.keyCode == 0x1000004 || e.keyCode == 0x1000002 || e.keyCode == 0x1000006) {
                    NotificationPopup.this.onNavNext();
                } else if (e.keyCode == 0x1000007) {
                    NotificationPopup.this.onNavFirstPage();
                } else if (e.keyCode == 0x1000008) {
                    NotificationPopup.this.onNavLastPage();
                } else if (e.keyCode == 32) {
                    NotificationPopup.this.onNavNextAndMarkRead();
                } else if (e.keyCode == 13) {
                    NotificationPopup.this.doRestore();
                } else if (e.keyCode == 27) {
                    NotificationPopup.this.doClose();
                }
            }
        };
        if (this.fMode == NotificationService.Mode.INCOMING_AUTOMATIC) {
            this.fShell.addKeyListener((KeyListener)keyListener);
        } else {
            this.fNextButton.addKeyListener((KeyListener)keyListener);
        }
        this.fShell.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                NotificationPopup.this.handleUserAction();
                if (e.count < 0) {
                    NotificationPopup.this.onNavNext();
                } else if (e.count > 0) {
                    NotificationPopup.this.onNavPrevious();
                }
            }
        });
        this.fShell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                if (NotificationPopup.this.fMode != NotificationService.Mode.INCOMING_AUTOMATIC && NotificationPopup.this.fGlobalScope.getBoolean(DefaultPreferences.CLOSE_NOTIFIER_ON_OPEN)) {
                    NotificationPopup.this.doClose();
                }
            }
        });
        return outerCircle;
    }

    private void handleUserAction() {
        if (this.fMouseOverNotifier || this.fGlobalScope.getBoolean(DefaultPreferences.STICKY_NOTIFICATION_POPUP)) {
            return;
        }
        this.fAutoCloser.cancel();
        this.fAutoCloser.schedule((long)(this.fGlobalScope.getInteger(DefaultPreferences.AUTOCLOSE_NOTIFICATION_VALUE) * 1000));
    }

    protected Control getFocusControl() {
        return this.fNextButton;
    }

    private void onNavFirstPage() {
        int newOffset;
        this.fDisplayOffset = newOffset = 0;
        this.updateTitleLabel();
        this.updateContents(newOffset);
    }

    private void onNavLastPage() {
        int newOffset = this.fDisplayedItems.size() % this.fItemLimit == 0 ? this.fDisplayedItems.size() - this.fItemLimit : this.fDisplayedItems.size() - this.fDisplayedItems.size() % this.fItemLimit;
        if (newOffset >= 0) {
            this.fDisplayOffset = newOffset;
            this.updateTitleLabel();
            this.updateContents(newOffset);
        }
    }

    private boolean onNavPrevious() {
        int newOffset = this.fDisplayOffset - this.fItemLimit;
        if (newOffset >= 0) {
            this.fDisplayOffset = newOffset;
            this.updateTitleLabel();
            this.updateContents(newOffset);
            return true;
        }
        return false;
    }

    private boolean onNavNext() {
        int newOffset = this.fDisplayOffset + this.fItemLimit;
        if (newOffset < this.fDisplayedItems.size()) {
            this.fDisplayOffset = newOffset;
            this.updateTitleLabel();
            this.updateContents(newOffset);
            return true;
        }
        return false;
    }

    private void onNavNextAndMarkRead() {
        int i = this.fDisplayOffset;
        while (i < this.fDisplayOffset + this.fItemLimit && i < this.fDisplayedItems.size()) {
            NotificationItem item = this.fDisplayedItems.get(i);
            item.setRead(true);
            ++i;
        }
        boolean navigated = this.onNavNext();
        if (!navigated) {
            this.doClose();
        }
    }

    private void updateNavButtons() {
        boolean isPrevEnabled = this.canNavPrevious();
        boolean isNextEnabled = this.canNavNext();
        this.fPrevButton.setImage(isPrevEnabled ? this.fPrevImageNormal : this.fPrevImageDisabled);
        this.fNextButton.setImage(isNextEnabled ? this.fNextImageNormal : this.fNextImageDisabled);
    }

    private boolean canNavNext() {
        return this.fDisplayOffset + this.fItemLimit < this.fDisplayedItems.size();
    }

    private boolean canNavPrevious() {
        return this.fDisplayOffset - this.fItemLimit >= 0;
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle clArea = this.getPrimaryClientArea();
        return new Point(clArea.width + clArea.x - initialSize.x, clArea.height + clArea.y - initialSize.y);
    }

    protected Point getInitialSize() {
        int initialHeight = this.fShell.computeSize((int)420, (int)-1).y;
        return new Point(420, initialHeight + this.fVisibleItemsCount * 22);
    }

    private Rectangle getPrimaryClientArea() {
        Monitor primaryMonitor = this.fShell.getDisplay().getPrimaryMonitor();
        return primaryMonitor != null ? primaryMonitor.getClientArea() : this.fShell.getDisplay().getClientArea();
    }

    public boolean close() {
        return false;
    }

    protected boolean doClose() {
        this.fResources.dispose();
        if (this.fLastUsedRegion != null) {
            this.fLastUsedRegion.dispose();
        }
        if (this.fTitleBgImage != null) {
            this.fTitleBgImage.dispose();
        }
        if (this.fFooterBgImage != null) {
            this.fFooterBgImage.dispose();
        }
        if (this.fInitialItems != null) {
            this.fInitialItems.clear();
        }
        return super.close();
    }

    private void doRestore() {
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null) {
            OwlUI.restoreWindow(page);
            this.doClose();
        }
    }

    private boolean shouldFadeIn() {
        return this.fMode == NotificationService.Mode.INCOMING_AUTOMATIC && FADE_ENABLED && fgFadeSupported;
    }

    private class FadeJob
    extends UIJob {
        FadeJob() {
            super("");
            this.setSystem(true);
        }

        private boolean proceed(IProgressMonitor monitor) {
            Shell shell = NotificationPopup.this.getShell();
            return !monitor.isCanceled() && shell != null && !shell.isDisposed() && !shell.getDisplay().isDisposed() && !Controller.getDefault().isShuttingDown();
        }

        public IStatus runInUIThread(final IProgressMonitor monitor) {
            if (this.proceed(monitor)) {
                final int alpha = NotificationPopup.this.getShell().getAlpha();
                if (NotificationPopup.this.shouldFadeIn() && alpha < 255 && this.proceed(monitor)) {
                    NotificationPopup.this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (FadeJob.this.proceed(monitor)) {
                                int newAlpha = Math.min(alpha + 20, 255);
                                NotificationPopup.this.getShell().setAlpha(newAlpha);
                                if (newAlpha != NotificationPopup.this.getShell().getAlpha()) {
                                    fgFadeSupported = false;
                                }
                            }
                        }
                    });
                    this.schedule(40L);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

