/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;
import org.rssowl.ui.internal.util.UIBackgroundJob;

public class JobRunner {
    private static int nextBusyId = 1;
    private static final String BUSYID_NAME = "SWT BusyIndicator";
    private static final int DELAY = 800;

    public static void runInUIThread(Widget widget, Runnable runnable) {
        JobRunner.runInUIThread(0, widget, runnable);
    }

    public static void runDelayedInUIThread(Widget widget, Runnable runnable) {
        JobRunner.runInUIThread(800, widget, runnable);
    }

    public static void runInUIThread(int delay, Widget widget, Runnable runnable) {
        JobRunner.runInUIThread(delay, false, widget, runnable);
    }

    public static void runInUIThread(int delay, boolean forceAsync, final Widget widget, final Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        if (!(forceAsync || delay != 0 || widget != null && widget.isDisposed() || Display.getCurrent() == null)) {
            runnable.run();
        } else {
            UIJob uiJob = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (widget == null || !widget.isDisposed()) {
                        runnable.run();
                    }
                    return Status.OK_STATUS;
                }
            };
            uiJob.setSystem(true);
            uiJob.setUser(false);
            uiJob.schedule((long)delay);
        }
    }

    public static void runSyncedInUIThread(final Widget widget, final Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        Assert.isNotNull((Object)widget);
        if (!widget.isDisposed()) {
            widget.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!widget.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    public static void runSyncedInUIThread(final Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                runnable.run();
            }
        });
    }

    public static void runInBackgroundThread(Runnable runnable) {
        JobRunner.runInBackgroundThread(0, runnable);
    }

    public static void runDelayedInBackgroundThread(Runnable runnable) {
        JobRunner.runInBackgroundThread(800, runnable);
    }

    public static void runInBackgroundThread(int delay, final Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        Job job = new Job(""){

            public IStatus run(IProgressMonitor monitor) {
                runnable.run();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule((long)delay);
    }

    public static void runUIUpdater(UIBackgroundJob job) {
        JobRunner.runUIUpdater(job, false);
    }

    public static void runUIUpdater(UIBackgroundJob job, boolean showProgress) {
        Assert.isNotNull((Object)((Object)job));
        if (!showProgress) {
            job.setSystem(true);
            job.setUser(false);
        }
        job.schedule();
    }

    public static void runInBackgroundWithBusyIndicator(final Runnable runnable) {
        Shell[] shells;
        final Display display = Display.getCurrent();
        final Integer busyId = nextBusyId++;
        if (display == null) {
            throw new IllegalStateException("Method was not called from the UI-Thread!");
        }
        Cursor cursor = display.getSystemCursor(3);
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            Integer id = (Integer)shell.getData(BUSYID_NAME);
            if (id == null) {
                shell.setCursor(cursor);
                shell.setData(BUSYID_NAME, (Object)busyId);
            }
            ++n2;
        }
        JobRunner.runUIUpdater(new UIBackgroundJob(null){

            protected void runInBackground(IProgressMonitor monitor) {
                runnable.run();
            }

            protected void runInUI(IProgressMonitor monitor) {
                if (!display.isDisposed()) {
                    Shell[] shells;
                    Shell[] shellArray = shells = display.getShells();
                    int n = shells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Shell shell = shellArray[n2];
                        Integer id = (Integer)shell.getData(JobRunner.BUSYID_NAME);
                        if (busyId.equals(id)) {
                            shell.setCursor(null);
                            shell.setData(JobRunner.BUSYID_NAME, null);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public static void runDelayedFlagInversion(int delay, final AtomicBoolean flag) {
        flag.set(!flag.get());
        JobRunner.runInBackgroundThread(delay, new Runnable(){

            public void run() {
                flag.set(!flag.get());
            }
        });
    }
}

