/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.views.explorer;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IInputProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IPreferenceDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.FolderAdapter;
import org.rssowl.core.persist.event.FolderEvent;
import org.rssowl.core.persist.event.FolderListener;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.BookMarkReference;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.FolderReference;
import org.rssowl.core.persist.reference.ModelReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.ITreeNode;
import org.rssowl.core.util.ModelTreeNode;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.TreeTraversal;
import org.rssowl.ui.internal.ContextMenuCreator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.ShareProvider;
import org.rssowl.ui.internal.StatusLineUpdater;
import org.rssowl.ui.internal.actions.DeleteTypesAction;
import org.rssowl.ui.internal.actions.EntityPropertyDialogAction;
import org.rssowl.ui.internal.actions.FindAction;
import org.rssowl.ui.internal.actions.NewBookMarkAction;
import org.rssowl.ui.internal.actions.NewFolderAction;
import org.rssowl.ui.internal.actions.NewNewsBinAction;
import org.rssowl.ui.internal.actions.NewSearchMarkAction;
import org.rssowl.ui.internal.actions.OpenAction;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.actions.OpenInNewTabAction;
import org.rssowl.ui.internal.actions.ReloadTypesAction;
import org.rssowl.ui.internal.actions.SearchInTypeAction;
import org.rssowl.ui.internal.actions.SendLinkAction;
import org.rssowl.ui.internal.dialogs.ManageSetsDialog;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.editors.feed.PerformAfterInputSet;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.WidgetTreeNode;
import org.rssowl.ui.internal.views.explorer.BookMarkContentProvider;
import org.rssowl.ui.internal.views.explorer.BookMarkDNDImpl;
import org.rssowl.ui.internal.views.explorer.BookMarkFilter;
import org.rssowl.ui.internal.views.explorer.BookMarkGrouping;
import org.rssowl.ui.internal.views.explorer.BookMarkLabelProvider;
import org.rssowl.ui.internal.views.explorer.BookMarkSearchbar;
import org.rssowl.ui.internal.views.explorer.BookMarkSorter;
import org.rssowl.ui.internal.views.explorer.BookMarkViewer;
import org.rssowl.ui.internal.views.explorer.Messages;

public class BookMarkExplorer
extends ViewPart {
    public static final String VIEW_ID = "org.rssowl.ui.BookMarkExplorer";
    public static final String NEXT_SET_ACTION = "org.rssowl.ui.internal.views.explorer.NextSetAction";
    public static final String PREVIOUS_SET_ACTION = "org.rssowl.ui.internal.views.explorer.PreviousSetAction";
    private static final String PREF_SELECTED_FOLDER_CHILD = "org.rssowl.ui.internal.views.explorer.SelectedFolderChild";
    private static final String PREF_SELECTED_BOOKMARK_SET = "org.rssowl.ui.internal.views.explorer.SelectedBookMarkSet";
    private static final String PREF_EXPANDED_NODES = "org.rssowl.ui.internal.views.explorer.ExpandedNodes";
    private static final String GROUP_ACTION = "org.rssowl.ui.internal.views.explorer.GroupAction";
    private static final String FILTER_ACTION = "org.rssowl.ui.internal.views.explorer.FilterAction";
    private IPreferenceScope fGlobalPreferences;
    private List<Long> fExpandedNodes;
    private boolean fBeginSearchOnTyping;
    private boolean fAlwaysShowSearch;
    private boolean fSortByName;
    private BookMarkFilter.Type fFilterType;
    private BookMarkGrouping.Type fGroupingType;
    private IFolder fSelectedBookMarkSet;
    private boolean fLinkingEnabled;
    private boolean fFaviconsEnabled;
    private long fLastSelectedFolderChild;
    private TreeViewer fViewer;
    private BookMarkContentProvider fContentProvider;
    private BookMarkLabelProvider fLabelProvider;
    private BookMarkSorter fBookMarkComparator;
    private BookMarkFilter fBookMarkFilter;
    private BookMarkGrouping fBookMarkGrouping;
    private Label fSeparator;
    private Composite fSearchBarContainer;
    private BookMarkSearchbar fSearchBar;
    private IToolBarManager fToolBarManager;
    private Set<IFolder> fRootFolders;
    private IViewSite fViewSite;
    private IStructuredSelection fLastSelection;
    private FolderListener fFolderListener;
    private IPartListener2 fPartListener;
    private IPreferenceDAO fPrefDAO;
    private IPropertyChangeListener fPropertyChangeListener;
    private boolean fBlockSaveState;
    private BookMarkFilter.Type fLastFilterType;
    private BookMarkGrouping.Type fLastGroupType;

    public static String getSelectedBookMarkSetPref(IWorkbenchWindow window) {
        int windowIndex = OwlUI.getWindowIndex(window);
        return PREF_SELECTED_BOOKMARK_SET + windowIndex;
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        parent.setBackground(parent.getDisplay().getSystemColor(25));
        this.createViewer(parent);
        this.restoreExpandedElements();
        if (this.fLastSelectedFolderChild > 0L && !this.fLinkingEnabled) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)new BookMarkReference(this.fLastSelectedFolderChild)), true);
        }
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)new StatusLineUpdater(this.getViewSite().getActionBars().getStatusLineManager()));
        this.hookGlobalActions();
        this.hookContextualMenu();
        this.hookToolBar();
        this.hookViewMenu();
        this.registerListeners();
        this.fViewSite.setSelectionProvider((ISelectionProvider)this.fViewer);
        this.createSearchBar(parent);
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.fViewSite.getAdapter(IWorkbenchSiteProgressService.class);
        service.showBusyForFamily(Controller.getDefault().getReloadFamily());
    }

    private void createViewer(Composite parent) {
        IWorkbenchPart activePart;
        this.fViewer = new BookMarkViewer(this, parent, 770);
        this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.getControl().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        this.fViewer.getControl().setFont(OwlUI.getThemeFont("org.rssowl.ui.BookmarkExplorerFont", 0));
        this.initDragAndDrop();
        this.fViewer.setComparer(this.getComparer());
        this.fViewer.setUseHashlookup(true);
        this.fContentProvider = new BookMarkContentProvider();
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = new BookMarkLabelProvider();
        this.fLabelProvider.setUseFavicons(this.fFaviconsEnabled);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fBookMarkComparator = new BookMarkSorter();
        if (this.fSortByName) {
            this.fBookMarkComparator.setType(BookMarkSorter.Type.SORT_BY_NAME);
        }
        this.fViewer.setComparator((ViewerComparator)this.fBookMarkComparator);
        this.fBookMarkFilter = new BookMarkFilter();
        this.fBookMarkFilter.setType(this.fFilterType);
        this.fViewer.addFilter((ViewerFilter)this.fBookMarkFilter);
        this.fBookMarkGrouping = new BookMarkGrouping();
        this.fBookMarkGrouping.setType(this.fGroupingType);
        this.fContentProvider.setBookmarkFilter(this.fBookMarkFilter);
        this.fContentProvider.setBookmarkGrouping(this.fBookMarkGrouping);
        this.fViewer.setInput((Object)this.fSelectedBookMarkSet);
        this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BookMarkExplorer.this.onSelectionChanged(event);
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                OwlUI.openInFeedView(BookMarkExplorer.this.fViewSite.getPage(), (IStructuredSelection)BookMarkExplorer.this.fViewer.getSelection());
            }
        });
        if (!OwlUI.isHighContrast()) {
            this.fViewer.getControl().addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    Object element = event.item.getData();
                    BookMarkExplorer.this.fLabelProvider.erase(event, element);
                }
            });
        }
        this.fViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                BookMarkExplorer.this.onTreeEvent(event.getElement(), true);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                BookMarkExplorer.this.onTreeEvent(event.getElement(), false);
            }
        });
        if (this.fLinkingEnabled && (activePart = this.fViewSite.getPage().getActivePart()) instanceof IEditorPart) {
            this.editorActivated((IEditorPart)activePart);
        }
    }

    private void initDragAndDrop() {
        int ops = 7;
        Transfer[] dragTransfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), URLTransfer.getInstance()};
        Transfer[] dropTransfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), URLTransfer.getInstance(), FileTransfer.getInstance()};
        BookMarkDNDImpl bookmarkDND = new BookMarkDNDImpl(this, (Viewer)this.fViewer);
        this.fViewer.addDragSupport(ops, dragTransfers, (DragSourceListener)bookmarkDND);
        this.fViewer.addDropSupport(ops, dropTransfers, (DropTargetListener)bookmarkDND);
    }

    private void onSelectionChanged(SelectionChangedEvent event) {
        this.fLastSelection = (IStructuredSelection)event.getSelection();
        if (this.fLinkingEnabled) {
            this.linkToFeedView(this.fLastSelection);
        }
    }

    private void onTreeEvent(Object element, boolean expanded) {
        if (expanded) {
            if (element instanceof IFolder) {
                this.fExpandedNodes.add(((IFolder)element).getId());
            } else if (element instanceof EntityGroup) {
                this.fExpandedNodes.add(((EntityGroup)element).getId());
            }
        } else if (element instanceof IFolder) {
            this.fExpandedNodes.remove(((IFolder)element).getId());
        } else if (element instanceof EntityGroup) {
            this.fExpandedNodes.remove(((EntityGroup)element).getId());
        }
    }

    private IElementComparer getComparer() {
        return new IElementComparer(){

            public boolean equals(Object a, Object b) {
                if (a == b && a != null) {
                    return true;
                }
                if (a instanceof FeedLinkReference || b instanceof FeedLinkReference) {
                    FeedLinkReference ref1 = null;
                    FeedLinkReference ref2 = null;
                    if (a instanceof IBookMark) {
                        ref1 = ((IBookMark)a).getFeedLinkReference();
                    } else if (a instanceof FeedLinkReference) {
                        ref1 = (FeedLinkReference)a;
                    }
                    if (b instanceof IBookMark) {
                        ref2 = ((IBookMark)b).getFeedLinkReference();
                    } else if (b instanceof FeedLinkReference) {
                        ref2 = (FeedLinkReference)b;
                    }
                    if (ref1 != null) {
                        return ref1.equals((Object)ref2);
                    }
                    return false;
                }
                long id1 = 0L;
                long id2 = 0L;
                if (a instanceof IEntity) {
                    id1 = ((IEntity)a).getId();
                } else if (a instanceof ModelReference) {
                    id1 = ((ModelReference)a).getId();
                } else if (a instanceof EntityGroup) {
                    id1 = ((EntityGroup)a).getId();
                }
                if (b instanceof IEntity) {
                    id2 = ((IEntity)b).getId();
                } else if (b instanceof ModelReference) {
                    id2 = ((ModelReference)b).getId();
                } else if (b instanceof EntityGroup) {
                    id2 = ((EntityGroup)b).getId();
                }
                return id1 == id2;
            }

            public int hashCode(Object element) {
                return element.hashCode();
            }
        };
    }

    private void linkToFeedView(IStructuredSelection selection) {
        if (this != this.fViewSite.getPage().getActivePart()) {
            return;
        }
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] editorReferences = activePage.getEditorReferences();
            IEditorReference reference = EditorUtils.findEditor(editorReferences, element);
            if (reference != null) {
                activePage.bringToTop(reference.getPart(true));
            }
        }
    }

    private void editorActivated(IEditorPart part) {
        if (!this.fLinkingEnabled || part == null) {
            return;
        }
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput instanceof FeedViewInput) {
            this.reveal((IFolderChild)((FeedViewInput)editorInput).getMark(), false);
        }
    }

    public boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    public void reveal(IFolderChild element, boolean expand) {
        if (!this.fViewSite.getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        IFolderChild child = element;
        while (child.getParent() != null) {
            child = child.getParent();
        }
        if (!this.fSelectedBookMarkSet.equals(child)) {
            this.changeSet((IFolder)child);
        }
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        if (expand) {
            this.fViewer.setExpandedState((Object)element, true);
            this.fExpandedNodes.add(element.getId());
        }
    }

    void changeSet(IFolder folder) {
        this.saveExpandedElements();
        this.fSelectedBookMarkSet = folder;
        this.fViewer.setInput((Object)this.fSelectedBookMarkSet);
        this.fExpandedNodes.clear();
        this.loadExpandedElements();
        this.fViewer.getControl().setRedraw(false);
        try {
            this.restoreExpandedElements();
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
        this.fViewSite.getActionBars().getToolBarManager().find(PREVIOUS_SET_ACTION).update("enabled");
        this.fViewSite.getActionBars().getToolBarManager().find(NEXT_SET_ACTION).update("enabled");
        IPreference pref = this.fPrefDAO.loadOrCreate(BookMarkExplorer.getSelectedBookMarkSetPref(this.fViewSite.getWorkbenchWindow()));
        pref.putLongs(new long[]{this.fSelectedBookMarkSet.getId()});
        this.fPrefDAO.save((IPersistable)pref);
    }

    private void createSearchBar(Composite parent) {
        this.fSeparator = new Label(parent, 258);
        this.fSeparator.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSearchBarContainer = new Composite(parent, 0);
        this.fSearchBarContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fSeparator.getLayoutData()).exclude = !this.fAlwaysShowSearch;
        ((GridData)this.fSearchBarContainer.getLayoutData()).exclude = !this.fAlwaysShowSearch;
        GridLayout searchBarLayout = new GridLayout(1, false);
        searchBarLayout.marginHeight = 2;
        searchBarLayout.marginWidth = 2;
        this.fSearchBarContainer.setLayout((Layout)searchBarLayout);
        this.fSearchBar = new BookMarkSearchbar(this.fViewSite, this.fSearchBarContainer, this.fViewer, this.fBookMarkFilter);
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!BookMarkExplorer.this.fBeginSearchOnTyping) {
                    return;
                }
                if (e.character > ' ' && e.character != '\u007f') {
                    BookMarkExplorer.this.setSearchBarVisible(true);
                    BookMarkExplorer.this.fSearchBar.getControl().append(String.valueOf(e.character));
                    BookMarkExplorer.this.fSearchBar.getControl().setFocus();
                    e.doit = false;
                } else if (e.keyCode == 27 && BookMarkExplorer.this.fSearchBar.getControl().getText().length() != 0) {
                    BookMarkExplorer.this.fSearchBar.setFilterText("");
                    BookMarkExplorer.this.setSearchBarVisible(BookMarkExplorer.this.fAlwaysShowSearch);
                    BookMarkExplorer.this.setFocus();
                }
            }
        });
        this.fSearchBar.getControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BookMarkExplorer.this.fAlwaysShowSearch) {
                    return;
                }
                if (BookMarkExplorer.this.fSearchBar.getControl().getText().length() == 0) {
                    BookMarkExplorer.this.setSearchBarVisible(false);
                    BookMarkExplorer.this.setFocus();
                }
            }
        });
    }

    void setSearchBarVisible(boolean visible) {
        if (visible != ((GridData)this.fSeparator.getLayoutData()).exclude) {
            return;
        }
        ((GridData)this.fSeparator.getLayoutData()).exclude = !visible;
        ((GridData)this.fSearchBarContainer.getLayoutData()).exclude = !visible;
        this.fSearchBarContainer.getParent().layout();
    }

    private void hookViewMenu() {
        IMenuManager menuManager = this.fViewSite.getActionBars().getMenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action manageSets = new Action(Messages.BookMarkExplorer_MANAGE_SETS){

                    public void run() {
                        ManageSetsDialog instance = ManageSetsDialog.getVisibleInstance();
                        if (instance == null) {
                            ManageSetsDialog dialog = new ManageSetsDialog(BookMarkExplorer.this.fViewSite.getShell(), BookMarkExplorer.this.fSelectedBookMarkSet);
                            dialog.open();
                        } else {
                            instance.getShell().forceActive();
                        }
                    }
                };
                manager.add((IAction)manageSets);
                manager.add((IContributionItem)new Separator());
                for (final IFolder rootFolder : BookMarkExplorer.this.fRootFolders) {
                    Action selectBookMarkSet = new Action(rootFolder.getName(), 8){

                        public void run() {
                            if (!BookMarkExplorer.this.fSelectedBookMarkSet.equals(rootFolder) && this.isChecked()) {
                                BookMarkExplorer.this.changeSet(rootFolder);
                            }
                        }
                    };
                    selectBookMarkSet.setImageDescriptor(OwlUI.BOOKMARK_SET);
                    if (BookMarkExplorer.this.fSelectedBookMarkSet.equals(rootFolder)) {
                        selectBookMarkSet.setChecked(true);
                    }
                    manager.add((IAction)selectBookMarkSet);
                }
                manager.add((IContributionItem)new Separator());
                MenuManager searchMenu = new MenuManager(Messages.BookMarkExplorer_FIND);
                manager.add((IContributionItem)searchMenu);
                Action alwaysShow = new Action(Messages.BookMarkExplorer_ALWAYS_SHOW, 2){

                    public void run() {
                        BookMarkExplorer.this.fAlwaysShowSearch = !BookMarkExplorer.this.fAlwaysShowSearch;
                        if (BookMarkExplorer.this.fSearchBar.getControl().getText().length() == 0) {
                            BookMarkExplorer.this.setSearchBarVisible(BookMarkExplorer.this.fAlwaysShowSearch);
                        }
                    }
                };
                alwaysShow.setChecked(BookMarkExplorer.this.fAlwaysShowSearch);
                searchMenu.add((IAction)alwaysShow);
                Action beginWhenTyping = new Action(Messages.BookMarkExplorer_BEGIN_WHEN_TYPING, 2){

                    public void run() {
                        BookMarkExplorer.this.fBeginSearchOnTyping = !BookMarkExplorer.this.fBeginSearchOnTyping;
                    }
                };
                beginWhenTyping.setChecked(BookMarkExplorer.this.fBeginSearchOnTyping);
                searchMenu.add((IAction)beginWhenTyping);
                manager.add((IContributionItem)new Separator());
                Action sortByName = new Action(Messages.BookMarkExplorer_SORT_BY_NAME, 2){

                    public void run() {
                        BookMarkExplorer.this.fSortByName = !BookMarkExplorer.this.fSortByName;
                        if (BookMarkExplorer.this.fSortByName) {
                            BookMarkExplorer.this.fBookMarkComparator.setType(BookMarkSorter.Type.SORT_BY_NAME);
                        } else {
                            BookMarkExplorer.this.fBookMarkComparator.setType(BookMarkSorter.Type.DEFAULT_SORTING);
                        }
                        BookMarkExplorer.this.fViewer.refresh(false);
                        BookMarkExplorer.this.fGlobalPreferences.putBoolean(DefaultPreferences.BE_SORT_BY_NAME, BookMarkExplorer.this.fSortByName);
                    }
                };
                sortByName.setChecked(BookMarkExplorer.this.fSortByName);
                manager.add((IAction)sortByName);
                Action showFavicons = new Action(Messages.BookMarkExplorer_SHOW_FAVICONS, 2){

                    public void run() {
                        BookMarkExplorer.this.fFaviconsEnabled = this.isChecked();
                        BookMarkExplorer.this.fLabelProvider.setUseFavicons(BookMarkExplorer.this.fFaviconsEnabled);
                        BookMarkExplorer.this.fViewer.getTree().setRedraw(false);
                        try {
                            BookMarkExplorer.this.fViewer.refresh(true);
                        }
                        finally {
                            BookMarkExplorer.this.fViewer.getTree().setRedraw(true);
                        }
                    }
                };
                showFavicons.setChecked(BookMarkExplorer.this.fFaviconsEnabled);
                manager.add((IAction)showFavicons);
                manager.add((IContributionItem)new Separator());
                Action linkFeedView = new Action(Messages.BookMarkExplorer_LINKING, 2){

                    public void run() {
                        IEditorPart editor;
                        BookMarkExplorer.this.fLinkingEnabled = this.isChecked();
                        if (BookMarkExplorer.this.fLinkingEnabled && (editor = BookMarkExplorer.this.fViewSite.getPage().getActiveEditor()) != null) {
                            BookMarkExplorer.this.editorActivated(editor);
                        }
                    }
                };
                linkFeedView.setChecked(BookMarkExplorer.this.fLinkingEnabled);
                linkFeedView.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/synced.gif"));
                manager.add((IAction)linkFeedView);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        menuManager.add((IAction)new Action(""){});
    }

    private void hookToolBar() {
        this.fToolBarManager = this.fViewSite.getActionBars().getToolBarManager();
        Action bookmarkFilter = new Action(Messages.BookMarkExplorer_FILTER_ELEMENTS, 4){

            public void run() {
                if (BookMarkExplorer.this.fBookMarkFilter.getType() != BookMarkFilter.Type.SHOW_ALL) {
                    BookMarkExplorer.this.doFilter(BookMarkFilter.Type.SHOW_ALL);
                } else if (BookMarkExplorer.this.fLastFilterType != null) {
                    BookMarkExplorer.this.doFilter(BookMarkExplorer.this.fLastFilterType);
                } else if (BookMarkExplorer.this.fToolBarManager instanceof ToolBarManager) {
                    OwlUI.positionDropDownMenu(this, (ToolBarManager)BookMarkExplorer.this.fToolBarManager);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                if (BookMarkExplorer.this.fBookMarkFilter.getType() == BookMarkFilter.Type.SHOW_ALL) {
                    return OwlUI.FILTER;
                }
                return OwlUI.getImageDescriptor("icons/etool16/filter_active.gif");
            }
        };
        bookmarkFilter.setId(FILTER_ACTION);
        bookmarkFilter.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                Menu menu = new Menu(parent);
                final MenuItem showAll = new MenuItem(menu, 16);
                showAll.setText(Messages.BookMarkExplorer_SHOW_ALL);
                showAll.setSelection(BookMarkFilter.Type.SHOW_ALL == BookMarkExplorer.this.fBookMarkFilter.getType());
                menu.setDefaultItem(showAll);
                showAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showAll.getSelection() && BookMarkExplorer.this.fBookMarkFilter.getType() != BookMarkFilter.Type.SHOW_ALL) {
                            BookMarkExplorer.this.doFilter(BookMarkFilter.Type.SHOW_ALL);
                        }
                    }
                });
                new MenuItem(menu, 2);
                final MenuItem showNew = new MenuItem(menu, 16);
                showNew.setText(Messages.BookMarkExplorer_SHOW_NEW);
                showNew.setSelection(BookMarkFilter.Type.SHOW_NEW == BookMarkExplorer.this.fBookMarkFilter.getType());
                showNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showNew.getSelection() && BookMarkExplorer.this.fBookMarkFilter.getType() != BookMarkFilter.Type.SHOW_NEW) {
                            BookMarkExplorer.this.doFilter(BookMarkFilter.Type.SHOW_NEW);
                        }
                    }
                });
                final MenuItem showUnread = new MenuItem(menu, 16);
                showUnread.setText(Messages.BookMarkExplorer_SHOW_UNREAD);
                showUnread.setSelection(BookMarkFilter.Type.SHOW_UNREAD == BookMarkExplorer.this.fBookMarkFilter.getType());
                showUnread.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showUnread.getSelection() && BookMarkExplorer.this.fBookMarkFilter.getType() != BookMarkFilter.Type.SHOW_UNREAD) {
                            BookMarkExplorer.this.doFilter(BookMarkFilter.Type.SHOW_UNREAD);
                        }
                    }
                });
                final MenuItem showSticky = new MenuItem(menu, 16);
                showSticky.setText(Messages.BookMarkExplorer_SHOW_STICKY);
                showSticky.setSelection(BookMarkFilter.Type.SHOW_STICKY == BookMarkExplorer.this.fBookMarkFilter.getType());
                showSticky.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showSticky.getSelection() && BookMarkExplorer.this.fBookMarkFilter.getType() != BookMarkFilter.Type.SHOW_STICKY) {
                            BookMarkExplorer.this.doFilter(BookMarkFilter.Type.SHOW_STICKY);
                        }
                    }
                });
                new MenuItem(menu, 2);
                final MenuItem showErroneous = new MenuItem(menu, 16);
                showErroneous.setText(Messages.BookMarkExplorer_SHOW_ERROR);
                showErroneous.setSelection(BookMarkFilter.Type.SHOW_ERRONEOUS == BookMarkExplorer.this.fBookMarkFilter.getType());
                showErroneous.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showErroneous.getSelection() && BookMarkExplorer.this.fBookMarkFilter.getType() != BookMarkFilter.Type.SHOW_ERRONEOUS) {
                            BookMarkExplorer.this.doFilter(BookMarkFilter.Type.SHOW_ERRONEOUS);
                        }
                    }
                });
                final MenuItem showNeverVisited = new MenuItem(menu, 16);
                showNeverVisited.setText(Messages.BookMarkExplorer_SHOW_NEVER_VISITED);
                showNeverVisited.setSelection(BookMarkFilter.Type.SHOW_NEVER_VISITED == BookMarkExplorer.this.fBookMarkFilter.getType());
                showNeverVisited.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showNeverVisited.getSelection() && BookMarkExplorer.this.fBookMarkFilter.getType() != BookMarkFilter.Type.SHOW_NEVER_VISITED) {
                            BookMarkExplorer.this.doFilter(BookMarkFilter.Type.SHOW_NEVER_VISITED);
                        }
                    }
                });
                return menu;
            }
        });
        this.fToolBarManager.add((IAction)bookmarkFilter);
        this.fToolBarManager.add((IContributionItem)new Separator());
        Action bookmarkGroup = new Action(Messages.BookMarkExplorer_GROUP_ELEMENTS, 4){

            public void run() {
                if (BookMarkExplorer.this.fBookMarkGrouping.getType() != BookMarkGrouping.Type.NO_GROUPING) {
                    BookMarkExplorer.this.doGrouping(BookMarkGrouping.Type.NO_GROUPING);
                } else if (BookMarkExplorer.this.fLastGroupType != null) {
                    BookMarkExplorer.this.doGrouping(BookMarkExplorer.this.fLastGroupType);
                } else if (BookMarkExplorer.this.fToolBarManager instanceof ToolBarManager) {
                    OwlUI.positionDropDownMenu(this, (ToolBarManager)BookMarkExplorer.this.fToolBarManager);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                if (BookMarkExplorer.this.fBookMarkGrouping.getType() == BookMarkGrouping.Type.NO_GROUPING) {
                    return OwlUI.getImageDescriptor("icons/etool16/group.gif");
                }
                return OwlUI.getImageDescriptor("icons/etool16/group_active.gif");
            }
        };
        bookmarkGroup.setId(GROUP_ACTION);
        bookmarkGroup.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                Menu menu = new Menu(parent);
                final MenuItem noGrouping = new MenuItem(menu, 16);
                noGrouping.setText(Messages.BookMarkExplorer_NO_GROUPING);
                noGrouping.setSelection(BookMarkGrouping.Type.NO_GROUPING == BookMarkExplorer.this.fBookMarkGrouping.getType());
                menu.setDefaultItem(noGrouping);
                noGrouping.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (noGrouping.getSelection() && BookMarkExplorer.this.fBookMarkGrouping.getType() != BookMarkGrouping.Type.NO_GROUPING) {
                            BookMarkExplorer.this.doGrouping(BookMarkGrouping.Type.NO_GROUPING);
                        }
                    }
                });
                new MenuItem(menu, 2);
                final MenuItem groupByType = new MenuItem(menu, 16);
                groupByType.setText(Messages.BookMarkExplorer_GROUP_BY_TYPE);
                groupByType.setSelection(BookMarkGrouping.Type.GROUP_BY_TYPE == BookMarkExplorer.this.fBookMarkGrouping.getType());
                groupByType.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByType.getSelection() && BookMarkExplorer.this.fBookMarkGrouping.getType() != BookMarkGrouping.Type.GROUP_BY_TYPE) {
                            BookMarkExplorer.this.doGrouping(BookMarkGrouping.Type.GROUP_BY_TYPE);
                        }
                    }
                });
                final MenuItem groupByState = new MenuItem(menu, 16);
                groupByState.setText(Messages.BookMarkExplorer_GROUP_BY_STATE);
                groupByState.setSelection(BookMarkGrouping.Type.GROUP_BY_STATE == BookMarkExplorer.this.fBookMarkGrouping.getType());
                groupByState.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByState.getSelection() && BookMarkExplorer.this.fBookMarkGrouping.getType() != BookMarkGrouping.Type.GROUP_BY_STATE) {
                            BookMarkExplorer.this.doGrouping(BookMarkGrouping.Type.GROUP_BY_STATE);
                        }
                    }
                });
                new MenuItem(menu, 2);
                final MenuItem groupByLastVisit = new MenuItem(menu, 16);
                groupByLastVisit.setText(Messages.BookMarkExplorer_GROUP_BY_LAST_VISIT);
                groupByLastVisit.setSelection(BookMarkGrouping.Type.GROUP_BY_LAST_VISIT == BookMarkExplorer.this.fBookMarkGrouping.getType());
                groupByLastVisit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByLastVisit.getSelection() && BookMarkExplorer.this.fBookMarkGrouping.getType() != BookMarkGrouping.Type.GROUP_BY_LAST_VISIT) {
                            BookMarkExplorer.this.doGrouping(BookMarkGrouping.Type.GROUP_BY_LAST_VISIT);
                        }
                    }
                });
                final MenuItem groupByPopularity = new MenuItem(menu, 16);
                groupByPopularity.setText(Messages.BookMarkExplorer_GROUP_BY_POPULARITY);
                groupByPopularity.setSelection(BookMarkGrouping.Type.GROUP_BY_POPULARITY == BookMarkExplorer.this.fBookMarkGrouping.getType());
                groupByPopularity.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByPopularity.getSelection() && BookMarkExplorer.this.fBookMarkGrouping.getType() != BookMarkGrouping.Type.GROUP_BY_POPULARITY) {
                            BookMarkExplorer.this.doGrouping(BookMarkGrouping.Type.GROUP_BY_POPULARITY);
                        }
                    }
                });
                return menu;
            }
        });
        this.fToolBarManager.add((IAction)bookmarkGroup);
        this.fToolBarManager.add((IContributionItem)new Separator());
        Action collapseAll = new Action(Messages.BookMarkExplorer_COLLAPSE_ALL){

            public void run() {
                BookMarkExplorer.this.fViewer.collapseAll();
                BookMarkExplorer.this.fExpandedNodes.clear();
            }
        };
        collapseAll.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/collapseall.gif"));
        this.fToolBarManager.add((IAction)collapseAll);
        Action previousSet = new Action(Messages.BookMarkExplorer_PREVIOUS_SET){

            public void run() {
                int index = BookMarkExplorer.this.getIndexOfRootFolder(BookMarkExplorer.this.fSelectedBookMarkSet);
                BookMarkExplorer.this.changeSet(BookMarkExplorer.this.getRootFolderAt(index - 1));
            }

            public boolean isEnabled() {
                int index = BookMarkExplorer.this.getIndexOfRootFolder(BookMarkExplorer.this.fSelectedBookMarkSet);
                return index > 0 && BookMarkExplorer.this.fRootFolders.size() > 1;
            }
        };
        previousSet.setId(PREVIOUS_SET_ACTION);
        previousSet.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/backward.gif"));
        previousSet.setDisabledImageDescriptor(OwlUI.getImageDescriptor("icons/dtool16/backward.gif"));
        this.fToolBarManager.add((IAction)previousSet);
        Action nextSet = new Action(Messages.BookMarkExplorer_NEXT_SET){

            public void run() {
                int index = BookMarkExplorer.this.getIndexOfRootFolder(BookMarkExplorer.this.fSelectedBookMarkSet);
                BookMarkExplorer.this.changeSet(BookMarkExplorer.this.getRootFolderAt(index + 1));
            }

            public boolean isEnabled() {
                int index = BookMarkExplorer.this.getIndexOfRootFolder(BookMarkExplorer.this.fSelectedBookMarkSet);
                return index < BookMarkExplorer.this.fRootFolders.size() - 1 && BookMarkExplorer.this.fRootFolders.size() > 1;
            }
        };
        nextSet.setId(NEXT_SET_ACTION);
        nextSet.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/forward.gif"));
        nextSet.setDisabledImageDescriptor(OwlUI.getImageDescriptor("icons/dtool16/forward.gif"));
        this.fToolBarManager.add((IAction)nextSet);
        this.fToolBarManager.add((IContributionItem)new Separator("additions"));
    }

    private void doFilter(BookMarkFilter.Type type) {
        if (type != BookMarkFilter.Type.SHOW_ALL) {
            this.fLastFilterType = type;
        } else if (this.fBookMarkFilter.getType() != BookMarkFilter.Type.SHOW_ALL) {
            this.fLastFilterType = this.fBookMarkFilter.getType();
        }
        this.fBookMarkFilter.setType(type);
        this.fViewer.refresh(false);
        this.restoreExpandedElements();
        this.fToolBarManager.find(FILTER_ACTION).update("image");
    }

    private void doGrouping(BookMarkGrouping.Type type) {
        if (type != BookMarkGrouping.Type.NO_GROUPING) {
            this.fLastGroupType = type;
        } else if (this.fBookMarkGrouping.getType() != BookMarkGrouping.Type.NO_GROUPING) {
            this.fLastGroupType = this.fBookMarkGrouping.getType();
        }
        if (!this.fSortByName) {
            if (type.equals((Object)BookMarkGrouping.Type.NO_GROUPING)) {
                this.fBookMarkComparator.setType(BookMarkSorter.Type.DEFAULT_SORTING);
            } else if (type.equals((Object)BookMarkGrouping.Type.GROUP_BY_LAST_VISIT)) {
                this.fBookMarkComparator.setType(BookMarkSorter.Type.SORT_BY_LAST_VISIT_DATE);
            } else if (type.equals((Object)BookMarkGrouping.Type.GROUP_BY_POPULARITY)) {
                this.fBookMarkComparator.setType(BookMarkSorter.Type.SORT_BY_POPULARITY);
            }
        }
        this.fBookMarkGrouping.setType(type);
        this.fViewer.refresh(false);
        this.fBookMarkComparator.setType(this.fSortByName ? BookMarkSorter.Type.SORT_BY_NAME : BookMarkSorter.Type.DEFAULT_SORTING);
        this.restoreExpandedElements();
        this.fToolBarManager.find(GROUP_ACTION).update("image");
    }

    private void hookContextualMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MenuManager newMenu = new MenuManager(Messages.BookMarkExplorer_NEW);
                manager.add((IContributionItem)newMenu);
                Action newBookmarkAction = new Action(Messages.BookMarkExplorer_BOOKMARK){

                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)BookMarkExplorer.this.fViewer.getSelection();
                        IFolder parent = BookMarkExplorer.this.getParent(selection);
                        IMark position = (IMark)(selection.getFirstElement() instanceof IMark ? selection.getFirstElement() : null);
                        new NewBookMarkAction(BookMarkExplorer.this.fViewSite.getShell(), parent, position).run(null);
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return OwlUI.BOOKMARK;
                    }
                };
                newBookmarkAction.setId("org.rssowl.ui.actions.NewBookMark");
                newBookmarkAction.setActionDefinitionId("org.rssowl.ui.actions.NewBookMark");
                newMenu.add((IAction)newBookmarkAction);
                Action newNewsBinAction = new Action(Messages.BookMarkExplorer_NEWSBIN){

                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)BookMarkExplorer.this.fViewer.getSelection();
                        IFolder parent = BookMarkExplorer.this.getParent(selection);
                        IMark position = (IMark)(selection.getFirstElement() instanceof IMark ? selection.getFirstElement() : null);
                        new NewNewsBinAction(BookMarkExplorer.this.fViewSite.getShell(), parent, position).run(null);
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return OwlUI.NEWSBIN;
                    }
                };
                newNewsBinAction.setId("org.rssowl.ui.actions.NewNewsBin");
                newNewsBinAction.setActionDefinitionId("org.rssowl.ui.actions.NewNewsBin");
                newMenu.add((IAction)newNewsBinAction);
                Action newSavedSearchAction = new Action(Messages.BookMarkExplorer_SAVED_SEARCH){

                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)BookMarkExplorer.this.fViewer.getSelection();
                        IFolder parent = BookMarkExplorer.this.getParent(selection);
                        IMark position = (IMark)(selection.getFirstElement() instanceof IMark ? selection.getFirstElement() : null);
                        new NewSearchMarkAction(BookMarkExplorer.this.fViewSite.getShell(), parent, position).run(null);
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return OwlUI.SEARCHMARK;
                    }
                };
                newSavedSearchAction.setId("org.rssowl.ui.actions.NewSearchMark");
                newSavedSearchAction.setActionDefinitionId("org.rssowl.ui.actions.NewSearchMark");
                newMenu.add((IAction)newSavedSearchAction);
                newMenu.add((IContributionItem)new Separator());
                Action newFolderAction = new Action(Messages.BookMarkExplorer_FOLDER){

                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)BookMarkExplorer.this.fViewer.getSelection();
                        IFolder parent = BookMarkExplorer.this.getParent(selection);
                        IMark position = (IMark)(selection.getFirstElement() instanceof IMark ? selection.getFirstElement() : null);
                        new NewFolderAction(BookMarkExplorer.this.fViewSite.getShell(), parent, position).run(null);
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return OwlUI.FOLDER;
                    }
                };
                newFolderAction.setId("org.rssowl.ui.actions.NewFolder");
                newFolderAction.setActionDefinitionId("org.rssowl.ui.actions.NewFolder");
                newMenu.add((IAction)newFolderAction);
                manager.add((IContributionItem)new GroupMarker("new.ext"));
                final IStructuredSelection selection = (IStructuredSelection)BookMarkExplorer.this.fViewer.getSelection();
                IFolder selectedFolder = BookMarkExplorer.this.getFolder(selection);
                IPreferenceScope globalPreferences = Owl.getPreferenceService().getGlobalScope();
                IPreferenceScope eclipsePreferences = Owl.getPreferenceService().getEclipseScope();
                manager.add((IContributionItem)new Separator("open"));
                if (!selection.isEmpty()) {
                    if (!eclipsePreferences.getBoolean(DefaultPreferences.ECLIPSE_SINGLE_CLICK_OPEN)) {
                        manager.add((IAction)new OpenAction(BookMarkExplorer.this.fViewSite.getPage(), (ISelectionProvider)BookMarkExplorer.this.fViewer));
                    }
                    if (globalPreferences.getBoolean(DefaultPreferences.ALWAYS_REUSE_FEEDVIEW) && OwlUI.isTabbedBrowsingEnabled()) {
                        manager.add((IAction)new OpenInNewTabAction(BookMarkExplorer.this.fViewSite.getPage(), (ISelectionProvider)BookMarkExplorer.this.fViewer));
                        if (selectedFolder != null) {
                            manager.add((IAction)new OpenInNewTabAction(BookMarkExplorer.this.fViewSite.getPage(), selectedFolder));
                        }
                    }
                }
                manager.add((IContributionItem)new GroupMarker("open.ext"));
                manager.add((IContributionItem)new Separator("mark"));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new SearchInTypeAction(BookMarkExplorer.this.fViewSite.getWorkbenchWindow(), (ISelectionProvider)BookMarkExplorer.this.fViewer));
                manager.add((IContributionItem)new GroupMarker("find.ext"));
                if (BookMarkExplorer.this.getBookMark(selection) != null) {
                    manager.add((IContributionItem)new Separator("share"));
                    MenuManager shareMenu = new MenuManager(Messages.BookMarkExplorer_SHARING, OwlUI.SHARE, "sharebookmark");
                    manager.add((IContributionItem)shareMenu);
                    List<ShareProvider> providers = Controller.getDefault().getShareProviders();
                    for (final ShareProvider provider : providers) {
                        if (!provider.isEnabled()) continue;
                        shareMenu.add((IAction)new Action(provider.getName()){

                            public void run() {
                                if ("org.rssowl.ui.SendLinkAction".equals(provider.getId())) {
                                    SendLinkAction action = new SendLinkAction();
                                    action.selectionChanged(null, (ISelection)selection);
                                    action.run(null);
                                } else {
                                    IBookMark bookmark = BookMarkExplorer.this.getBookMark(selection);
                                    if (bookmark != null) {
                                        String shareLink = provider.toShareUrl(bookmark);
                                        new OpenInBrowserAction((IStructuredSelection)new StructuredSelection((Object)shareLink)).run();
                                    }
                                }
                            }

                            public ImageDescriptor getImageDescriptor() {
                                if (StringUtils.isSet((String)provider.getIconPath())) {
                                    return OwlUI.getImageDescriptor(provider.getPluginId(), provider.getIconPath());
                                }
                                return super.getImageDescriptor();
                            }

                            public boolean isEnabled() {
                                return !selection.isEmpty();
                            }

                            public String getActionDefinitionId() {
                                return "org.rssowl.ui.SendLinkAction".equals(provider.getId()) ? "org.rssowl.ui.SendLinkAction" : super.getActionDefinitionId();
                            }

                            public String getId() {
                                return "org.rssowl.ui.SendLinkAction".equals(provider.getId()) ? "org.rssowl.ui.SendLinkAction" : super.getId();
                            }
                        });
                    }
                    shareMenu.add((IContributionItem)new Separator());
                    shareMenu.add((IAction)new Action(Messages.BookMarkExplorer_CONFIGURE){

                        public void run() {
                            PreferencesUtil.createPreferenceDialogOn((Shell)BookMarkExplorer.this.fViewer.getTree().getShell(), (String)"org.rssowl.ui.SharingPreferencesPage", null, null).open();
                        }
                    });
                }
                manager.add((IContributionItem)new Separator("copy"));
                manager.add((IContributionItem)new GroupMarker("edit"));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = manager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.fViewSite.registerContextMenu(manager, (ISelectionProvider)this.fViewer);
    }

    private IBookMark getBookMark(IStructuredSelection selection) {
        List list = selection.toList();
        for (Object object : list) {
            if (!(object instanceof IBookMark)) continue;
            return (IBookMark)object;
        }
        return null;
    }

    private IFolder getFolder(IStructuredSelection selection) {
        Object firstElement;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IFolder) {
            return (IFolder)firstElement;
        }
        return null;
    }

    private void registerListeners() {
        this.fFolderListener = new FolderAdapter(){

            public void entitiesAdded(final Set<FolderEvent> events) {
                JobRunner.runInUIThread((Widget)BookMarkExplorer.this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        for (FolderEvent event : events) {
                            if (event.getEntity().getParent() != null) continue;
                            BookMarkExplorer.this.fRootFolders.add(event.getEntity());
                            BookMarkExplorer.this.changeSet(event.getEntity());
                        }
                    }
                });
            }

            public void entitiesDeleted(final Set<FolderEvent> events) {
                JobRunner.runInUIThread((Widget)BookMarkExplorer.this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        for (FolderEvent event : events) {
                            IFolder deletedFolder = event.getEntity();
                            IFolder parentFolder = event.getEntity().getParent();
                            if (parentFolder != null) continue;
                            int index = BookMarkExplorer.this.getIndexOfRootFolder(deletedFolder);
                            BookMarkExplorer.this.fRootFolders.remove(event.getEntity());
                            if (BookMarkExplorer.this.fSelectedBookMarkSet.equals(deletedFolder)) {
                                if (BookMarkExplorer.this.fRootFolders.size() > index) {
                                    BookMarkExplorer.this.changeSet(BookMarkExplorer.this.getRootFolderAt(index));
                                    continue;
                                }
                                BookMarkExplorer.this.changeSet(BookMarkExplorer.this.getRootFolderAt(index - 1));
                                continue;
                            }
                            BookMarkExplorer.this.fViewSite.getActionBars().getToolBarManager().find(BookMarkExplorer.PREVIOUS_SET_ACTION).update("enabled");
                            BookMarkExplorer.this.fViewSite.getActionBars().getToolBarManager().find(BookMarkExplorer.NEXT_SET_ACTION).update("enabled");
                        }
                    }
                });
            }
        };
        DynamicDAO.addEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
        this.fPartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (ref.getPart(true) instanceof IEditorPart) {
                    JobRunner.runInUIThread(50, (Widget)BookMarkExplorer.this.fViewer.getTree(), new Runnable(){

                        public void run() {
                            BookMarkExplorer.this.editorActivated(BookMarkExplorer.this.fViewSite.getPage().getActiveEditor());
                        }
                    });
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
                if (ref.getPart(true) == BookMarkExplorer.this) {
                    BookMarkExplorer.this.editorActivated(BookMarkExplorer.this.fViewSite.getPage().getActiveEditor());
                }
            }

            public void partOpened(IWorkbenchPartReference ref) {
                if (ref.getPart(true) == BookMarkExplorer.this) {
                    BookMarkExplorer.this.editorActivated(BookMarkExplorer.this.fViewSite.getPage().getActiveEditor());
                }
            }

            public void partVisible(IWorkbenchPartReference ref) {
                if (ref.getPart(true) == BookMarkExplorer.this) {
                    BookMarkExplorer.this.editorActivated(BookMarkExplorer.this.fViewSite.getPage().getActiveEditor());
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partHidden(IWorkbenchPartReference ref) {
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
                if (ref.getPart(true) instanceof IEditorPart) {
                    JobRunner.runInUIThread(50, (Widget)BookMarkExplorer.this.fViewer.getTree(), new Runnable(){

                        public void run() {
                            BookMarkExplorer.this.editorActivated(BookMarkExplorer.this.fViewSite.getPage().getActiveEditor());
                        }
                    });
                }
            }
        };
        this.fViewSite.getPage().addPartListener(this.fPartListener);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (BookMarkExplorer.this.fViewer.getControl().isDisposed()) {
                    return;
                }
                if ("org.rssowl.ui.StickyBGColor".equals(event.getProperty())) {
                    BookMarkExplorer.this.fLabelProvider.updateResources();
                    BookMarkExplorer.this.fViewer.refresh(true);
                }
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    private void unregisterListeners() {
        DynamicDAO.removeEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
        this.fViewSite.getPage().removePartListener(this.fPartListener);
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    private void hookGlobalActions() {
        this.fViewSite.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action(){

            public void run() {
                Control focusControl = BookMarkExplorer.this.fViewer.getControl().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).selectAll();
                } else {
                    ((Tree)BookMarkExplorer.this.fViewer.getControl()).selectAll();
                    BookMarkExplorer.this.fViewer.setSelection(BookMarkExplorer.this.fViewer.getSelection());
                }
            }
        });
        this.fViewSite.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new Action(){

            public void run() {
                BookMarkExplorer.this.fViewer.getControl().getParent().setRedraw(false);
                try {
                    new DeleteTypesAction(BookMarkExplorer.this.fViewer.getControl().getShell(), (IStructuredSelection)BookMarkExplorer.this.fViewer.getSelection()).run();
                }
                finally {
                    BookMarkExplorer.this.fViewer.getControl().getParent().setRedraw(true);
                }
            }
        });
        this.fViewSite.getActionBars().setGlobalActionHandler("org.rssowl.ui.actions.Reload", (IAction)new Action(){

            public void run() {
                new ReloadTypesAction((IStructuredSelection)BookMarkExplorer.this.fViewer.getSelection(), BookMarkExplorer.this.fViewSite.getShell()).run();
            }
        });
        this.fViewSite.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)new Action(){

            public void run() {
                Control focusControl = BookMarkExplorer.this.fViewer.getControl().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).cut();
                }
            }
        });
        this.fViewSite.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(){

            public void run() {
                Control focusControl = BookMarkExplorer.this.fViewer.getControl().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).copy();
                }
            }
        });
        this.fViewSite.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)new Action(){

            public void run() {
                Control focusControl = BookMarkExplorer.this.fViewer.getControl().getDisplay().getFocusControl();
                if (focusControl instanceof Text) {
                    ((Text)focusControl).paste();
                }
            }
        });
        this.fViewSite.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)new Action(){

            public void run() {
                UndoStack.getInstance().undo();
            }
        });
        this.fViewSite.getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)new Action(){

            public void run() {
                UndoStack.getInstance().redo();
            }
        });
        this.fViewSite.getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)new FindAction());
        this.fViewSite.getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)new EntityPropertyDialogAction((IShellProvider)this.fViewSite, (ISelectionProvider)this.fViewer));
        this.fViewSite.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(false);
        this.fViewSite.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(false);
        this.fViewSite.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(false);
    }

    public void find() {
        this.setSearchBarVisible(true);
        this.fSearchBar.getControl().setFocus();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.fViewSite = site;
        this.fGlobalPreferences = Owl.getPreferenceService().getGlobalScope();
        this.fPrefDAO = (IPreferenceDAO)DynamicDAO.getDAO(IPreferenceDAO.class);
        this.fExpandedNodes = new ArrayList<Long>();
        this.fRootFolders = CoreUtils.loadRootFolders();
        this.loadState();
    }

    public Object getAdapter(Class adapter) {
        if (ISelectionProvider.class.equals((Object)adapter)) {
            return this.fViewer;
        }
        if (IInputProvider.class.equals((Object)adapter)) {
            return this.fViewer.getInput();
        }
        return super.getAdapter(adapter);
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.unregisterListeners();
        this.saveState();
    }

    public boolean navigate(boolean next, boolean unread, boolean performOnFeedView) {
        Tree explorerTree = this.fViewer.getTree();
        if (explorerTree.isDisposed()) {
            return false;
        }
        ITreeNode targetNode = null;
        targetNode = this.navigateInTree(explorerTree, next, unread);
        if (targetNode == null) {
            targetNode = this.navigateInSets(next, unread);
        }
        if (targetNode == null && next) {
            WidgetTreeNode startingNode = new WidgetTreeNode(this.fViewer.getTree(), this.fViewer);
            targetNode = this.navigate(startingNode, next, unread);
        }
        if (targetNode != null) {
            this.performNavigation(targetNode, performOnFeedView, unread);
            return true;
        }
        return false;
    }

    private void performNavigation(ITreeNode targetNode, boolean performOnFeedView, boolean unread) {
        INewsMark mark = (INewsMark)targetNode.getData();
        StructuredSelection selection = new StructuredSelection((Object)mark);
        this.fViewer.setSelection((ISelection)selection);
        PerformAfterInputSet perform = null;
        if (performOnFeedView && unread) {
            perform = PerformAfterInputSet.SELECT_UNREAD_NEWS;
        } else if (performOnFeedView) {
            perform = PerformAfterInputSet.SELECT_FIRST_NEWS;
        }
        OwlUI.openInFeedView(this.fViewSite.getPage(), (IStructuredSelection)selection, true, false, perform);
    }

    private ITreeNode navigateInTree(Tree tree, boolean next, boolean unread) {
        WidgetTreeNode startingNode;
        ITreeNode resultingNode = null;
        if (tree.getSelectionCount() > 0 ? (resultingNode = this.navigate(startingNode = new WidgetTreeNode(tree.getSelection()[0], this.fViewer), next, unread)) != null : (resultingNode = this.navigate(startingNode = new WidgetTreeNode(tree, this.fViewer), next, unread)) != null) {
            return resultingNode;
        }
        return resultingNode;
    }

    private ITreeNode navigateInSets(boolean next, boolean unread) {
        ITreeNode targetNode = null;
        int index = this.getIndexOfRootFolder(this.fSelectedBookMarkSet);
        if (next) {
            int i = index + 1;
            while (i < this.fRootFolders.size()) {
                targetNode = this.navigateInSet(this.getRootFolderAt(i), true, unread);
                if (targetNode != null) {
                    return targetNode;
                }
                ++i;
            }
            i = 0;
            while (i < index) {
                targetNode = this.navigateInSet(this.getRootFolderAt(i), true, unread);
                if (targetNode != null) {
                    return targetNode;
                }
                ++i;
            }
        } else {
            int i = index - 1;
            while (i >= 0) {
                targetNode = this.navigateInSet(this.getRootFolderAt(i), true, unread);
                if (targetNode != null) {
                    return targetNode;
                }
                --i;
            }
            i = this.fRootFolders.size() - 1;
            while (i > index) {
                targetNode = this.navigateInSet(this.getRootFolderAt(i), true, unread);
                if (targetNode != null) {
                    return targetNode;
                }
                --i;
            }
        }
        return targetNode;
    }

    private ITreeNode navigateInSet(IFolder set, boolean next, boolean unread) {
        ModelTreeNode node = new ModelTreeNode(set);
        ITreeNode targetNode = this.navigate((ITreeNode)node, next, unread);
        if (targetNode != null) {
            this.changeSet(set);
            return targetNode;
        }
        return null;
    }

    private ITreeNode navigate(ITreeNode startingNode, boolean next, final boolean unread) {
        TreeTraversal traverse = new TreeTraversal(startingNode){

            public boolean select(ITreeNode node) {
                return BookMarkExplorer.this.isValidNavigation(node, unread);
            }
        };
        ITreeNode targetNode = next ? traverse.nextNode() : traverse.previousNode();
        return targetNode;
    }

    private boolean isValidNavigation(ITreeNode node, boolean unread) {
        Object data = node.getData();
        if (data instanceof INewsMark) {
            INewsMark newsmark = (INewsMark)data;
            if (unread && newsmark.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED)) == 0) {
                return false;
            }
        } else if (data instanceof IFolder || data instanceof EntityGroup) {
            return false;
        }
        return true;
    }

    public void saveState() {
        this.saveExpandedElements();
        if (this.fLastSelection != null && !this.fLastSelection.isEmpty()) {
            Object element = this.fLastSelection.getFirstElement();
            if (element instanceof IFolderChild) {
                this.fGlobalPreferences.putLong(PREF_SELECTED_FOLDER_CHILD, ((IFolderChild)element).getId().longValue());
            } else {
                this.fGlobalPreferences.delete(PREF_SELECTED_FOLDER_CHILD);
            }
        } else {
            this.fGlobalPreferences.delete(PREF_SELECTED_FOLDER_CHILD);
        }
        if (!this.fBlockSaveState) {
            this.fGlobalPreferences.putBoolean(DefaultPreferences.BE_BEGIN_SEARCH_ON_TYPING, this.fBeginSearchOnTyping);
            this.fGlobalPreferences.putBoolean(DefaultPreferences.BE_ALWAYS_SHOW_SEARCH, this.fAlwaysShowSearch);
            this.fGlobalPreferences.putBoolean(DefaultPreferences.BE_SORT_BY_NAME, this.fSortByName);
            this.fGlobalPreferences.putBoolean(DefaultPreferences.BE_ENABLE_LINKING, this.fLinkingEnabled);
            this.fGlobalPreferences.putBoolean(DefaultPreferences.BE_DISABLE_FAVICONS, !this.fFaviconsEnabled);
            this.fGlobalPreferences.putInteger(DefaultPreferences.BE_FILTER_TYPE, this.fBookMarkFilter.getType().ordinal());
            this.fGlobalPreferences.putInteger(DefaultPreferences.BE_GROUP_TYPE, this.fBookMarkGrouping.getType().ordinal());
        }
    }

    private void saveExpandedElements() {
        int i = 0;
        long[] elements = new long[this.fExpandedNodes.size()];
        for (Long element : this.fExpandedNodes) {
            elements[i] = element;
            ++i;
        }
        String key = PREF_EXPANDED_NODES + this.fSelectedBookMarkSet.getId();
        IPreference pref = this.fPrefDAO.loadOrCreate(key);
        pref.putLongs(elements);
        this.fPrefDAO.save((IPersistable)pref);
    }

    private void loadState() {
        this.fBeginSearchOnTyping = this.fGlobalPreferences.getBoolean(DefaultPreferences.BE_BEGIN_SEARCH_ON_TYPING);
        this.fAlwaysShowSearch = this.fGlobalPreferences.getBoolean(DefaultPreferences.BE_ALWAYS_SHOW_SEARCH);
        this.fSortByName = this.fGlobalPreferences.getBoolean(DefaultPreferences.BE_SORT_BY_NAME);
        this.fLinkingEnabled = this.fGlobalPreferences.getBoolean(DefaultPreferences.BE_ENABLE_LINKING);
        this.fFaviconsEnabled = !this.fGlobalPreferences.getBoolean(DefaultPreferences.BE_DISABLE_FAVICONS);
        this.fFilterType = BookMarkFilter.Type.values()[this.fGlobalPreferences.getInteger(DefaultPreferences.BE_FILTER_TYPE)];
        this.fGroupingType = BookMarkGrouping.Type.values()[this.fGlobalPreferences.getInteger(DefaultPreferences.BE_GROUP_TYPE)];
        String selectedBookMarkSetPref = BookMarkExplorer.getSelectedBookMarkSetPref(this.fViewSite.getWorkbenchWindow());
        IPreference pref = this.fPrefDAO.load(selectedBookMarkSetPref);
        Assert.isTrue((this.fRootFolders.size() > 0 ? 1 : 0) != 0, (String)Messages.BookMarkExplorer_ERROR_NO_SET_FOUND);
        if (pref != null) {
            this.fSelectedBookMarkSet = new FolderReference(pref.getLong().longValue()).resolve();
        } else {
            this.fSelectedBookMarkSet = this.getRootFolderAt(0);
            pref = Owl.getModelFactory().createPreference(selectedBookMarkSetPref);
            pref.putLongs(new long[]{this.fSelectedBookMarkSet.getId()});
            this.fPrefDAO.save((IPersistable)pref);
        }
        this.loadExpandedElements();
        this.fLastSelectedFolderChild = this.fGlobalPreferences.getLong(PREF_SELECTED_FOLDER_CHILD);
    }

    private void loadExpandedElements() {
        IPreference pref = this.fPrefDAO.load(PREF_EXPANDED_NODES + this.fSelectedBookMarkSet.getId());
        if (pref != null) {
            long[] lArray = pref.getLongs();
            int n = lArray.length;
            int n2 = 0;
            while (n2 < n) {
                long element = lArray[n2];
                this.fExpandedNodes.add(element);
                ++n2;
            }
        }
    }

    void restoreExpandedElements() {
        for (Long expandedNodeId : this.fExpandedNodes) {
            if (this.fBookMarkGrouping.getType() == BookMarkGrouping.Type.NO_GROUPING) {
                this.fViewer.setExpandedState((Object)new FolderReference(expandedNodeId.longValue()), true);
                continue;
            }
            this.fViewer.setExpandedState((Object)new EntityGroup(expandedNodeId, "org.rssowl.ui.internal.views.explorer.BookMarkGrouping"), true);
        }
    }

    private IFolder getParent(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            Object obj = selection.getFirstElement();
            if (obj instanceof IFolder) {
                return (IFolder)obj;
            }
            if (obj instanceof IMark) {
                return ((IMark)obj).getParent();
            }
        }
        return this.fSelectedBookMarkSet;
    }

    private IFolder getRootFolderAt(int index) {
        int i = 0;
        for (IFolder rootFolder : this.fRootFolders) {
            if (i == index) {
                return rootFolder;
            }
            ++i;
        }
        return null;
    }

    private int getIndexOfRootFolder(IFolder folder) {
        int i = 0;
        for (IFolder rootFolder : this.fRootFolders) {
            if (rootFolder.equals(folder)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean isGroupingEnabled() {
        return this.fBookMarkGrouping.isActive();
    }

    public boolean isSortByNameEnabled() {
        return this.fBookMarkComparator.getType() == BookMarkSorter.Type.SORT_BY_NAME;
    }

    public void saveStateOnDispose(boolean saveStateOnDispose) {
        this.fBlockSaveState = !saveStateOnDispose;
    }
}

