/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.views.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.util.DateUtils;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.EntityGroupItem;
import org.rssowl.ui.internal.views.explorer.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookMarkGrouping {
    private static final long DAY = 86400000L;
    private static final long WEEK = 604800000L;
    private static final float VERY_POPULAR_RATIO = 0.8f;
    private static final float POPULAR_RATIO = 0.5f;
    private static final float FAIRLY_POPULAR_RATIO = 0.2f;
    static final String GROUP_CATEGORY_ID = "org.rssowl.ui.internal.views.explorer.BookMarkGrouping";
    private Type fType = Type.NO_GROUPING;

    Type getType() {
        return this.fType;
    }

    public void setType(Type type) {
        this.fType = type;
    }

    public EntityGroup[] group(List<? extends IEntity> input) {
        Assert.isTrue((this.fType != Type.NO_GROUPING ? 1 : 0) != 0, (String)"Grouping is not enabled!");
        if (Type.GROUP_BY_LAST_VISIT == this.fType) {
            return this.createLastVisitDateGroups(input);
        }
        if (Type.GROUP_BY_POPULARITY == this.fType) {
            return this.createPopularityGroups(input);
        }
        if (Type.GROUP_BY_STATE == this.fType) {
            return this.createStateGroups(input);
        }
        if (Type.GROUP_BY_TYPE == this.fType) {
            return this.createTypeGroups(input);
        }
        return new EntityGroup[0];
    }

    private EntityGroup[] createLastVisitDateGroups(List<? extends IEntity> input) {
        Calendar today = DateUtils.getToday();
        long todayMillis = today.getTimeInMillis();
        Date yesterday = new Date(todayMillis - 86400000L);
        today.set(7, today.getFirstDayOfWeek());
        Date earlierThisWeek = today.getTime();
        Date lastWeek = new Date(earlierThisWeek.getTime() - 604800000L);
        EntityGroup gToday = new EntityGroup(Group.TODAY.ordinal(), GROUP_CATEGORY_ID, Group.TODAY.getName());
        EntityGroup gYesterday = new EntityGroup(Group.YESTERDAY.ordinal(), GROUP_CATEGORY_ID, Group.YESTERDAY.getName());
        EntityGroup gEarlierThisWeek = new EntityGroup(Group.EARLIER_THIS_WEEK.ordinal(), GROUP_CATEGORY_ID, Group.EARLIER_THIS_WEEK.getName());
        EntityGroup gLastWeek = new EntityGroup(Group.LAST_WEEK.ordinal(), GROUP_CATEGORY_ID, Group.LAST_WEEK.getName());
        EntityGroup gOlder = new EntityGroup(Group.OLDER.ordinal(), GROUP_CATEGORY_ID, Group.OLDER.getName());
        EntityGroup gNever = new EntityGroup(Group.NEVER.ordinal(), GROUP_CATEGORY_ID, Group.NEVER.getName());
        for (IEntity iEntity : input) {
            if (!(iEntity instanceof IMark)) continue;
            IMark mark = (IMark)iEntity;
            Date lastVisitDate = mark.getLastVisitDate();
            if (lastVisitDate == null) {
                new EntityGroupItem(gNever, (IEntity)mark);
                continue;
            }
            if (lastVisitDate.getTime() >= todayMillis) {
                new EntityGroupItem(gToday, (IEntity)mark);
                continue;
            }
            if (lastVisitDate.compareTo(yesterday) >= 0) {
                new EntityGroupItem(gYesterday, (IEntity)mark);
                continue;
            }
            if (lastVisitDate.compareTo(earlierThisWeek) >= 0) {
                new EntityGroupItem(gEarlierThisWeek, (IEntity)mark);
                continue;
            }
            if (lastVisitDate.compareTo(lastWeek) >= 0) {
                new EntityGroupItem(gLastWeek, (IEntity)mark);
                continue;
            }
            new EntityGroupItem(gOlder, (IEntity)mark);
        }
        return this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(gNever, gToday, gYesterday, gEarlierThisWeek, gLastWeek, gOlder)));
    }

    private EntityGroup[] createPopularityGroups(List<? extends IEntity> input) {
        IMark bookmark;
        EntityGroup gVeryPopular = new EntityGroup(Group.VERY_POPULAR.ordinal(), GROUP_CATEGORY_ID, Group.VERY_POPULAR.getName());
        EntityGroup gPopular = new EntityGroup(Group.POPULAR.ordinal(), GROUP_CATEGORY_ID, Group.POPULAR.getName());
        EntityGroup gFairlyPopular = new EntityGroup(Group.FAIRLY_POPULAR.ordinal(), GROUP_CATEGORY_ID, Group.FAIRLY_POPULAR.getName());
        EntityGroup gUnpopular = new EntityGroup(Group.UNPOPULAR.ordinal(), GROUP_CATEGORY_ID, Group.UNPOPULAR.getName());
        float maxPopularity = -1.0f;
        for (IEntity iEntity : input) {
            if (!(iEntity instanceof IMark)) continue;
            bookmark = (IMark)iEntity;
            maxPopularity = Math.max(maxPopularity, (float)bookmark.getPopularity());
        }
        for (IEntity iEntity : input) {
            float ratio;
            if (!(iEntity instanceof IMark)) continue;
            bookmark = (IMark)iEntity;
            float popularity = bookmark.getPopularity();
            float f = ratio = maxPopularity > 0.0f ? popularity / maxPopularity : 0.0f;
            if (ratio >= 0.8f) {
                new EntityGroupItem(gVeryPopular, (IEntity)bookmark);
                continue;
            }
            if (ratio >= 0.5f) {
                new EntityGroupItem(gPopular, (IEntity)bookmark);
                continue;
            }
            if (ratio >= 0.2f) {
                new EntityGroupItem(gFairlyPopular, (IEntity)bookmark);
                continue;
            }
            new EntityGroupItem(gUnpopular, (IEntity)bookmark);
        }
        return this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(gVeryPopular, gPopular, gFairlyPopular, gUnpopular)));
    }

    private EntityGroup[] createTypeGroups(List<? extends IEntity> input) {
        EntityGroup gBins = new EntityGroup(Group.BIN.ordinal(), GROUP_CATEGORY_ID, Group.BIN.getName());
        EntityGroup gSearches = new EntityGroup(Group.SEARCH.ordinal(), GROUP_CATEGORY_ID, Group.SEARCH.getName());
        EntityGroup gBookmarks = new EntityGroup(Group.BOOKMARK.ordinal(), GROUP_CATEGORY_ID, Group.BOOKMARK.getName());
        for (IEntity iEntity : input) {
            if (iEntity instanceof IBookMark) {
                new EntityGroupItem(gBookmarks, iEntity);
                continue;
            }
            if (iEntity instanceof INewsBin) {
                new EntityGroupItem(gBins, iEntity);
                continue;
            }
            if (!(iEntity instanceof ISearchMark)) continue;
            new EntityGroupItem(gSearches, iEntity);
        }
        return this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(gBins, gSearches, gBookmarks)));
    }

    private EntityGroup[] createStateGroups(List<? extends IEntity> input) {
        EntityGroup gSticky = new EntityGroup(Group.STICKY.ordinal(), GROUP_CATEGORY_ID, Group.STICKY.getName());
        EntityGroup gNew = new EntityGroup(Group.NEW.ordinal(), GROUP_CATEGORY_ID, Group.NEW.getName());
        EntityGroup gUnread = new EntityGroup(Group.UNREAD.ordinal(), GROUP_CATEGORY_ID, Group.UNREAD.getName());
        EntityGroup gOther = new EntityGroup(Group.OTHER.ordinal(), GROUP_CATEGORY_ID, Group.OTHER.getName());
        for (IEntity iEntity : input) {
            if (!(iEntity instanceof INewsMark)) continue;
            INewsMark mark = (INewsMark)iEntity;
            if (mark instanceof ISearchMark) {
                new EntityGroupItem(gOther, (IEntity)mark);
                continue;
            }
            if (mark instanceof IBookMark && ((IBookMark)mark).getStickyNewsCount() > 0) {
                new EntityGroupItem(gSticky, (IEntity)mark);
                continue;
            }
            if (mark.getNewsCount(EnumSet.of(INews.State.NEW)) > 0) {
                new EntityGroupItem(gNew, (IEntity)mark);
                continue;
            }
            if (mark.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED)) > 0) {
                new EntityGroupItem(gUnread, (IEntity)mark);
                continue;
            }
            new EntityGroupItem(gOther, (IEntity)mark);
        }
        return this.maskEmpty(new ArrayList<EntityGroup>(Arrays.asList(gSticky, gNew, gUnread, gOther)));
    }

    private EntityGroup[] maskEmpty(List<EntityGroup> items) {
        ArrayList<EntityGroup> maskedItems = new ArrayList<EntityGroup>();
        for (EntityGroup item : items) {
            if (item.size() <= 0) continue;
            maskedItems.add(item);
        }
        return maskedItems.toArray(new EntityGroup[maskedItems.size()]);
    }

    boolean needsRefresh(Class<? extends IEntity> entityClass) {
        if (this.fType == Type.NO_GROUPING) {
            return false;
        }
        if (entityClass.equals(INews.class)) {
            return this.fType == Type.GROUP_BY_STATE;
        }
        if (entityClass.equals(IFolder.class)) {
            return true;
        }
        if (IBookMark.class.isAssignableFrom(entityClass)) {
            return true;
        }
        if (ISearchMark.class.isAssignableFrom(entityClass)) {
            return true;
        }
        return INewsBin.class.isAssignableFrom(entityClass);
    }

    boolean isActive() {
        return this.fType != Type.NO_GROUPING;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Group {
        TODAY(Messages.BookMarkGrouping_TODAY),
        YESTERDAY(Messages.BookMarkGrouping_YESTERDAY),
        EARLIER_THIS_WEEK(Messages.BookMarkGrouping_EARLIER_WEEK),
        LAST_WEEK(Messages.BookMarkGrouping_LAST_WEEK),
        OLDER(Messages.BookMarkGrouping_MORE_THAN_WEEK),
        NEVER(Messages.BookMarkGrouping_NEVER),
        VERY_POPULAR(Messages.BookMarkGrouping_VERY_POPULAR),
        POPULAR(Messages.BookMarkGrouping_POPULAR),
        FAIRLY_POPULAR(Messages.BookMarkGrouping_FAILRY_POPULAR),
        UNPOPULAR(Messages.BookMarkGrouping_UNPOPULAR),
        BIN(Messages.BookMarkGrouping_NEWS_BINS),
        SEARCH(Messages.BookMarkGrouping_SAVED_SEARCHES),
        BOOKMARK(Messages.BookMarkGrouping_BOOKMARKS),
        STICKY(Messages.BookMarkGrouping_STICKY),
        NEW(Messages.BookMarkGrouping_NEW),
        UNREAD(Messages.BookMarkGrouping_UNREAD),
        OTHER(Messages.BookMarkGrouping_OTHER);

        String fName;

        private Group(String name) {
            this.fName = name;
        }

        String getName() {
            return this.fName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NO_GROUPING,
        GROUP_BY_LAST_VISIT,
        GROUP_BY_POPULARITY,
        GROUP_BY_TYPE,
        GROUP_BY_STATE;

    }
}

