/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.config.Configuration;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.ext.MemoryFile;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.network.NetworkSocket;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.InMemoryObjectContainer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerFactory;
import com.db4o.internal.Platform4;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.ObjectServerImpl;
import com.db4o.reflect.Reflector;
import java.io.IOException;

public class Db4o {
    static final Config4Impl i_config = new Config4Impl();

    public static void main(String[] stringArray) {
        System.out.println(Db4o.version());
    }

    public static Configuration configure() {
        return i_config;
    }

    public static Configuration newConfiguration() {
        Config4Impl config4Impl = new Config4Impl();
        Platform4.getDefaultConfiguration(config4Impl);
        return config4Impl;
    }

    public static Configuration cloneConfiguration() {
        return (Config4Impl)((DeepClone)((Object)Db4o.configure())).deepClone(null);
    }

    public static ObjectContainer openClient(String string, int n, String string2, String string3) throws IOException {
        return Db4o.openClient(Db4o.cloneConfiguration(), string, n, string2, string3);
    }

    public static ObjectContainer openClient(Configuration configuration, String string, int n, String string2, String string3) throws IOException {
        return new ClientObjectContainer(configuration, new NetworkSocket(string, n), string2, string3, true);
    }

    public static final ObjectContainer openFile(String string) throws DatabaseFileLockedException {
        return Db4o.openFile(Db4o.cloneConfiguration(), string);
    }

    public static final ObjectContainer openFile(Configuration configuration, String string) throws DatabaseFileLockedException {
        return ObjectContainerFactory.openObjectContainer(configuration, string);
    }

    protected static final ObjectContainer openMemoryFile1(Configuration configuration, MemoryFile memoryFile) {
        if (memoryFile == null) {
            memoryFile = new MemoryFile();
        }
        InMemoryObjectContainer inMemoryObjectContainer = null;
        try {
            inMemoryObjectContainer = new InMemoryObjectContainer(configuration, memoryFile);
        }
        catch (Throwable throwable) {
            Messages.logErr(i_config, 4, "Memory File", throwable);
            return null;
        }
        Platform4.postOpen(inMemoryObjectContainer);
        Messages.logMsg(i_config, 5, "Memory File");
        return inMemoryObjectContainer;
    }

    public static final ObjectServer openServer(String string, int n) throws DatabaseFileLockedException {
        return Db4o.openServer(Db4o.cloneConfiguration(), string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ObjectServer openServer(Configuration configuration, String string, int n) throws DatabaseFileLockedException {
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)Db4o.openFile(configuration, string);
        if (localObjectContainer == null) {
            return null;
        }
        Object object = localObjectContainer.lock();
        synchronized (object) {
            return new ObjectServerImpl(localObjectContainer, n);
        }
    }

    static Reflector reflector() {
        return i_config.reflector();
    }

    public static final String version() {
        return "db4o 6.1.501";
    }

    static {
        Platform4.getDefaultConfiguration(i_config);
    }
}

