/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.CorruptionException;
import com.db4o.config.ObjectMarshaller;
import com.db4o.config.ObjectTranslator;
import com.db4o.ext.StoredField;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.No4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Comparable4;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Field;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.btree.FieldIndexKeyHandler;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.handlers.ArrayHandler;
import com.db4o.internal.handlers.MultidimensionalArrayHandler;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.ix.Indexable4;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.query.processor.QField;
import com.db4o.internal.slots.Slot;
import com.db4o.reflect.ReflectArray;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericReflector;

public class FieldMetadata
implements StoredField {
    private ClassMetadata _clazz;
    private int i_arrayPosition;
    protected String i_name;
    private boolean i_isArray;
    private boolean i_isNArray;
    private boolean i_isPrimitive;
    private ReflectField i_javaField;
    TypeHandler4 i_handler;
    private int i_handlerID;
    private int i_state;
    private static final int NOT_LOADED = 0;
    private static final int UNAVAILABLE = -1;
    private static final int AVAILABLE = 1;
    private Config4Field i_config;
    private Db4oTypeImpl i_db4oType;
    private BTree _index;
    static final FieldMetadata[] EMPTY_ARRAY = new FieldMetadata[0];
    private boolean _initialized = false;

    public FieldMetadata(ClassMetadata classMetadata) {
        this._clazz = classMetadata;
    }

    FieldMetadata(ClassMetadata classMetadata, ObjectTranslator objectTranslator) {
        this(classMetadata);
        this.init(classMetadata, objectTranslator.getClass().getName());
        this.i_state = 1;
        ObjectContainerBase objectContainerBase = this.getStream();
        this.i_handler = objectContainerBase.i_handlers.handlerForClass(objectContainerBase, objectContainerBase.reflector().forClass(objectTranslator.storedClass()));
    }

    FieldMetadata(ClassMetadata classMetadata, ObjectMarshaller objectMarshaller) {
        this(classMetadata);
        this.init(classMetadata, objectMarshaller.getClass().getName());
        this.i_state = 1;
        this.i_handler = this.getStream().i_handlers.untypedHandler();
    }

    FieldMetadata(ClassMetadata classMetadata, ReflectField reflectField, TypeHandler4 typeHandler4) {
        this(classMetadata);
        this.init(classMetadata, reflectField.getName());
        this.i_javaField = reflectField;
        this.i_javaField.setAccessible();
        this.i_handler = typeHandler4;
        boolean bl = false;
        if (reflectField instanceof GenericField) {
            bl = ((GenericField)reflectField).isPrimitive();
        }
        this.configure(reflectField.getFieldType(), bl);
        this.checkDb4oType();
        this.i_state = 1;
    }

    public void addFieldIndex(MarshallerFamily marshallerFamily, ClassMetadata classMetadata, StatefulBuffer statefulBuffer, Slot slot) {
        if (!this.hasIndex()) {
            statefulBuffer.incrementOffset(this.linkLength());
            return;
        }
        this.addIndexEntry(statefulBuffer, this.readIndexEntry(marshallerFamily, statefulBuffer));
    }

    protected void addIndexEntry(StatefulBuffer statefulBuffer, Object object) {
        this.addIndexEntry(statefulBuffer.getTransaction(), statefulBuffer.getID(), object);
    }

    public void addIndexEntry(Transaction transaction, int n, Object object) {
        if (!this.hasIndex()) {
            return;
        }
        BTree bTree = this.getIndex(transaction);
        if (bTree == null) {
            return;
        }
        bTree.add(transaction, this.createFieldIndexKey(n, object));
    }

    private FieldIndexKey createFieldIndexKey(int n, Object object) {
        Object object2 = this.indexEntryFor(object);
        return new FieldIndexKey(n, object2);
    }

    protected Object indexEntryFor(Object object) {
        return this.i_javaField.indexEntry(object);
    }

    public boolean canUseNullBitmap() {
        return true;
    }

    public Object readIndexEntry(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) {
        try {
            return this.i_handler.readIndexEntry(marshallerFamily, statefulBuffer);
        }
        catch (CorruptionException corruptionException) {
            return null;
        }
    }

    public void removeIndexEntry(Transaction transaction, int n, Object object) {
        if (!this.hasIndex()) {
            return;
        }
        if (this._index == null) {
            return;
        }
        this._index.remove(transaction, this.createFieldIndexKey(n, object));
    }

    public boolean alive() {
        if (this.i_state == 1) {
            return true;
        }
        if (this.i_state == 0) {
            if (this.i_handler == null) {
                this.i_handler = this.loadJavaField1();
                if (this.i_handler != null) {
                    if (this.i_handlerID == 0) {
                        this.i_handlerID = this.i_handler.getID();
                    } else if (this.i_handler.getID() != this.i_handlerID) {
                        this.i_handler = null;
                    }
                }
            }
            this.loadJavaField();
            if (this.i_handler == null || this.i_javaField == null) {
                this.i_state = -1;
                this.i_javaField = null;
            } else {
                this.i_handler = this.wrapHandlerToArrays(this.getStream(), this.i_handler);
                this.i_state = 1;
                this.checkDb4oType();
            }
        }
        return this.i_state == 1;
    }

    boolean canAddToQuery(String string) {
        if (!this.alive()) {
            return false;
        }
        return string.equals(this.getName()) && this.getParentYapClass() != null && !this.getParentYapClass().isInternal();
    }

    public boolean canHold(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return !this.i_isPrimitive;
        }
        return this.i_handler.canHold(reflectClass);
    }

    public Object coerce(ReflectClass reflectClass, Object object) {
        if (reflectClass == null || object == null) {
            return this.i_isPrimitive ? No4.INSTANCE : object;
        }
        return this.i_handler.coerce(reflectClass, object);
    }

    public final boolean canLoadByIndex() {
        ClassMetadata classMetadata;
        return !(this.i_handler instanceof ClassMetadata) || !(classMetadata = (ClassMetadata)this.i_handler).isArray();
    }

    void cascadeActivation(Transaction transaction, Object object, int n, boolean bl) {
        if (this.alive()) {
            try {
                Object object2 = this.getOrCreate(transaction, object);
                if (object2 != null && this.i_handler != null) {
                    this.i_handler.cascadeActivation(transaction, object2, n, bl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkDb4oType() {
        if (this.i_javaField != null && this.getStream().i_handlers.ICLASS_DB4OTYPE.isAssignableFrom(this.i_javaField.getFieldType())) {
            this.i_db4oType = HandlerRegistry.getDb4oType(this.i_javaField.getFieldType());
        }
    }

    void collectConstraints(Transaction transaction, QConObject qConObject, Object object, Visitor4 visitor4) {
        Object object2 = this.getOn(transaction, object);
        if (object2 != null) {
            Collection4 collection4 = Platform4.flattenCollection(transaction.stream(), object2);
            Iterator4 iterator4 = collection4.iterator();
            while (iterator4.moveNext()) {
                object2 = iterator4.current();
                if (object2 == null) continue;
                if (this.i_isPrimitive && this.i_handler instanceof PrimitiveHandler && object2.equals(((PrimitiveHandler)this.i_handler).primitiveNull())) {
                    return;
                }
                if (qConObject.hasObjectInParentPath(object2)) continue;
                visitor4.visit(new QConObject(transaction, qConObject, this.qField(transaction), object2));
            }
        }
    }

    public final TreeInt collectIDs(MarshallerFamily marshallerFamily, TreeInt treeInt, StatefulBuffer statefulBuffer) {
        if (this.alive()) {
            if (this.i_handler instanceof ClassMetadata) {
                treeInt = (TreeInt)Tree.add(treeInt, new TreeInt(statefulBuffer.readInt()));
            } else if (this.i_handler instanceof ArrayHandler) {
                treeInt = ((ArrayHandler)this.i_handler).collectIDs(marshallerFamily, treeInt, statefulBuffer);
            }
        }
        return treeInt;
    }

    void configure(ReflectClass reflectClass, boolean bl) {
        this.i_isPrimitive = bl | reflectClass.isPrimitive();
        this.i_isArray = reflectClass.isArray();
        if (this.i_isArray) {
            ReflectArray reflectArray = this.getStream().reflector().array();
            this.i_isNArray = reflectArray.isNDimensional(reflectClass);
            reflectClass = reflectArray.getComponentType(reflectClass);
            this.i_isPrimitive = reflectClass.isPrimitive();
            this.i_handler = this.i_isNArray ? new MultidimensionalArrayHandler(this.getStream(), this.i_handler, this.i_isPrimitive) : new ArrayHandler(this.getStream(), this.i_handler, this.i_isPrimitive);
        }
    }

    void deactivate(Transaction transaction, Object object, int n) {
        if (!this.alive()) {
            return;
        }
        try {
            boolean bl = this._clazz.isEnum();
            if (this.i_isPrimitive && !this.i_isArray) {
                if (!bl) {
                    this.i_javaField.set(object, ((PrimitiveHandler)this.i_handler).primitiveNull());
                }
                return;
            }
            if (n > 0) {
                this.cascadeActivation(transaction, object, n, false);
            }
            if (!bl) {
                this.i_javaField.set(object, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void delete(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) {
        if (!this.alive()) {
            this.incrementOffset(statefulBuffer);
            return;
        }
        this.removeIndexEntry(marshallerFamily, statefulBuffer);
        boolean bl2 = false;
        if (this.i_config != null && this.i_config.cascadeOnDelete().definiteYes() || bl2) {
            int n = statefulBuffer.cascadeDeletes();
            statefulBuffer.setCascadeDeletes(1);
            this.i_handler.deleteEmbedded(marshallerFamily, statefulBuffer);
            statefulBuffer.setCascadeDeletes(n);
        } else if (this.i_config != null && this.i_config.cascadeOnDelete().definiteNo()) {
            int n = statefulBuffer.cascadeDeletes();
            statefulBuffer.setCascadeDeletes(0);
            this.i_handler.deleteEmbedded(marshallerFamily, statefulBuffer);
            statefulBuffer.setCascadeDeletes(n);
        } else {
            this.i_handler.deleteEmbedded(marshallerFamily, statefulBuffer);
        }
    }

    private final void removeIndexEntry(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) {
        if (!this.hasIndex()) {
            return;
        }
        int n = statefulBuffer._offset;
        Object object = null;
        try {
            object = this.i_handler.readIndexEntry(marshallerFamily, statefulBuffer);
        }
        catch (CorruptionException corruptionException) {
            // empty catch block
        }
        this.removeIndexEntry(statefulBuffer.getTransaction(), statefulBuffer.getID(), object);
        statefulBuffer._offset = n;
    }

    public boolean equals(Object object) {
        if (object instanceof FieldMetadata) {
            FieldMetadata fieldMetadata = (FieldMetadata)object;
            fieldMetadata.alive();
            this.alive();
            return fieldMetadata.i_isPrimitive == this.i_isPrimitive && fieldMetadata.i_handler.isEqual(this.i_handler) && fieldMetadata.i_name.equals(this.i_name);
        }
        return false;
    }

    public int hashCode() {
        return this.i_name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        ObjectContainerBase objectContainerBase;
        if (this._clazz != null && (objectContainerBase = this._clazz.getStream()) != null) {
            Object object2 = objectContainerBase.i_lock;
            synchronized (object2) {
                StatefulBuffer statefulBuffer;
                int n;
                objectContainerBase.checkClosed();
                ObjectReference objectReference = objectContainerBase.getYapObject(object);
                if (objectReference != null && (n = objectReference.getID()) > 0 && (statefulBuffer = objectContainerBase.readWriterByID(objectContainerBase.getTransaction(), n)) != null) {
                    statefulBuffer._offset = 0;
                    ObjectHeader objectHeader = new ObjectHeader(objectContainerBase, this._clazz, statefulBuffer);
                    if (objectHeader.objectMarshaller().findOffset(this._clazz, objectHeader._headerAttributes, statefulBuffer, this)) {
                        try {
                            return this.read(objectHeader._marshallerFamily, statefulBuffer);
                        }
                        catch (CorruptionException corruptionException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return null;
    }

    public String getName() {
        return this.i_name;
    }

    public ClassMetadata getFieldYapClass(ObjectContainerBase objectContainerBase) {
        return this.i_handler.getYapClass(objectContainerBase);
    }

    public TypeHandler4 getHandler() {
        return this.i_handler;
    }

    public int getHandlerID() {
        return this.i_handlerID;
    }

    public Object getOn(Transaction transaction, Object object) {
        if (this.alive()) {
            try {
                return this.i_javaField.get(object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public Object getOrCreate(Transaction transaction, Object object) {
        if (this.alive()) {
            try {
                Object object2 = this.i_javaField.get(object);
                if (this.i_db4oType != null && object2 == null) {
                    object2 = this.i_db4oType.createDefault(transaction);
                    this.i_javaField.set(object, object2);
                }
                return object2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public ClassMetadata getParentYapClass() {
        return this._clazz;
    }

    public ReflectClass getStoredType() {
        if (this.i_isPrimitive) {
            return this.i_handler.primitiveClassReflector();
        }
        if (this.i_handler == null) {
            return null;
        }
        return this.i_handler.classReflector();
    }

    public ObjectContainerBase getStream() {
        if (this._clazz == null) {
            return null;
        }
        return this._clazz.getStream();
    }

    public boolean hasConfig() {
        return this.i_config != null;
    }

    public boolean hasIndex() {
        return this._index != null;
    }

    public final void incrementOffset(Buffer buffer) {
        buffer.incrementOffset(this.linkLength());
    }

    public final void init(ClassMetadata classMetadata, String string) {
        this._clazz = classMetadata;
        this.i_name = string;
        this.initIndex(classMetadata, string);
    }

    final void initIndex(ClassMetadata classMetadata, String string) {
        if (classMetadata.i_config != null) {
            this.i_config = classMetadata.i_config.configField(string);
        }
    }

    public void init(int n, boolean bl, boolean bl2, boolean bl3) {
        this.i_handlerID = n;
        this.i_isPrimitive = bl;
        this.i_isArray = bl2;
        this.i_isNArray = bl3;
    }

    final void initConfigOnUp(Transaction transaction) {
        if (this.i_config != null && !this._initialized) {
            this._initialized = true;
            this.i_config.initOnUp(transaction, this);
        }
    }

    public void instantiate(MarshallerFamily marshallerFamily, ObjectReference objectReference, Object object, StatefulBuffer statefulBuffer) throws CorruptionException {
        if (!this.alive()) {
            this.incrementOffset(statefulBuffer);
            return;
        }
        Object object2 = null;
        try {
            object2 = this.read(marshallerFamily, statefulBuffer);
        }
        catch (Exception exception) {
            throw new CorruptionException();
        }
        if (this.i_db4oType != null && object2 != null) {
            ((Db4oTypeImpl)object2).setTrans(statefulBuffer.getTransaction());
        }
        this.set(object, object2);
    }

    public boolean isArray() {
        return this.i_isArray;
    }

    public int linkLength() {
        this.alive();
        if (this.i_handler == null) {
            return 4;
        }
        return this.i_handler.linkLength();
    }

    public void calculateLengths(Transaction transaction, ObjectHeaderAttributes objectHeaderAttributes, Object object) {
        this.alive();
        if (this.i_handler == null) {
            objectHeaderAttributes.addBaseLength(4);
            return;
        }
        this.i_handler.calculateLengths(transaction, objectHeaderAttributes, true, object, true);
    }

    public void loadHandler(ObjectContainerBase objectContainerBase) {
        this.i_handler = objectContainerBase.handlerByID(this.i_handlerID);
    }

    private void loadJavaField() {
        TypeHandler4 typeHandler4 = this.loadJavaField1();
        if (typeHandler4 == null || !typeHandler4.isEqual(this.i_handler)) {
            this.i_javaField = null;
            this.i_state = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeHandler4 loadJavaField1() {
        TypeHandler4 typeHandler4;
        ReflectClass reflectClass = this._clazz.classReflector();
        if (reflectClass == null) {
            return null;
        }
        this.i_javaField = reflectClass.getDeclaredField(this.i_name);
        if (this.i_javaField == null) {
            return null;
        }
        this.i_javaField.setAccessible();
        ObjectContainerBase objectContainerBase = this._clazz.getStream();
        objectContainerBase.showInternalClasses(true);
        try {
            typeHandler4 = objectContainerBase.i_handlers.handlerForClass(objectContainerBase, this.i_javaField.getFieldType());
        }
        catch (Throwable throwable) {
            try {
                objectContainerBase.showInternalClasses(false);
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        objectContainerBase.showInternalClasses(false);
        return typeHandler4;
    }

    public void marshall(ObjectReference objectReference, Object object, MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, Config4Class config4Class, boolean bl) {
        Object object2 = null;
        if (object != null && (config4Class != null && config4Class.cascadeOnUpdate().definiteYes() || this.i_config != null && this.i_config.cascadeOnUpdate().definiteYes())) {
            int n;
            int n2 = 1;
            if (this._clazz.isCollection(object)) {
                GenericReflector genericReflector = this._clazz.reflector();
                n2 = genericReflector.collectionUpdateDepth(genericReflector.forObject(object));
            }
            if ((n = statefulBuffer.getUpdateDepth()) < n2) {
                statefulBuffer.setUpdateDepth(n2);
            }
            object2 = this.i_handler.writeNew(marshallerFamily, object, true, statefulBuffer, true, true);
            statefulBuffer.setUpdateDepth(n);
        } else {
            object2 = this.i_handler.writeNew(marshallerFamily, object, true, statefulBuffer, true, true);
        }
        this.addIndexEntry(statefulBuffer, object2);
    }

    public boolean needsArrayAndPrimitiveInfo() {
        return true;
    }

    public boolean needsHandlerId() {
        return true;
    }

    public Comparable4 prepareComparison(Object object) {
        if (this.alive()) {
            this.i_handler.prepareComparison(object);
            return this.i_handler;
        }
        return null;
    }

    public QField qField(Transaction transaction) {
        int n = 0;
        if (this._clazz != null) {
            n = this._clazz.getID();
        }
        return new QField(transaction, this.i_name, this, n, this.i_arrayPosition);
    }

    Object read(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) throws CorruptionException {
        if (!this.alive()) {
            this.incrementOffset(statefulBuffer);
            return null;
        }
        return this.i_handler.read(marshallerFamily, statefulBuffer, true);
    }

    public Object readQuery(Transaction transaction, MarshallerFamily marshallerFamily, Buffer buffer) throws CorruptionException {
        return this.i_handler.readQuery(transaction, marshallerFamily, true, buffer, false);
    }

    public void readVirtualAttribute(Transaction transaction, Buffer buffer, ObjectReference objectReference) {
        buffer.incrementOffset(this.i_handler.linkLength());
    }

    void refresh() {
        TypeHandler4 typeHandler4 = this.loadJavaField1();
        if (typeHandler4 != null && (typeHandler4 = this.wrapHandlerToArrays(this.getStream(), typeHandler4)).isEqual(this.i_handler)) {
            return;
        }
        this.i_javaField = null;
        this.i_state = -1;
    }

    public void rename(String string) {
        ObjectContainerBase objectContainerBase = this._clazz.getStream();
        if (!objectContainerBase.isClient()) {
            this.i_name = string;
            this._clazz.setStateDirty();
            this._clazz.write(objectContainerBase.getSystemTransaction());
        } else {
            Exceptions4.throwRuntimeException(58);
        }
    }

    public void setArrayPosition(int n) {
        this.i_arrayPosition = n;
    }

    public void set(Object object, Object object2) {
        try {
            this.i_javaField.set(object, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void setName(String string) {
        this.i_name = string;
    }

    boolean supportsIndex() {
        return this.alive() && this.i_handler.supportsIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traverseValues(final Visitor4 visitor4) {
        if (!this.alive()) {
            return;
        }
        this.assertHasIndex();
        ObjectContainerBase objectContainerBase = this._clazz.getStream();
        if (objectContainerBase.isClient()) {
            Exceptions4.throwRuntimeException(67);
        }
        Object object = objectContainerBase.lock();
        synchronized (object) {
            final Transaction transaction = objectContainerBase.getTransaction();
            this._index.traverseKeys(transaction, new Visitor4(){

                public void visit(Object object) {
                    FieldIndexKey fieldIndexKey = (FieldIndexKey)object;
                    visitor4.visit(FieldMetadata.this.i_handler.indexEntryToObject(transaction, fieldIndexKey.value()));
                }
            });
        }
    }

    private void assertHasIndex() {
        if (!this.hasIndex()) {
            Exceptions4.throwRuntimeException(66);
        }
    }

    private final TypeHandler4 wrapHandlerToArrays(ObjectContainerBase objectContainerBase, TypeHandler4 typeHandler4) {
        if (this.i_isNArray) {
            typeHandler4 = new MultidimensionalArrayHandler(objectContainerBase, typeHandler4, this.i_isPrimitive);
        } else if (this.i_isArray) {
            typeHandler4 = new ArrayHandler(objectContainerBase, typeHandler4, this.i_isPrimitive);
        }
        return typeHandler4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._clazz != null) {
            stringBuffer.append(this._clazz.getName());
            stringBuffer.append(".");
            stringBuffer.append(this.getName());
        }
        return stringBuffer.toString();
    }

    public final String toString(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) {
        String string = "\n Field " + this.i_name;
        if (!this.alive()) {
            this.incrementOffset(statefulBuffer);
        } else {
            Object object = null;
            try {
                object = this.read(marshallerFamily, statefulBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = object == null ? string + "\n [null]" : string + "\n  " + object.toString();
        }
        return string;
    }

    public void initIndex(Transaction transaction) {
        this.initIndex(transaction, 0);
    }

    public void initIndex(Transaction transaction, int n) {
        if (this._index != null) {
            throw new IllegalStateException();
        }
        if (transaction.stream().isClient()) {
            return;
        }
        this._index = this.newBTree(transaction, n);
    }

    protected final BTree newBTree(Transaction transaction, int n) {
        ObjectContainerBase objectContainerBase = transaction.stream();
        Indexable4 indexable4 = this.indexHandler(objectContainerBase);
        if (indexable4 == null) {
            return null;
        }
        return new BTree(transaction, n, new FieldIndexKeyHandler(objectContainerBase, indexable4));
    }

    protected Indexable4 indexHandler(ObjectContainerBase objectContainerBase) {
        ReflectClass reflectClass = null;
        if (this.i_javaField != null) {
            reflectClass = this.i_javaField.indexType();
        }
        TypeHandler4 typeHandler4 = objectContainerBase.i_handlers.handlerForClass(objectContainerBase, reflectClass);
        return typeHandler4;
    }

    public BTree getIndex(Transaction transaction) {
        return this._index;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isPrimitive() {
        return this.i_isPrimitive;
    }

    public BTreeRange search(Transaction transaction, Object object) {
        this.assertHasIndex();
        BTreeNodeSearchResult bTreeNodeSearchResult = this.searchLowerBound(transaction, object);
        BTreeNodeSearchResult bTreeNodeSearchResult2 = this.searchUpperBound(transaction, object);
        return bTreeNodeSearchResult.createIncludingRange(bTreeNodeSearchResult2);
    }

    private BTreeNodeSearchResult searchUpperBound(Transaction transaction, Object object) {
        return this.searchBound(transaction, Integer.MAX_VALUE, object);
    }

    private BTreeNodeSearchResult searchLowerBound(Transaction transaction, Object object) {
        return this.searchBound(transaction, 0, object);
    }

    private BTreeNodeSearchResult searchBound(Transaction transaction, int n, Object object) {
        return this.getIndex(transaction).searchLeaf(transaction, this.createFieldIndexKey(n, object), SearchTarget.LOWEST);
    }

    public boolean rebuildIndexForClass(LocalObjectContainer localObjectContainer, ClassMetadata classMetadata) {
        long[] lArray = classMetadata.getIDs();
        for (int i = 0; i < lArray.length; ++i) {
            this.rebuildIndexForObject(localObjectContainer, classMetadata, (int)lArray[i]);
        }
        return lArray.length > 0;
    }

    protected void rebuildIndexForObject(LocalObjectContainer localObjectContainer, ClassMetadata classMetadata, int n) {
        StatefulBuffer statefulBuffer = localObjectContainer.readWriterByID(localObjectContainer.getSystemTransaction(), n);
        if (statefulBuffer != null) {
            this.rebuildIndexForWriter(localObjectContainer, statefulBuffer, n);
        }
    }

    protected void rebuildIndexForWriter(LocalObjectContainer localObjectContainer, StatefulBuffer statefulBuffer, int n) {
        ObjectHeader objectHeader = new ObjectHeader(localObjectContainer, (Buffer)statefulBuffer);
        Object object = this.readIndexEntryForRebuild(statefulBuffer, objectHeader);
        this.addIndexEntry(localObjectContainer.getSystemTransaction(), n, object);
    }

    private Object readIndexEntryForRebuild(StatefulBuffer statefulBuffer, ObjectHeader objectHeader) {
        return objectHeader.objectMarshaller().readIndexEntry(objectHeader.yapClass(), objectHeader._headerAttributes, this, statefulBuffer);
    }

    public void dropIndex(Transaction transaction) {
        if (this._index == null) {
            return;
        }
        ObjectContainerBase objectContainerBase = transaction.stream();
        if (objectContainerBase.configImpl().messageLevel() > 0) {
            objectContainerBase.message("dropping index " + this.toString());
        }
        this._index.free(transaction);
        objectContainerBase.setDirtyInSystemTransaction(this.getParentYapClass());
        this._index = null;
    }

    public void defragField(MarshallerFamily marshallerFamily, ReaderPair readerPair) {
        this.getHandler().defrag(marshallerFamily, readerPair, true);
    }

    public void createIndex() {
        if (this.hasIndex()) {
            return;
        }
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)this._clazz.getStream();
        if (localObjectContainer.configImpl().messageLevel() > 0) {
            localObjectContainer.message("creating index " + this.toString());
        }
        this.initIndex(localObjectContainer.getSystemTransaction());
        localObjectContainer.setDirtyInSystemTransaction(this.getParentYapClass());
        this.reindex(localObjectContainer);
    }

    private void reindex(LocalObjectContainer localObjectContainer) {
        ClassMetadata classMetadata = this.getParentYapClass();
        if (this.rebuildIndexForClass(localObjectContainer, classMetadata)) {
            localObjectContainer.getSystemTransaction().commit();
        }
    }
}

