/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.config.Configuration;
import com.db4o.config.annotations.reflect.ConfigurationIntrospector;
import com.db4o.ext.Db4oException;
import com.db4o.internal.Config4Class;
import com.db4o.internal.JDK_1_4;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.jdk.JdkReflector;
import java.net.Socket;

class JDK_5
extends JDK_1_4 {
    private static final String ENUM_CLASSNAME = "java.lang.Enum";
    private static ReflectClass enumClass;

    JDK_5() {
    }

    public Config4Class extendConfiguration(ReflectClass reflectClass, Configuration configuration, Config4Class config4Class) {
        Class clazz = JdkReflector.toNative(reflectClass);
        if (clazz == null) {
            return config4Class;
        }
        try {
            ConfigurationIntrospector configurationIntrospector = new ConfigurationIntrospector(clazz, configuration, config4Class);
            return configurationIntrospector.apply();
        }
        catch (Exception exception) {
            throw new Db4oException(exception);
        }
    }

    public boolean isConnected(Socket socket) {
        if (socket == null) {
            return false;
        }
        if (!socket.isConnected()) {
            return false;
        }
        return !socket.isClosed();
    }

    boolean isEnum(Reflector reflector, ReflectClass reflectClass) {
        if (reflectClass == null) {
            return false;
        }
        if (enumClass == null) {
            try {
                enumClass = reflector.forClass(Class.forName(ENUM_CLASSNAME));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        return enumClass.isAssignableFrom(reflectClass);
    }
}

