/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Collection4;
import com.db4o.internal.Buffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Persistent;
import com.db4o.internal.Transaction;
import com.db4o.internal.slots.Pointer4;

public abstract class PersistentBase
implements Persistent {
    protected int i_id;
    protected int i_state = 2;

    final boolean beginProcessing() {
        if (this.bitIsTrue(2)) {
            return false;
        }
        this.bitTrue(2);
        return true;
    }

    final void bitFalse(int n) {
        this.i_state &= ~(1 << n);
    }

    final boolean bitIsFalse(int n) {
        return (this.i_state | 1 << n) != this.i_state;
    }

    final boolean bitIsTrue(int n) {
        return (this.i_state | 1 << n) == this.i_state;
    }

    final void bitTrue(int n) {
        this.i_state |= 1 << n;
    }

    void cacheDirty(Collection4 collection4) {
        if (!this.bitIsTrue(3)) {
            this.bitTrue(3);
            collection4.add(this);
        }
    }

    public void endProcessing() {
        this.bitFalse(2);
    }

    public int getID() {
        return this.i_id;
    }

    public final boolean isActive() {
        return this.bitIsTrue(1);
    }

    public boolean isDirty() {
        return this.bitIsTrue(1) && !this.bitIsTrue(0);
    }

    public final boolean isNew() {
        return this.i_id == 0;
    }

    public int linkLength() {
        return 4;
    }

    final void notCachedDirty() {
        this.bitFalse(3);
    }

    public void read(Transaction transaction) {
        try {
            if (this.beginProcessing()) {
                Buffer buffer = transaction.stream().readReaderByID(transaction, this.getID());
                if (buffer != null) {
                    this.readThis(transaction, buffer);
                    this.setStateOnRead(buffer);
                }
                this.endProcessing();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setID(int n) {
        this.i_id = n;
    }

    public final void setStateClean() {
        this.bitTrue(1);
        this.bitTrue(0);
    }

    public final void setStateDeactivated() {
        this.bitFalse(1);
    }

    public void setStateDirty() {
        this.bitTrue(1);
        this.bitFalse(0);
    }

    void setStateOnRead(Buffer buffer) {
        if (this.bitIsTrue(3)) {
            this.setStateDirty();
        } else {
            this.setStateClean();
        }
    }

    public final void write(Transaction transaction) {
        if (!this.writeObjectBegin()) {
            return;
        }
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)transaction.stream();
        int n = 0;
        int n2 = this.ownLength();
        Buffer buffer = new Buffer(n2);
        if (this.isNew()) {
            Pointer4 pointer4 = localObjectContainer.newSlot(transaction, n2);
            this.setID(pointer4._id);
            n = pointer4._address;
        } else {
            n = localObjectContainer.getSlot(n2);
            transaction.slotFreeOnRollbackCommitSetPointer(this.i_id, n, n2);
        }
        this.writeThis(transaction, buffer);
        buffer.writeEncrypt(localObjectContainer, n, 0);
        if (this.isActive()) {
            this.setStateClean();
        }
        this.endProcessing();
    }

    public boolean writeObjectBegin() {
        if (this.isDirty()) {
            return this.beginProcessing();
        }
        return false;
    }

    public void writeOwnID(Transaction transaction, Buffer buffer) {
        this.write(transaction);
        buffer.writeInt(this.getID());
    }
}

