/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs.messages;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.Buffer;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.ServerMessageDispatcher;
import com.db4o.internal.cs.messages.MClassMeta;
import com.db4o.internal.cs.messages.MClassNameForID;
import com.db4o.internal.cs.messages.MCommit;
import com.db4o.internal.cs.messages.MCommitOK;
import com.db4o.internal.cs.messages.MCommitSystemTransaction;
import com.db4o.internal.cs.messages.MCreateClass;
import com.db4o.internal.cs.messages.MDelete;
import com.db4o.internal.cs.messages.MGetAll;
import com.db4o.internal.cs.messages.MGetClasses;
import com.db4o.internal.cs.messages.MGetInternalIDs;
import com.db4o.internal.cs.messages.MObjectByUuid;
import com.db4o.internal.cs.messages.MObjectSetFetch;
import com.db4o.internal.cs.messages.MObjectSetGetId;
import com.db4o.internal.cs.messages.MObjectSetIndexOf;
import com.db4o.internal.cs.messages.MObjectSetReset;
import com.db4o.internal.cs.messages.MObjectSetSize;
import com.db4o.internal.cs.messages.MPrefetchIDs;
import com.db4o.internal.cs.messages.MProcessDeletes;
import com.db4o.internal.cs.messages.MQueryExecute;
import com.db4o.internal.cs.messages.MReadBlob;
import com.db4o.internal.cs.messages.MReadBytes;
import com.db4o.internal.cs.messages.MReadMultipleObjects;
import com.db4o.internal.cs.messages.MReadObject;
import com.db4o.internal.cs.messages.MReleaseSemaphore;
import com.db4o.internal.cs.messages.MRollback;
import com.db4o.internal.cs.messages.MSetSemaphore;
import com.db4o.internal.cs.messages.MTaDelete;
import com.db4o.internal.cs.messages.MTaIsDeleted;
import com.db4o.internal.cs.messages.MUseTransaction;
import com.db4o.internal.cs.messages.MUserMessage;
import com.db4o.internal.cs.messages.MWriteBatchedMessages;
import com.db4o.internal.cs.messages.MWriteBlob;
import com.db4o.internal.cs.messages.MWriteNew;
import com.db4o.internal.cs.messages.MWriteUpdate;
import com.db4o.internal.cs.messages.MWriteUpdateDeleteMembers;
import com.db4o.internal.cs.messages.MsgBlob;
import com.db4o.internal.cs.messages.MsgD;
import com.db4o.internal.cs.messages.MsgObject;
import java.io.IOException;

public class Msg
implements Cloneable {
    static int _idGenerator = 1;
    private static Msg[] _messages = new Msg[60];
    int _msgID = _idGenerator++;
    String _name;
    Transaction _trans;
    public static final MsgD CLASS_NAME_FOR_ID = new MClassNameForID();
    public static final Msg CLOSE = new Msg("CLOSE");
    public static final Msg COMMIT = new MCommit();
    public static final Msg COMMIT_OK = new MCommitOK();
    public static final Msg COMMIT_SYSTEMTRANS = new MCommitSystemTransaction();
    public static final MsgD CREATE_CLASS = new MCreateClass();
    public static final MsgObject CLASS_META = new MClassMeta();
    public static final Msg CURRENT_VERSION = new Msg("VERSION");
    public static final MsgD DELETE = new MDelete();
    public static final Msg ERROR = new Msg("ERROR");
    public static final Msg FAILED = new Msg("FAILED");
    public static final MsgD GET_ALL = new MGetAll();
    public static final MsgD GET_CLASSES = new MGetClasses();
    public static final MsgD GET_INTERNAL_IDS = new MGetInternalIDs();
    public static final Msg GET_THREAD_ID = new Msg("GET_THREAD_ID");
    public static final MsgD ID_LIST = new MsgD("ID_LIST");
    public static final Msg IDENTITY = new Msg("IDENTITY");
    public static final MsgD LENGTH = new MsgD("LENGTH");
    public static final MsgD LOGIN = new MsgD("LOGIN");
    public static final MsgD LOGIN_OK = new MsgD("LOGIN_OK");
    public static final Msg NULL = new Msg("NULL");
    public static final MsgD OBJECT_BY_UUID = new MObjectByUuid();
    public static final MsgObject OBJECT_TO_CLIENT = new MsgObject();
    public static final MsgD OBJECTSET_FETCH = new MObjectSetFetch();
    public static final MsgD OBJECTSET_FINALIZED = new MsgD("OBJECTSET_FINALIZED");
    public static final MsgD OBJECTSET_GET_ID = new MObjectSetGetId();
    public static final MsgD OBJECTSET_INDEXOF = new MObjectSetIndexOf();
    public static final MsgD OBJECTSET_RESET = new MObjectSetReset();
    public static final MsgD OBJECTSET_SIZE = new MObjectSetSize();
    public static final Msg OK = new Msg("OK");
    public static final Msg PING = new Msg("PING");
    public static final MsgD PREFETCH_IDS = new MPrefetchIDs();
    public static final Msg PROCESS_DELETES = new MProcessDeletes();
    public static final MsgObject QUERY_EXECUTE = new MQueryExecute();
    public static final MsgD QUERY_RESULT = new MsgD("QUERY_RESULT");
    public static final MsgD RAISE_VERSION = new MsgD("RAISE_VERSION");
    public static final MsgBlob READ_BLOB = new MReadBlob();
    public static final MsgD READ_BYTES = new MReadBytes();
    public static final MsgD READ_MULTIPLE_OBJECTS = new MReadMultipleObjects();
    public static final MsgD READ_OBJECT = new MReadObject();
    public static final MsgD RELEASE_SEMAPHORE = new MReleaseSemaphore();
    public static final Msg ROLLBACK = new MRollback();
    public static final MsgD SET_SEMAPHORE = new MSetSemaphore();
    public static final Msg SUCCESS = new Msg("SUCCESS");
    public static final MsgD SWITCH_TO_FILE = new MsgD("SWITCH_F");
    public static final Msg SWITCH_TO_MAIN_FILE = new Msg("SWITCH_M");
    public static final MsgD TA_DELETE = new MTaDelete();
    public static final MsgD TA_IS_DELETED = new MTaIsDeleted();
    public static final MsgD USER_MESSAGE = new MUserMessage();
    public static final MsgD USE_TRANSACTION = new MUseTransaction();
    public static final MsgBlob WRITE_BLOB = new MWriteBlob();
    public static final MWriteNew WRITE_NEW = new MWriteNew();
    public static final MsgObject WRITE_UPDATE = new MWriteUpdate();
    public static final MsgD WRITE_UPDATE_DELETE_MEMBERS = new MWriteUpdateDeleteMembers();
    public static final MWriteBatchedMessages WRITE_BATCHED_MESSAGES = new MWriteBatchedMessages();

    Msg() {
        Msg._messages[this._msgID] = this;
    }

    Msg(String string) {
        this();
        this._name = string;
    }

    public static Msg getMessage(int n) {
        return _messages[n];
    }

    public final Msg clone(Transaction transaction) {
        Msg msg = null;
        try {
            msg = (Msg)this.clone();
            msg._trans = transaction;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return msg;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this._msgID == ((Msg)object)._msgID;
    }

    public int hashCode() {
        return this._msgID;
    }

    void fakePayLoad(Transaction transaction) {
        this._trans = transaction;
    }

    public Buffer getByteLoad() {
        return null;
    }

    final String getName() {
        if (this._name == null) {
            return this.getClass().getName();
        }
        return this._name;
    }

    protected Transaction transaction() {
        return this._trans;
    }

    protected LocalObjectContainer file() {
        return (LocalObjectContainer)this.stream();
    }

    protected ObjectContainerBase stream() {
        return this.transaction().stream();
    }

    protected Object streamLock() {
        return this.stream().lock();
    }

    protected Config4Impl config() {
        return this.stream().config();
    }

    public boolean processAtServer(ServerMessageDispatcher serverMessageDispatcher) {
        return false;
    }

    public static final Msg readMessage(Transaction transaction, Socket4 socket4) throws IOException {
        StatefulBuffer statefulBuffer = new StatefulBuffer(transaction, 9);
        if (!statefulBuffer.read(socket4)) {
            return null;
        }
        Msg msg = _messages[statefulBuffer.readInt()].readPayLoad(transaction, socket4, statefulBuffer);
        return msg;
    }

    Msg readPayLoad(Transaction transaction, Socket4 socket4, Buffer buffer) throws IOException {
        transaction = this.checkParentTransaction(transaction, buffer);
        return this.clone(transaction);
    }

    protected Transaction checkParentTransaction(Transaction transaction, Buffer buffer) {
        if (buffer.readByte() == 115 && transaction.parentTransaction() != null) {
            return transaction.parentTransaction();
        }
        return transaction;
    }

    final void setTransaction(Transaction transaction) {
        this._trans = transaction;
    }

    public final String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(ObjectContainerBase objectContainerBase, Socket4 socket4) {
        if (null == objectContainerBase) {
            throw new ArgumentNullException();
        }
        if (null == socket4) {
            throw new ArgumentNullException();
        }
        Socket4 socket42 = socket4;
        synchronized (socket42) {
            try {
                socket4.write(this.payLoad()._buffer);
                socket4.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public StatefulBuffer payLoad() {
        StatefulBuffer statefulBuffer = new StatefulBuffer(this.transaction(), 9);
        statefulBuffer.writeInt(this._msgID);
        return statefulBuffer;
    }
}

