/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.net.URI;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.rssowl.core.Owl;
import org.rssowl.core.interpreter.INamespaceHandler;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;

public class MediaNamespaceHandler
implements INamespaceHandler {
    public void processAttribute(Attribute attribute, IPersistable type) {
    }

    public void processElement(Element element, IPersistable type) {
        if (!(type instanceof INews)) {
            return;
        }
        String name = element.getName().toLowerCase();
        if ("group".equals(name)) {
            List groupChilds = element.getChildren();
            for (Element child : groupChilds) {
                if (!"content".equals(child.getName().toLowerCase())) continue;
                this.processContent(child, (INews)type);
            }
        } else if ("content".equals(name)) {
            this.processContent(element, (INews)type);
        }
    }

    private void processContent(Element element, INews news) {
        if (element.getAttributes().isEmpty()) {
            return;
        }
        URI attachmentUri = null;
        String attachmentType = null;
        int attachmentLength = -1;
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            String name = attribute.getName();
            if ("url".equals(name)) {
                attachmentUri = URIUtils.createURI(attribute.getValue());
                continue;
            }
            if ("type".equals(name)) {
                attachmentType = attribute.getValue();
                continue;
            }
            if (!"fileSize".equals(name)) continue;
            attachmentLength = StringUtils.stringToInt(attribute.getValue());
        }
        if (attachmentUri != null && !CoreUtils.hasAttachment(news, attachmentUri)) {
            IAttachment attachment = Owl.getModelFactory().createAttachment(null, news);
            attachment.setLink(attachmentUri);
            if (StringUtils.isSet(attachmentType)) {
                attachment.setType(attachmentType);
            }
            if (attachmentLength != -1) {
                attachment.setLength(attachmentLength);
            }
        }
    }
}

