/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.Persistable;
import org.rssowl.core.persist.IConditionalGet;

public class ConditionalGet
extends Persistable
implements IConditionalGet {
    private String fLink;
    private String fIfModifiedSince;
    private String fIfNoneMatch;

    public ConditionalGet(String ifModifiedSince, URI link, String ifNoneMatch) {
        Assert.isNotNull((Object)link, (String)"feedLink cannot be null");
        this.internalSetHeaders(ifModifiedSince, ifNoneMatch);
        this.fLink = link.toString();
    }

    private void internalSetHeaders(String ifModifiedSince, String ifNoneMatch) {
        Assert.isLegal((ifModifiedSince != null || ifNoneMatch != null ? 1 : 0) != 0, (String)"ifModifiedSince and ifNoneMatch are null. Either of them has to be non-null");
        this.fIfModifiedSince = ifModifiedSince;
        this.fIfNoneMatch = ifNoneMatch;
    }

    protected ConditionalGet() {
    }

    public synchronized URI getLink() {
        try {
            return new URI(this.fLink);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("Malformed URI was stored: " + this.fLink);
        }
    }

    public synchronized String getIfModifiedSince() {
        return this.fIfModifiedSince;
    }

    public synchronized String getIfNoneMatch() {
        return this.fIfNoneMatch;
    }

    public synchronized void setHeaders(String ifModifiedSince, String ifNoneMatch) {
        this.internalSetHeaders(ifModifiedSince, ifNoneMatch);
    }
}

