/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.rssowl.core.internal.persist.Mark;
import org.rssowl.core.internal.persist.NewsContainer;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.persist.reference.NewsReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsBin
extends Mark
implements INewsBin {
    private NewsContainer fNewsContainer;

    public NewsBin(Long id, IFolder folder, String name) {
        super(id, folder, name);
        this.fNewsContainer = new NewsContainer(Collections.<INews.State, Boolean>emptyMap());
    }

    protected NewsBin() {
    }

    public synchronized NewsContainer internalGetNewsContainer() {
        return this.fNewsContainer;
    }

    @Override
    public synchronized void addNews(INews news) {
        this.fNewsContainer.addNews(news);
    }

    @Override
    public synchronized boolean containsNews(INews news) {
        return this.fNewsContainer.containsNews(news);
    }

    @Override
    public synchronized List<NewsReference> getNewsRefs() {
        return this.fNewsContainer.getNews();
    }

    @Override
    public synchronized int getNewsCount(Set<INews.State> states) {
        return this.fNewsContainer.getNewsCount(states);
    }

    @Override
    public synchronized void removeNews(INews news) {
        this.fNewsContainer.removeNews(news);
    }

    public synchronized void removeNewsRefs(List<NewsReference> newsRefs) {
        this.fNewsContainer.removeNewsRefs(newsRefs);
    }

    @Override
    public synchronized List<INews> getNews() {
        return this.getNews(EnumSet.allOf(INews.State.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<INews> getNews(Set<INews.State> states) {
        List<NewsReference> newsRefs;
        NewsBin newsBin = this;
        synchronized (newsBin) {
            newsRefs = this.fNewsContainer.getNews(states);
        }
        return NewsBin.getNews(newsRefs);
    }

    @Override
    public synchronized List<NewsReference> getNewsRefs(Set<INews.State> states) {
        return this.fNewsContainer.getNews(states);
    }

    @Override
    public NewsBinReference toReference() {
        return new NewsBinReference(this.getIdAsPrimitive());
    }

    @Override
    public boolean isGetNewsRefsEfficient() {
        return true;
    }

    @Override
    public synchronized boolean updateNewsStates(Collection<INewsBin.StatesUpdateInfo> statesUpdateInfos) {
        return this.fNewsContainer.updateNewsStates(statesUpdateInfos);
    }

    @Override
    public synchronized Collection<NewsReference> removeNews(Set<INews.State> states) {
        return this.fNewsContainer.removeNews(states);
    }
}

