/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.ext.Db4oException;
import com.db4o.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.internal.persist.service.DBManager;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.internal.persist.service.DatabaseListener;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.IPersistableDAO;
import org.rssowl.core.persist.service.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistableDAO<T extends IPersistable>
implements IPersistableDAO<T> {
    protected final Class<? extends T> fEntityClass;
    protected final boolean fSaveFully;
    protected volatile ReadWriteLock fLock;
    protected volatile Lock fWriteLock;
    protected volatile Lock fReadLock;
    protected volatile ObjectContainer fDb;

    public AbstractPersistableDAO(Class<? extends T> entityClass, boolean saveFully) {
        Assert.isNotNull(entityClass, (String)"entityClass");
        this.fEntityClass = entityClass;
        this.fSaveFully = saveFully;
        DBManager.getDefault().addEntityStoreListener(new DatabaseListener(){

            public void databaseOpened(DatabaseEvent event) {
                AbstractPersistableDAO.this.onDatabaseOpened(event);
            }

            public void databaseClosed(DatabaseEvent event) {
                AbstractPersistableDAO.this.onDatabaseClosed(event);
            }
        });
    }

    protected void onDatabaseOpened(DatabaseEvent event) {
        this.fDb = event.getObjectContainer();
        this.fLock = event.getLock();
        this.fWriteLock = this.fLock.writeLock();
        this.fReadLock = this.fLock.readLock();
    }

    protected void onDatabaseClosed(DatabaseEvent event) {
        this.fDb = null;
    }

    @Override
    public final Class<? extends T> getEntityClass() {
        return this.fEntityClass;
    }

    protected final T getSingleResult(Query query) {
        List<T> result = this.getList(query);
        int resultSize = result.size();
        if (resultSize == 0) {
            return null;
        }
        if (resultSize == 1) {
            return (T)((IPersistable)result.get(0));
        }
        throw new IllegalStateException("Expected a single result, but got: " + resultSize);
    }

    protected final List<T> getList(Query query) {
        return query.execute();
    }

    @Override
    public Collection<T> loadAll() {
        try {
            ObjectSet entities = this.fDb.query(this.fEntityClass);
            this.activateAll(entities);
            return new ArrayList(entities);
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }

    protected final <C extends Collection<O>, O> C activateAll(C collection) {
        for (O o : collection) {
            this.fDb.ext().activate(o, Integer.MAX_VALUE);
        }
        return collection;
    }

    @Override
    public T save(T object) {
        this.saveAll(Collections.singletonList(object));
        return object;
    }

    @Override
    public void saveAll(Collection<T> objects) {
        if (objects.isEmpty()) {
            return;
        }
        try {
            this.preSaveAll(objects);
            this.fWriteLock.lock();
            try {
                try {
                    for (IPersistable object : objects) {
                        this.preSave(object);
                    }
                    for (IPersistable object : objects) {
                        this.doSave(object);
                    }
                    this.preCommit();
                    this.fDb.commit();
                }
                catch (Db4oException e) {
                    throw DBHelper.rollbackAndPE(this.fDb, (Exception)((Object)e));
                }
            }
            finally {
                this.fWriteLock.unlock();
            }
            DBHelper.cleanUpAndFireEvents();
        }
        finally {
            this.postSaveAll(objects);
        }
    }

    protected void preSaveAll(Collection<T> objects) {
    }

    protected void postSaveAll(Collection<T> objects) {
    }

    protected void preSave(T persistable) {
    }

    protected void doSave(T entity) {
        if (this.fSaveFully) {
            this.fDb.ext().set(entity, Integer.MAX_VALUE);
        } else {
            this.fDb.set(entity);
        }
    }

    @Override
    public void delete(T object) {
        this.deleteAll(Collections.singletonList(object));
    }

    protected void doDelete(T entity) {
        this.fDb.delete(entity);
    }

    @Override
    public void deleteAll(Collection<T> objects) {
        block8: {
            if (objects.isEmpty()) {
                return;
            }
            this.fWriteLock.lock();
            try {
                try {
                    for (IPersistable object : objects) {
                        this.preDelete(object);
                    }
                    for (IPersistable object : objects) {
                        this.doDelete(object);
                    }
                    this.preCommit();
                    this.fDb.commit();
                }
                catch (Db4oException e) {
                    DBHelper.rollbackAndPE(this.fDb, (Exception)((Object)e));
                    this.fWriteLock.unlock();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.fWriteLock.unlock();
                throw throwable;
            }
            this.fWriteLock.unlock();
        }
        DBHelper.cleanUpAndFireEvents();
    }

    protected void preCommit() {
        DBHelper.preCommit(this.fDb);
    }

    protected void preDelete(T persistable) {
    }

    @Override
    public long countAll() {
        try {
            ObjectSet entities = this.fDb.query(this.fEntityClass);
            return entities.size();
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }
}

