/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.rssowl.core.internal.persist.dao.BookMarkDAOImpl;
import org.rssowl.core.internal.persist.dao.CachingDAO;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.event.BookMarkEvent;
import org.rssowl.core.persist.event.BookMarkListener;
import org.rssowl.core.persist.reference.FeedLinkReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CachingBookMarkDAO
extends CachingDAO<BookMarkDAOImpl, IBookMark, BookMarkListener, BookMarkEvent>
implements IBookMarkDAO {
    public CachingBookMarkDAO() {
        super(new BookMarkDAOImpl());
    }

    @Override
    protected void onDatabaseOpened(DatabaseEvent event) {
        super.onDatabaseOpened(event);
    }

    @Override
    protected BookMarkListener createEntityListener() {
        return new BookMarkListener(){

            @Override
            public void entitiesAdded(Set<BookMarkEvent> events) {
                for (BookMarkEvent event : events) {
                    CachingBookMarkDAO.this.getCache().put(event.getEntity().getId(), event.getEntity());
                }
            }

            @Override
            public void entitiesDeleted(Set<BookMarkEvent> events) {
                for (BookMarkEvent event : events) {
                    CachingBookMarkDAO.this.getCache().remove(event.getEntity().getId(), event.getEntity());
                }
            }

            @Override
            public void entitiesUpdated(Set<BookMarkEvent> events) {
            }
        };
    }

    @Override
    public Collection<IBookMark> loadAll(FeedLinkReference feedRef) {
        HashSet<IBookMark> marks = new HashSet<IBookMark>(1);
        for (IBookMark mark : this.getCache().values()) {
            if (!mark.getFeedLinkReference().equals(feedRef)) continue;
            marks.add(mark);
        }
        return marks;
    }

    @Override
    public boolean exists(FeedLinkReference feedRef) {
        for (IBookMark mark : this.getCache().values()) {
            if (!mark.getFeedLinkReference().equals(feedRef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visited(IBookMark mark) {
        ((BookMarkDAOImpl)this.getDAO()).visited(mark);
    }
}

