/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import java.util.Set;
import org.rssowl.core.internal.persist.dao.CachingDAO;
import org.rssowl.core.internal.persist.dao.SearchMarkDAOImpl;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.ISearchMarkDAO;
import org.rssowl.core.persist.event.SearchMarkEvent;
import org.rssowl.core.persist.event.SearchMarkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingSearchMarkDAO
extends CachingDAO<SearchMarkDAOImpl, ISearchMark, SearchMarkListener, SearchMarkEvent>
implements ISearchMarkDAO {
    public CachingSearchMarkDAO() {
        super(new SearchMarkDAOImpl());
    }

    @Override
    protected void onDatabaseOpened(DatabaseEvent event) {
        super.onDatabaseOpened(event);
    }

    @Override
    protected SearchMarkListener createEntityListener() {
        return new SearchMarkListener(){

            @Override
            public void entitiesAdded(Set<SearchMarkEvent> events) {
                for (SearchMarkEvent event : events) {
                    CachingSearchMarkDAO.this.getCache().put(event.getEntity().getId(), event.getEntity());
                }
            }

            @Override
            public void entitiesDeleted(Set<SearchMarkEvent> events) {
                for (SearchMarkEvent event : events) {
                    CachingSearchMarkDAO.this.getCache().remove(event.getEntity().getId(), event.getEntity());
                }
            }

            @Override
            public void entitiesUpdated(Set<SearchMarkEvent> events) {
            }

            @Override
            public void newsChanged(Set<SearchMarkEvent> events) {
            }
        };
    }

    @Override
    public void fireNewsChanged(Set<SearchMarkEvent> events) {
        ((SearchMarkDAOImpl)this.getDAO()).fireNewsChanged(events);
    }

    @Override
    public ISearchMark load(ISearchCondition searchCondition) {
        for (ISearchMark mark : this.getCache().values()) {
            if (!mark.containsSearchCondition(searchCondition)) continue;
            return mark;
        }
        return null;
    }

    @Override
    public void visited(ISearchMark mark) {
        ((SearchMarkDAOImpl)this.getDAO()).visited(mark);
    }
}

