/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.pref;

import java.util.Properties;
import org.rssowl.core.persist.pref.IPreferenceScope;

public class DefaultScope
implements IPreferenceScope {
    private static final boolean BOOLEAN_DEFAULT = false;
    private static final int INT_DEFAULT = 0;
    private static final long LONG_DEFAULT = 0L;
    private final Properties fDefaults = new Properties();

    public IPreferenceScope getParent() {
        throw new RuntimeException("There can be no parent of the DefaultScope");
    }

    public void flush() {
    }

    public void delete(String key) {
        this.fDefaults.remove(key);
    }

    public boolean hasKey(String key) {
        return this.fDefaults.containsKey(key);
    }

    public boolean getBoolean(String key) {
        Object res = this.fDefaults.get(key);
        if (res != null) {
            return (Boolean)res;
        }
        return false;
    }

    public int getInteger(String key) {
        Object res = this.fDefaults.get(key);
        if (res != null) {
            return (Integer)res;
        }
        return 0;
    }

    public int[] getIntegers(String key) {
        Object res = this.fDefaults.get(key);
        if (res != null) {
            return (int[])res;
        }
        return null;
    }

    public long getLong(String key) {
        Object res = this.fDefaults.get(key);
        if (res != null) {
            return (Long)res;
        }
        return 0L;
    }

    public long[] getLongs(String key) {
        Object res = this.fDefaults.get(key);
        if (res != null) {
            return (long[])res;
        }
        return null;
    }

    public String getString(String key) {
        Object res = this.fDefaults.get(key);
        if (res != null) {
            return (String)res;
        }
        return null;
    }

    public String[] getStrings(String key) {
        Object res = this.fDefaults.get(key);
        if (res != null) {
            return (String[])res;
        }
        return null;
    }

    public void putBoolean(String key, boolean value) {
        if (!value) {
            this.delete(key);
        } else {
            this.fDefaults.put(key, (Object)value);
        }
    }

    public void putInteger(String key, int value) {
        if (value == 0) {
            this.delete(key);
        } else {
            this.fDefaults.put(key, (Object)value);
        }
    }

    public void putIntegers(String key, int[] values) {
        if (values == null) {
            this.delete(key);
        } else {
            this.fDefaults.put(key, values);
        }
    }

    public void putLong(String key, long value) {
        if (value == 0L) {
            this.delete(key);
        } else {
            this.fDefaults.put(key, (Object)value);
        }
    }

    public void putLongs(String key, long[] values) {
        if (values == null) {
            this.delete(key);
        } else {
            this.fDefaults.put(key, values);
        }
    }

    public void putString(String key, String value) {
        if (value == null) {
            this.delete(key);
        } else {
            this.fDefaults.put(key, value);
        }
    }

    public void putStrings(String key, String[] values) {
        if (values == null) {
            this.delete(key);
        } else {
            this.fDefaults.put(key, values);
        }
    }
}

