/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.pref;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;

public class EntityScope
implements IPreferenceScope {
    private final IEntity fEntity;
    private final IPreferenceScope fParent;

    public EntityScope(IEntity entity, IPreferenceScope parent) {
        Assert.isNotNull((Object)entity, (String)"entity cannot be null");
        this.fEntity = entity;
        this.fParent = parent;
    }

    public IPreferenceScope getParent() {
        return this.fParent;
    }

    public void flush() {
        DynamicDAO.save(this.fEntity);
    }

    public void delete(String key) {
        this.fEntity.removeProperty(key);
    }

    public boolean hasKey(String key) {
        return this.fEntity.getProperty(key) != null;
    }

    public boolean getBoolean(String key) {
        Object prop = this.fEntity.getProperty(key);
        if (prop != null) {
            return (Boolean)prop;
        }
        return this.fParent.getBoolean(key);
    }

    public int getInteger(String key) {
        Object prop = this.fEntity.getProperty(key);
        if (prop != null) {
            return (Integer)prop;
        }
        return this.fParent.getInteger(key);
    }

    public int[] getIntegers(String key) {
        Object prop = this.fEntity.getProperty(key);
        if (prop != null) {
            return (int[])prop;
        }
        return this.fParent.getIntegers(key);
    }

    public long getLong(String key) {
        Object prop = this.fEntity.getProperty(key);
        if (prop != null) {
            return (Long)prop;
        }
        return this.fParent.getLong(key);
    }

    public long[] getLongs(String key) {
        Object prop = this.fEntity.getProperty(key);
        if (prop != null) {
            return (long[])prop;
        }
        return this.fParent.getLongs(key);
    }

    public String getString(String key) {
        Object prop = this.fEntity.getProperty(key);
        if (prop != null) {
            return (String)prop;
        }
        return this.fParent.getString(key);
    }

    public String[] getStrings(String key) {
        Object prop = this.fEntity.getProperty(key);
        if (prop != null) {
            return (String[])prop;
        }
        return this.fParent.getStrings(key);
    }

    public void putBoolean(String key, boolean value) {
        if (value != this.fParent.getBoolean(key)) {
            this.fEntity.setProperty(key, Boolean.valueOf(value));
        } else {
            this.delete(key);
        }
    }

    public void putInteger(String key, int value) {
        if (value != this.fParent.getInteger(key)) {
            this.fEntity.setProperty(key, Integer.valueOf(value));
        } else {
            this.delete(key);
        }
    }

    public void putIntegers(String key, int[] values) {
        Assert.isNotNull((Object)values);
        if (!Arrays.equals(values, this.fParent.getIntegers(key))) {
            this.fEntity.setProperty(key, (Serializable)values);
        } else {
            this.delete(key);
        }
    }

    public void putLong(String key, long value) {
        if (value != this.fParent.getLong(key)) {
            this.fEntity.setProperty(key, Long.valueOf(value));
        } else {
            this.delete(key);
        }
    }

    public void putLongs(String key, long[] values) {
        Assert.isNotNull((Object)values);
        if (!Arrays.equals(values, this.fParent.getLongs(key))) {
            this.fEntity.setProperty(key, (Serializable)values);
        } else {
            this.delete(key);
        }
    }

    public void putString(String key, String value) {
        Assert.isNotNull((Object)value);
        if (!value.equals(this.fParent.getString(key))) {
            this.fEntity.setProperty(key, (Serializable)((Object)value));
        } else {
            this.delete(key);
        }
    }

    public void putStrings(String key, String[] values) {
        Assert.isNotNull((Object)values);
        if (!Arrays.equals(values, this.fParent.getStrings(key))) {
            this.fEntity.setProperty(key, (Serializable)values);
        } else {
            this.delete(key);
        }
    }
}

