/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.service;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.persist.pref.DefaultScope;
import org.rssowl.core.internal.persist.pref.EclipseScope;
import org.rssowl.core.internal.persist.pref.EntityScope;
import org.rssowl.core.internal.persist.pref.GlobalScope;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.pref.IPreferencesInitializer;
import org.rssowl.core.persist.service.IPreferenceService;

public class PreferenceServiceImpl
implements IPreferenceService {
    private static final String PREFERENCES_INITIALIZER_EXTENSION_POINT = "org.rssowl.core.PreferencesInitializer";
    private final IPreferenceScope fDefaultScope = new DefaultScope();
    private final IPreferenceScope fGlobalScope = new GlobalScope(this.fDefaultScope);
    private final IPreferenceScope fEclipseScope = new EclipseScope(this.fDefaultScope);

    public PreferenceServiceImpl() {
        this.initScopedPreferences();
    }

    public IPreferenceScope getDefaultScope() {
        return this.fDefaultScope;
    }

    public IPreferenceScope getGlobalScope() {
        return this.fGlobalScope;
    }

    public IPreferenceScope getEclipseScope() {
        return this.fEclipseScope;
    }

    public IPreferenceScope getEntityScope(IEntity entity) {
        return new EntityScope(entity, this.fGlobalScope);
    }

    private void initScopedPreferences() {
        IConfigurationElement[] elements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(PREFERENCES_INITIALIZER_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                IPreferencesInitializer initializer = (IPreferencesInitializer)element.createExecutableExtension("class");
                initializer.initialize(this.fDefaultScope);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }
}

