/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.rssowl.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchedBuffer<T> {
    private final int fBatchInterval;
    private final List<T> fBuffer;
    private final Job fBufferProcessor;
    private final Receiver<T> fReceiver;
    private final AtomicBoolean fSealed = new AtomicBoolean(false);
    private final AtomicBoolean fRunning = new AtomicBoolean(false);

    public BatchedBuffer(Receiver<T> receiver, int batchInterval) {
        this(receiver, batchInterval, null);
    }

    public BatchedBuffer(Receiver<T> receiver, int batchInterval, String taskName) {
        this.fReceiver = receiver;
        this.fBatchInterval = batchInterval;
        this.fBuffer = new ArrayList<T>();
        this.fBufferProcessor = this.createBufferProcessor(taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<T> objects) {
        if (objects.isEmpty() || this.fSealed.get()) {
            return;
        }
        List<T> list = this.fBuffer;
        synchronized (list) {
            if (this.fSealed.get()) {
                return;
            }
            if (this.fBuffer.isEmpty()) {
                this.fBuffer.addAll(objects);
                this.fBufferProcessor.schedule((long)this.fBatchInterval);
            } else {
                for (T object : objects) {
                    if (this.fBuffer.contains(object)) continue;
                    this.fBuffer.add(object);
                }
            }
        }
    }

    public void cancel(boolean joinRunning) {
        this.fSealed.set(true);
        if (joinRunning) {
            if (this.isScheduled() && !this.isRunning()) {
                this.fBufferProcessor.cancel();
                this.fBufferProcessor.schedule();
            }
            while (this.isScheduled()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        } else {
            this.fBufferProcessor.cancel();
        }
    }

    public boolean isScheduled() {
        return this.isRunning() || Job.getJobManager().find((Object)this).length != 0;
    }

    public boolean isRunning() {
        return this.fRunning.get();
    }

    private Job createBufferProcessor(String taskName) {
        Job job = new Job(taskName != null ? taskName : ""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                BatchedBuffer.this.fRunning.set(true);
                try {
                    IStatus status;
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    List list = BatchedBuffer.this.fBuffer;
                    synchronized (list) {
                        status = BatchedBuffer.this.fReceiver.receive(new ArrayList(BatchedBuffer.this.fBuffer), this, monitor);
                        BatchedBuffer.this.fBuffer.clear();
                    }
                    IStatus iStatus = status;
                    return iStatus;
                }
                finally {
                    BatchedBuffer.this.fRunning.set(false);
                }
            }

            public boolean belongsTo(Object family) {
                return family == BatchedBuffer.this;
            }
        };
        if (!StringUtils.isSet(taskName)) {
            job.setSystem(true);
            job.setUser(false);
        }
        return job;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Receiver<T> {
        public IStatus receive(Collection<T> var1, Job var2, IProgressMonitor var3);
    }
}

