/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetentionStrategy {
    private static final long DAY = 86400000L;

    public static void process(IFolder folder) {
        ArrayList<INews> newsToDelete = new ArrayList<INews>();
        RetentionStrategy.internalProcess(folder, newsToDelete);
        if (newsToDelete.size() > 0 && !Owl.isShuttingDown()) {
            Owl.getPersistenceService().getDAOService().getNewsDAO().setState(newsToDelete, INews.State.DELETED, false, false);
        }
    }

    private static void internalProcess(IFolder folder, List<INews> newsToDelete) throws PersistenceException {
        List<IFolderChild> childs = folder.getChildren();
        for (IFolderChild child : childs) {
            if (child instanceof IBookMark) {
                IBookMark bookmark = (IBookMark)child;
                if (!RetentionStrategy.requiresRetention(bookmark)) continue;
                List<INews> visibleNews = bookmark.getFeedLinkReference().resolve().getVisibleNews();
                newsToDelete.addAll(RetentionStrategy.getNewsToDelete(bookmark, visibleNews));
                continue;
            }
            if (!(child instanceof IFolder)) continue;
            RetentionStrategy.internalProcess((IFolder)child, newsToDelete);
        }
    }

    private static boolean requiresRetention(IBookMark bookmark) {
        IPreferenceScope prefs = Owl.getPreferenceService().getEntityScope(bookmark);
        return prefs.getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE) || prefs.getBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE) || prefs.getBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE);
    }

    public static void process(IBookMark bookmark) {
        IFeed feed;
        if (RetentionStrategy.requiresRetention(bookmark) && (feed = bookmark.getFeedLinkReference().resolve()) != null) {
            RetentionStrategy.process(bookmark, feed.getVisibleNews());
        }
    }

    public static List<INews> process(IBookMark bookmark, Collection<INews> news) {
        List<INews> newsToDelete = RetentionStrategy.getNewsToDelete(bookmark, news);
        if (newsToDelete.size() > 0 && !Owl.isShuttingDown()) {
            Owl.getPersistenceService().getDAOService().getNewsDAO().setState(newsToDelete, INews.State.DELETED, false, false);
        }
        return newsToDelete;
    }

    public static List<INews> process(IBookMark bookmark, IFeed feed) {
        List<INews> newsToDelete = RetentionStrategy.getNewsToDelete(bookmark, feed.getVisibleNews());
        for (INews news : newsToDelete) {
            news.setState(INews.State.DELETED);
        }
        return newsToDelete;
    }

    private static List<INews> getNewsToDelete(IBookMark bookmark, Collection<INews> targetNews) {
        ArrayList<INews> newsToDelete = new ArrayList<INews>();
        IPreferenceScope prefs = Owl.getPreferenceService().getEntityScope(bookmark);
        boolean keepUnread = prefs.getBoolean(DefaultPreferences.NEVER_DEL_UNREAD_NEWS_STATE);
        boolean keepLabeled = prefs.getBoolean(DefaultPreferences.NEVER_DEL_LABELED_NEWS_STATE);
        if (prefs.getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE)) {
            RetentionStrategy.fillReadNewsToDelete(targetNews, newsToDelete, keepUnread, keepLabeled);
        }
        if (prefs.getBoolean(DefaultPreferences.DEL_NEWS_BY_AGE_STATE)) {
            RetentionStrategy.fillNewsToDeleteByAge(targetNews, newsToDelete, prefs.getInteger(DefaultPreferences.DEL_NEWS_BY_AGE_VALUE), keepUnread, keepLabeled);
        }
        if (prefs.getBoolean(DefaultPreferences.DEL_NEWS_BY_COUNT_STATE)) {
            RetentionStrategy.fillNewsToDeleteByCount(targetNews, newsToDelete, prefs.getInteger(DefaultPreferences.DEL_NEWS_BY_COUNT_VALUE), keepUnread, keepLabeled);
        }
        return newsToDelete;
    }

    private static void fillReadNewsToDelete(Collection<INews> targetNews, List<INews> newsToDelete, boolean keepUnread, boolean keepLabeled) {
        for (INews newsItem : targetNews) {
            if (RetentionStrategy.shouldKeep(newsItem, keepUnread, keepLabeled) || newsItem.getState() != INews.State.READ) continue;
            newsToDelete.add(newsItem);
        }
    }

    private static void fillNewsToDeleteByAge(Collection<INews> targetNews, List<INews> newsToDelete, int days, boolean keepUnread, boolean keepLabeled) {
        long maxAge = DateUtils.getToday().getTimeInMillis() - (long)days * 86400000L;
        for (INews newsItem : targetNews) {
            if (RetentionStrategy.shouldKeep(newsItem, keepUnread, keepLabeled) || newsToDelete.contains(newsItem) || DateUtils.getRecentDate(newsItem).getTime() >= maxAge) continue;
            newsToDelete.add(newsItem);
        }
    }

    private static boolean shouldKeep(INews news, boolean keepUnread, boolean keepLabeled) {
        if (news.isFlagged() || news.getState() == INews.State.NEW) {
            return true;
        }
        INews.State state = news.getState();
        if (keepUnread && (state == INews.State.UPDATED || state == INews.State.UNREAD)) {
            return true;
        }
        return keepLabeled && !news.getLabels().isEmpty();
    }

    private static void fillNewsToDeleteByCount(Collection<INews> targetNews, List<INews> newsToDelete, int limit, boolean keepUnread, boolean keepLabeled) {
        int actualSize = targetNews.size() - newsToDelete.size();
        if (actualSize <= limit) {
            return;
        }
        INews[] newsArray = new INews[actualSize];
        int i = 0;
        for (INews news : targetNews) {
            if (newsToDelete.contains(news)) continue;
            newsArray[i] = news;
            ++i;
        }
        Arrays.sort(newsArray, new Comparator<INews>(){

            @Override
            public int compare(INews news1, INews news2) {
                return DateUtils.getRecentDate(news1).compareTo(DateUtils.getRecentDate(news2));
            }
        });
        int toDeleteValue = actualSize - limit;
        int deletedCounter = 0;
        i = 0;
        while (i < newsArray.length && deletedCounter != toDeleteValue) {
            if (!RetentionStrategy.shouldKeep(newsArray[i], keepUnread, keepLabeled)) {
                newsToDelete.add(newsArray[i]);
                ++deletedCounter;
            }
            ++i;
        }
    }
}

