/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIDefaultAuthInfoImpl;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIClsid;
import org.jinterop.dcom.core.JIComObjectImpl;
import org.jinterop.dcom.core.JIFrameworkHelper;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIOxidResolver;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JIRemActivation;
import org.jinterop.dcom.core.JIRemUnknown;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIStdObjRef;
import org.jinterop.dcom.core.JIStringBinding;
import org.jinterop.dcom.transport.JIComEndpoint;
import org.jinterop.dcom.transport.JIComTransportFactory;
import org.jinterop.winreg.IJIWinReg;
import org.jinterop.winreg.JIPolicyHandle;
import org.jinterop.winreg.JIWinRegFactory;
import rpc.FaultException;
import rpc.Stub;
import rpc.core.UUID;

public final class JIComServer
extends Stub {
    private static Properties defaults = new Properties();
    private JIRemActivation remoteActivation = null;
    private JIOxidResolver oxidResolver = null;
    private String clsid = null;
    private String syntax = null;
    private JISession session = null;
    private boolean serverInstantiated = false;
    private String remunknownIPID = null;
    private final Object mutex = new Object();
    private boolean timeoutModifiedfrom0 = false;
    private JIInterfacePointer interfacePtrCtor = null;

    static {
        ((Hashtable)defaults).put("rpc.ntlm.lanManagerKey", "false");
        ((Hashtable)defaults).put("rpc.ntlm.sign", "false");
        ((Hashtable)defaults).put("rpc.ntlm.seal", "false");
        ((Hashtable)defaults).put("rpc.ntlm.keyExchange", "false");
        ((Hashtable)defaults).put("rpc.connectionContext", "rpc.security.ntlm.NtlmConnectionContext");
        ((Hashtable)defaults).put("rpc.socketTimeout", new Integer(0).toString());
    }

    private JIComServer() {
    }

    JIComServer(JISession session, JIInterfacePointer interfacePointer, String ipAddress) throws JIException {
        if (interfacePointer == null || session == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4109));
        }
        if (session.getStub() != null) {
            throw new JIException(4099);
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.internal_dumpMap();
        }
        super.setTransportFactory(JIComTransportFactory.getSingleTon());
        super.setProperties(new Properties(defaults));
        super.getProperties().setProperty("rpc.security.username", session.getUserName());
        super.getProperties().setProperty("rpc.security.password", session.getPassword());
        super.getProperties().setProperty("rpc.ntlm.domain", session.getDomain());
        super.getProperties().setProperty("rpc.socketTimeout", new Integer(session.getGlobalSocketTimeout()).toString());
        JIStringBinding[] addressBindings = interfacePointer.getStringBindings().getStringBindings();
        int i = 0;
        JIStringBinding binding = null;
        JIStringBinding nameBinding = null;
        String targetAddress = ipAddress == null ? "" : ipAddress.trim();
        while (i < addressBindings.length) {
            block27: {
                binding = addressBindings[i];
                if (binding.getTowerId() != 7) {
                    ++i;
                    continue;
                }
                int index = binding.getNetworkAddress().indexOf(".");
                if (index != -1) {
                    try {
                        if (binding.getNetworkAddress().equalsIgnoreCase(targetAddress)) {
                            nameBinding = null;
                            break;
                        }
                        index = binding.getNetworkAddress().indexOf("[");
                        if (index != -1 && binding.getNetworkAddress().substring(0, index).equalsIgnoreCase(targetAddress)) {
                            nameBinding = null;
                            break;
                        }
                        break block27;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break block27;
                    }
                }
                nameBinding = binding;
            }
            ++i;
        }
        binding = nameBinding == null ? binding : nameBinding;
        String address = binding.getNetworkAddress();
        if (address.indexOf("[") == -1) {
            String ipAddr = JISystem.getIPForHostName(address);
            if (ipAddr != null) {
                address = ipAddr;
            }
            address = String.valueOf(address) + "[135]";
        } else {
            int index = address.indexOf("[");
            String hostname = binding.getNetworkAddress().substring(0, index);
            String ipAddr = JISystem.getIPForHostName(hostname);
            if (ipAddr != null) {
                address = String.valueOf(ipAddr) + address.substring(index);
            }
        }
        super.setAddress("ncacn_ip_tcp:" + address);
        this.session = session;
        this.session.setTargetServer(this.getAddress().substring(this.getAddress().indexOf(":") + 1, this.getAddress().indexOf("[")));
        this.oxidResolver = new JIOxidResolver(((JIStdObjRef)interfacePointer.getObjectReference(1)).getOxid());
        try {
            this.syntax = "99fcfec4-5260-101b-bbcb-00aa0021347a:0.0";
            this.attach();
            this.getEndpoint().getSyntax().setUuid(new UUID("99fcfec4-5260-101b-bbcb-00aa0021347a"));
            this.getEndpoint().getSyntax().setVersion(0, 0);
            ((JIComEndpoint)this.getEndpoint()).rebindEndPoint();
            this.call(2, this.oxidResolver);
        }
        catch (FaultException e) {
            throw new JIException(e.status, (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e1) {
            throw new JIException(e1);
        }
        this.syntax = String.valueOf(interfacePointer.getIID()) + ":0.0";
        JIStringBinding[] bindings = this.oxidResolver.getOxidBindings().getStringBindings();
        binding = null;
        nameBinding = null;
        i = 0;
        while (i < bindings.length) {
            block28: {
                binding = bindings[i];
                if (binding.getTowerId() != 7) {
                    ++i;
                    continue;
                }
                int index = binding.getNetworkAddress().indexOf(".");
                if (index != -1) {
                    try {
                        if (binding.getNetworkAddress().equalsIgnoreCase(targetAddress)) {
                            nameBinding = null;
                            break;
                        }
                        index = binding.getNetworkAddress().indexOf("[");
                        if (index != -1 && binding.getNetworkAddress().substring(0, index).equalsIgnoreCase(targetAddress)) {
                            nameBinding = null;
                            break;
                        }
                        break block28;
                    }
                    catch (NumberFormatException ipAddr) {
                        break block28;
                    }
                }
                nameBinding = binding;
            }
            ++i;
        }
        JIStringBinding jIStringBinding = binding = nameBinding == null ? binding : nameBinding;
        if (session.isSessionSecurityEnabled()) {
            super.getProperties().setProperty("rpc.ntlm.seal", "true");
            super.getProperties().setProperty("rpc.ntlm.sign", "true");
            super.getProperties().setProperty("rpc.ntlm.keyExchange", "true");
            super.getProperties().setProperty("rpc.ntlm.keyLength", "128");
            super.getProperties().setProperty("rpc.ntlm.ntlm2", "true");
        }
        address = binding.getNetworkAddress();
        int index = address.indexOf("[");
        String hostname = binding.getNetworkAddress().substring(0, index);
        String ipAddr = JISystem.getIPForHostName(hostname);
        if (ipAddr != null) {
            address = String.valueOf(ipAddr) + address.substring(index);
        }
        this.setAddress("ncacn_ip_tcp:" + address);
        this.remunknownIPID = this.oxidResolver.getIPID();
        this.interfacePtrCtor = interfacePointer;
        this.session.setStub(this);
    }

    public JIComServer(JIProgId progId, JISession session) throws JIException, UnknownHostException {
        this(progId, InetAddress.getLocalHost().getHostAddress(), session);
    }

    public JIComServer(JIClsid clsid, JISession session) throws IllegalArgumentException, JIException, UnknownHostException {
        this(clsid, InetAddress.getLocalHost().getHostAddress(), session);
    }

    public JIComServer(JIProgId progId, String address, JISession session) throws JIException, UnknownHostException {
        if (progId == null || address == null || session == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4109));
        }
        if (session.getStub() != null) {
            throw new JIException(4099);
        }
        address = address.trim();
        address = InetAddress.getByName(address).getHostAddress();
        progId.setSession(session);
        progId.setServer(address);
        address = "ncacn_ip_tcp:" + address + "[135]";
        JIClsid clsid = progId.getCorrespondingCLSID();
        this.initialise(clsid, address, session);
    }

    public JIComServer(JIClsid clsid, String address, JISession session) throws JIException, UnknownHostException {
        if (clsid == null || address == null || session == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4109));
        }
        if (session.getStub() != null) {
            throw new JIException(4099);
        }
        address = address.trim();
        address = "ncacn_ip_tcp:" + InetAddress.getByName(address).getHostAddress() + "[135]";
        this.initialise(clsid, address, session);
    }

    private void initialise(JIClsid clsid, String address, JISession session) throws JIException {
        super.setTransportFactory(JIComTransportFactory.getSingleTon());
        super.setProperties(new Properties(defaults));
        super.getProperties().setProperty("rpc.security.username", session.getUserName());
        super.getProperties().setProperty("rpc.security.password", session.getPassword());
        super.getProperties().setProperty("rpc.ntlm.domain", session.getDomain());
        super.getProperties().setProperty("rpc.socketTimeout", new Integer(session.getGlobalSocketTimeout()).toString());
        super.setAddress(address);
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.internal_dumpMap();
        }
        this.clsid = clsid.getCLSID().toUpperCase();
        this.session = session;
        this.session.setTargetServer(address.substring(address.indexOf(":") + 1, address.indexOf("[")));
        try {
            this.init();
        }
        catch (JIException e) {
            if (e.getErrorCode() == -2147221164) {
                if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                    JISystem.getLogger().warning("Got the class not registered exception , will attempt setting entries based on status flags...");
                }
                if (JISystem.isAutoRegistrationSet() || clsid.isAutoRegistrationSet()) {
                    try {
                        IJIWinReg registry = null;
                        registry = JIWinRegFactory.getSingleTon().getWinreg(new JIDefaultAuthInfoImpl(session.getDomain(), session.getUserName(), session.getPassword()), session.getTargetServer(), true);
                        JIPolicyHandle hkcr = registry.winreg_OpenHKCR();
                        JIPolicyHandle key = registry.winreg_CreateKey(hkcr, "CLSID\\{" + this.clsid + "}", 0, 983103);
                        registry.winreg_SetValue(key, "AppID", ("{" + this.clsid + "}").getBytes(), false, false);
                        registry.winreg_CloseKey(key);
                        key = registry.winreg_CreateKey(hkcr, "AppID\\{" + this.clsid + "}", 0, 983103);
                        registry.winreg_SetValue(key, "DllSurrogate", "  ".getBytes(), false, false);
                        registry.winreg_CloseKey(key);
                        registry.winreg_CloseKey(hkcr);
                        registry.closeConnection();
                    }
                    catch (UnknownHostException e1) {
                        JISystem.getLogger().throwing("JIComServer", "initialise", e1);
                        throw new JIException(4148, (Throwable)e1);
                    }
                    this.init();
                }
                throw e;
            }
            throw e;
        }
        this.session.setStub(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() throws JIException {
        block20: {
            if (this.remoteActivation != null && this.remoteActivation.isActivationSuccessful()) {
                return;
            }
            attachcomplete = false;
            try {
                try {
                    this.syntax = "99fcfec4-5260-101b-bbcb-00aa0021347a:0.0";
                    this.attach();
                    attachcomplete = true;
                    this.getEndpoint().getSyntax().setUuid(new UUID("99fcfec4-5260-101b-bbcb-00aa0021347a"));
                    this.getEndpoint().getSyntax().setVersion(0, 0);
                    ((JIComEndpoint)this.getEndpoint()).rebindEndPoint();
                    this.syntax = "4d9f4ab8-7d1c-11cf-861e-0020af6e7c57:0.0";
                    this.getEndpoint().getSyntax().setUuid(new UUID("4d9f4ab8-7d1c-11cf-861e-0020af6e7c57"));
                    this.getEndpoint().getSyntax().setVersion(0, 0);
                    ((JIComEndpoint)this.getEndpoint()).rebindEndPoint();
                    this.remoteActivation = new JIRemActivation(this.clsid);
                    this.call(2, this.remoteActivation);
                }
                catch (FaultException e) {
                    this.remoteActivation = null;
                    throw new JIException(e.status, (Throwable)e);
                }
                catch (IOException e) {
                    this.remoteActivation = null;
                    throw new JIException(-2147352577, (Throwable)e);
                }
                catch (JIRuntimeException e1) {
                    this.remoteActivation = null;
                    throw new JIException(e1);
                }
            }
            catch (Throwable var4_6) {
                var3_8 = null;
                if (attachcomplete == false) throw var4_6;
                if (this.remoteActivation != null) throw var4_6;
                try {
                    this.detach();
                    throw var4_6;
                }
                catch (IOException e) {
                    if (JISystem.getLogger().isLoggable(Level.WARNING) == false) throw var4_6;
                    JISystem.getLogger().warning("Unable to detach during init: " + e);
                }
                throw var4_6;
            }
            {
                var3_9 = null;
                if (!attachcomplete || this.remoteActivation != null) break block20;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 231->238)] { 
lbl43:
            // 1 sources

            this.detach();
            break block20;
lbl45:
            // 1 sources

            catch (IOException e) {
                if (!JISystem.getLogger().isLoggable(Level.WARNING)) break block20;
                JISystem.getLogger().warning("Unable to detach during init: " + e);
            }
        }
        this.syntax = "00000143-0000-0000-c000-000000000046:0.0";
        bindings = this.remoteActivation.getDualStringArrayForOxid().getStringBindings();
        i = 0;
        binding = null;
        nameBinding = null;
        targetAddress = this.getAddress();
        targetAddress = targetAddress.substring(targetAddress.indexOf(58) + 1, targetAddress.indexOf(91));
        while (i < bindings.length) {
            block21: {
                binding = bindings[i];
                if (binding.getTowerId() != 7) {
                    ++i;
                    continue;
                }
                index = binding.getNetworkAddress().indexOf(".");
                if (index != -1) {
                    try {
                        index = binding.getNetworkAddress().indexOf("[");
                        if (index != -1 && binding.getNetworkAddress().substring(0, index).equalsIgnoreCase(targetAddress)) {
                            break;
                        }
                        break block21;
                    }
                    catch (NumberFormatException var8_16) {
                        break block21;
                    }
                }
                nameBinding = binding;
                index = binding.getNetworkAddress().indexOf("[");
                if (binding.getNetworkAddress().substring(0, index).equalsIgnoreCase(targetAddress)) break;
            }
            ++i;
        }
        if (binding == null) {
            binding = nameBinding;
        }
        if (this.session.isSessionSecurityEnabled()) {
            super.getProperties().setProperty("rpc.ntlm.seal", "true");
            super.getProperties().setProperty("rpc.ntlm.sign", "true");
            super.getProperties().setProperty("rpc.ntlm.keyExchange", "true");
            super.getProperties().setProperty("rpc.ntlm.keyLength", "128");
            super.getProperties().setProperty("rpc.ntlm.ntlm2", "true");
        }
        address = binding.getNetworkAddress();
        index = address.indexOf("[");
        hostname = binding.getNetworkAddress().substring(0, index);
        ipAddr = JISystem.getIPForHostName(hostname);
        if (ipAddr != null) {
            address = String.valueOf(ipAddr) + address.substring(index);
        }
        this.setAddress("ncacn_ip_tcp:" + address);
        this.remunknownIPID = this.remoteActivation.getIPID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IJIComObject getInterface(String iid, String ipidOfTheTargetUnknown) throws JIException {
        IJIComObject retval = null;
        Object object = this.mutex;
        synchronized (object) {
            this.setObject(this.remunknownIPID);
            JIRemUnknown reqUnknown = new JIRemUnknown(ipidOfTheTargetUnknown, iid);
            try {
                this.call(2, reqUnknown);
            }
            catch (FaultException e) {
                throw new JIException(e.status, (Throwable)e);
            }
            catch (IOException e) {
                throw new JIException(-2147352577, (Throwable)e);
            }
            catch (JIRuntimeException e1) {
                throw new JIException(e1);
            }
            retval = JIFrameworkHelper.instantiateComObject(this.session, reqUnknown.getInterfacePointer());
            retval.addRef();
            if (!iid.equalsIgnoreCase("00020400-0000-0000-c000-000000000046")) {
                boolean success = true;
                ((JIComObjectImpl)retval).setIsDual(true);
                JIRemUnknown dispatch = new JIRemUnknown(retval.getIpid(), "00020400-0000-0000-c000-000000000046");
                try {
                    this.call(2, dispatch);
                }
                catch (FaultException e) {
                    throw new JIException(e.status, (Throwable)e);
                }
                catch (IOException e) {
                    throw new JIException(-2147352577, (Throwable)e);
                }
                catch (JIRuntimeException e1) {
                    ((JIComObjectImpl)retval).setIsDual(false);
                    success = false;
                }
                if (success) {
                    this.session.releaseRef(dispatch.getInterfacePointer().getIPID());
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJIComObject createInstance() throws JIException {
        if (this.interfacePtrCtor != null) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4166));
        }
        IJIComObject comObject = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.serverInstantiated) {
                throw new JIException(4097, null);
            }
            comObject = JIFrameworkHelper.instantiateComObject(this.session, this.remoteActivation.getMInterfacePointer());
            if (this.remoteActivation.isDual) {
                this.session.releaseRef(this.remoteActivation.dispIpid);
                this.remoteActivation.dispIpid = null;
                ((JIComObjectImpl)comObject).setIsDual(true);
            } else {
                ((JIComObjectImpl)comObject).setIsDual(false);
            }
            comObject.addRef();
            this.serverInstantiated = true;
        }
        return comObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IJIComObject getInstance() throws JIException {
        if (this.interfacePtrCtor == null) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4167));
        }
        IJIComObject comObject = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.serverInstantiated) {
                throw new JIException(4097, null);
            }
            comObject = JIFrameworkHelper.instantiateComObject(this.session, this.interfacePtrCtor);
            comObject.addRef();
            this.serverInstantiated = true;
        }
        return comObject;
    }

    protected String getSyntax() {
        return this.syntax;
    }

    Object[] call(JICallBuilder obj, String targetIID) throws JIException {
        return this.call(obj, targetIID, this.session.getGlobalSocketTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] call(JICallBuilder obj, String targetIID, int socketTimeout) throws JIException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.session.isSessionInDestroy() && !obj.fromDestroySession) {
                throw new JIException(4177);
            }
            if (socketTimeout != 0) {
                this.setSocketTimeOut(socketTimeout);
            } else if (this.timeoutModifiedfrom0) {
                this.setSocketTimeOut(socketTimeout);
            }
            try {
                this.attach();
                if (!this.getEndpoint().getSyntax().getUuid().toString().equalsIgnoreCase(targetIID)) {
                    this.getEndpoint().getSyntax().setUuid(new UUID(targetIID));
                    this.getEndpoint().getSyntax().setVersion(0, 0);
                    ((JIComEndpoint)this.getEndpoint()).rebindEndPoint();
                }
                this.setObject(obj.getParentIpid());
                this.call(2, obj);
            }
            catch (FaultException e) {
                throw new JIException(e.status, (Throwable)e);
            }
            catch (IOException e) {
                throw new JIException(-2147352577, (Throwable)e);
            }
            catch (JIRuntimeException e1) {
                throw new JIException(e1);
            }
            return obj.getResults();
        }
    }

    JIInterfacePointer getServerInterfacePointer() {
        return this.remoteActivation == null ? this.interfacePtrCtor : this.remoteActivation.getMInterfacePointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRef_ReleaseRef(JICallBuilder obj) throws JIException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.remunknownIPID == null) {
                return;
            }
            obj.setParentIpid(this.remunknownIPID);
            obj.attachSession(this.session);
            try {
                this.call(obj, "00000143-0000-0000-c000-000000000046");
            }
            catch (JIRuntimeException e1) {
                throw new JIException(e1);
            }
        }
    }

    void closeStub() {
        try {
            this.detach();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void setSocketTimeOut(int timeout) {
        this.timeoutModifiedfrom0 = timeout != 0;
        this.getProperties().setProperty("rpc.socketTimeout", new Integer(timeout).toString());
    }
}

