/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class CharOption
extends Option {
    private char value;

    public CharOption() {
        this(' ');
    }

    public CharOption(CharOption op) {
        super(op);
        op.value = op.getValue();
    }

    public CharOption(char value) {
        this(value, null);
    }

    public CharOption(char value, String longOption) {
        this(value, longOption, '\u0000');
    }

    public CharOption(char value, char shortOption) {
        this(value, null, shortOption);
    }

    public CharOption(char value, String longOption, char shortOption) {
        super(longOption, shortOption);
        this.value = value;
    }

    @Override
    public Object getObject() {
        return new Character(this.value);
    }

    @Override
    public void modify(String value) throws OptionModificationException {
        this.value = (char)(value.length() > 0 ? (int)value.charAt(0) : 32);
    }

    public void setValue(String value) throws OptionModificationException {
        this.modify(value);
    }

    public void setValue(char value) {
        this.value = value;
    }

    public char getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return "" + this.value;
    }

    @Override
    public String getTypeName() {
        return "CHAR";
    }

    public String toString() {
        return this.getStringValue();
    }
}

