/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.OptionModifiable;
import gnu.dtools.ritopt.Utility;

public abstract class Option
implements OptionModifiable {
    public static final int DEFAULT_HELP_OPTION_SIZE = 22;
    public static final int DEFAULT_HELP_TYPENAME_SIZE = 10;
    public static final int DEFAULT_HELP_DESCRIPTION_SIZE = 48;
    public static final int DEFAULT_HELP_DEPRECATED_SIZE = 3;
    public static final int DEFAULT_MENU_OPTION_SIZE = 15;
    public static final int DEFAULT_MENU_TYPENAME_SIZE = 10;
    public static final int DEFAULT_MENU_DESCRIPTION_SIZE = 48;
    public static final int DEFAULT_MENU_DEPRECATED_SIZE = 3;
    public static final int DEFAULT_FILE_COMPLETE_OPTION_SIZE = 60;
    public static final int DEFAULT_FILE_COMMENT_SIZE = 16;
    private String longOption;
    private char shortOption;
    private String description;
    private boolean deprecated;
    private static int helpOptionSpecificationSize = 22;
    private static int helpTypenameSize = 10;
    private static int helpDescriptionSize = 48;
    private static int helpDeprecatedSize = 3;
    private static int menuOptionSpecificationSize = 15;
    private static int menuTypenameSize = 10;
    private static int menuDescriptionSize = 48;
    private static int menuDeprecatedSize = 3;
    private static int fileCompleteOptionSize = 60;
    private static int fileCommentSize = 16;
    protected boolean invoked;

    public abstract Object getObject();

    public abstract String getStringValue();

    public Option() {
        this.description = "";
    }

    public Option(Option option) {
        this.longOption = option.getLongOption();
        this.shortOption = option.getShortOption();
        this.description = option.getDescription();
        this.deprecated = option.isDeprecated();
    }

    public Option(String longOption) {
        this.longOption = longOption;
        this.shortOption = '\u0000';
        this.description = "";
    }

    public Option(char shortOption) {
        this.shortOption = shortOption;
        this.longOption = null;
        this.description = "";
    }

    public Option(String longOption, char shortOption) {
        this.longOption = longOption;
        this.shortOption = shortOption;
        this.description = "";
    }

    public void setKey(String longOption) {
        this.longOption = longOption;
    }

    public void setKey(char shortOption) {
        this.shortOption = shortOption;
    }

    public void setShortOption(char shortOption) {
        this.setKey(shortOption);
    }

    public void setLongOption(String longOption) {
        this.setKey(longOption);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public static void setHelpOptionSpecificationSize(int newSize) {
        helpOptionSpecificationSize = newSize;
    }

    public static void setHelpTypenameSize(int newSize) {
        helpTypenameSize = newSize;
    }

    public static void setHelpDescriptionSize(int newSize) {
        helpDescriptionSize = newSize;
    }

    public static void setHelpDeprecatedSize(int newSize) {
        helpDeprecatedSize = newSize;
    }

    public static void setMenuOptionSpecificationSize(int newSize) {
        menuOptionSpecificationSize = newSize;
    }

    public static void setMenuTypenameSize(int newSize) {
        menuTypenameSize = newSize;
    }

    public static void setMenuDescriptionSize(int newSize) {
        menuDescriptionSize = newSize;
    }

    public static void setMenuDeprecatedSize(int newSize) {
        menuDeprecatedSize = newSize;
    }

    public static void setFileCompleteOptionSize(int newSize) {
        fileCompleteOptionSize = newSize;
    }

    public static void setFileCommentSize(int newSize) {
        fileCommentSize = newSize;
    }

    public void setInvoked(boolean b) {
        this.invoked = b;
    }

    public void deprecate() {
        this.setDeprecated(true);
    }

    public String getName() {
        return this.longOption;
    }

    public char getShortOption() {
        return this.shortOption;
    }

    public String getLongOption() {
        return this.longOption;
    }

    public String getHelp() {
        return this.getHelpOptionSpecification() + " " + this.getHelpTypeName() + " " + this.getHelpDescription() + " " + this.getHelpDeprecated();
    }

    public String getHelpOptionSpecification() {
        return Utility.expandString((this.shortOption != '\u0000' ? "-" + this.getShortOption() : "  ") + (this.longOption != null && this.shortOption != '\u0000' ? ", " : "  ") + (this.longOption != null ? "--" + this.getLongOption() : ""), helpOptionSpecificationSize);
    }

    public String getHelpTypeName() {
        return Utility.expandString("<" + this.getTypeName() + ">", helpTypenameSize);
    }

    public String getHelpDescription() {
        return Utility.expandString(this.getDescription(), helpDescriptionSize);
    }

    public String getHelpDeprecated() {
        return Utility.expandString(this.isDeprecated() ? "[d]" : "", helpDeprecatedSize);
    }

    public static String getHelpHeader() {
        return Utility.expandString("Option Name", helpOptionSpecificationSize) + " " + Utility.expandString("Type", helpTypenameSize) + " " + Utility.expandString("Description", helpDescriptionSize);
    }

    public String getDescription() {
        return this.description;
    }

    public String getHashKey() {
        return Option.getHashKey(this.longOption, this.shortOption);
    }

    public static String getHashKey(String longOption) {
        return "," + (longOption != null ? longOption : "");
    }

    public static String getHashKey(char shortOption) {
        return "" + (shortOption != '\u0000') + ",";
    }

    public static String getHashKey(String longOption, char shortOption) {
        return (shortOption == '\u0000' ? "" : "" + shortOption) + (longOption == null ? "," : "," + longOption);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isInvoked() {
        return this.invoked;
    }

    public String getOptionFileLine() {
        boolean descriptionPrinted = false;
        String retval = "";
        String optionText = "";
        String strval = this.getStringValue();
        if (this.longOption != null) {
            optionText = optionText + "--" + this.longOption;
        } else if (this.shortOption != '\u0000') {
            optionText = optionText + "-" + this.shortOption;
        }
        if (optionText.length() > 0 && Utility.trim(strval).length() >= 0) {
            optionText = optionText + "=" + strval;
        }
        if (optionText.length() <= fileCompleteOptionSize) {
            retval = retval + Utility.expandString(optionText, fileCompleteOptionSize);
        } else {
            retval = retval + "; " + this.description + "\n";
            retval = retval + optionText;
            descriptionPrinted = true;
        }
        if (!descriptionPrinted) {
            StringBuffer descsplit = new StringBuffer(this.description);
            boolean tmp = false;
            while (descsplit.length() > 0) {
                String st = "";
                int size = 0;
                if (tmp) {
                    st = st + Utility.getSpaces(fileCompleteOptionSize);
                }
                size = descsplit.length() >= fileCommentSize ? fileCommentSize : descsplit.length();
                st = st + "; " + descsplit.substring(0, size);
                descsplit.delete(0, size);
                retval = retval + st + "\n";
                tmp = true;
            }
            descriptionPrinted = true;
        }
        return retval;
    }

    public static int getHelpOptionSpecificationSize() {
        return helpOptionSpecificationSize;
    }

    public static int getHelpTypenameSize() {
        return helpTypenameSize;
    }

    public static int getHelpDescriptionSize() {
        return helpDescriptionSize;
    }

    public static int getHelpDeprecatedSize() {
        return helpDeprecatedSize;
    }

    public static int getMenuOptionSpecificationSize() {
        return menuOptionSpecificationSize;
    }

    public static int getMenuTypenameSize() {
        return menuTypenameSize;
    }

    public static int getMenuDescriptionSize() {
        return menuDescriptionSize;
    }

    public static int getMenuDeprecatedSize() {
        return menuDeprecatedSize;
    }

    public static int getFileCompleteOptionSize() {
        return fileCompleteOptionSize;
    }

    public static int getFileCommentSize() {
        return fileCommentSize;
    }

    public abstract String getTypeName();

    public void action() {
        if (this.deprecated) {
            System.err.print("Warning: ");
            if (this.longOption != null) {
                System.err.print("--" + this.longOption);
            }
            if (this.shortOption != '\u0000' && this.longOption != null) {
                System.err.print(" or ");
            }
            if (this.shortOption != '\u0000') {
                System.err.println("-" + this.shortOption + " is deprecated.");
            }
        }
    }
}

