/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.layout.Sizes;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import net.sf.jabref.BasePanel;
import net.sf.jabref.ContentSelectorDialog2;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;

public class FieldContentSelector
extends JComponent {
    JComboBox comboBox;
    FieldEditor editor;
    MetaData metaData;
    JabRefFrame frame;
    Window owner;
    BasePanel panel;
    private AbstractAction action;
    String delimiter;

    public FieldContentSelector(JabRefFrame frame, final BasePanel panel, Window owner, final FieldEditor editor, final MetaData metaData, AbstractAction action, boolean horizontalLayout, String delimiter) {
        this.frame = frame;
        this.editor = editor;
        this.metaData = metaData;
        this.panel = panel;
        this.owner = owner;
        this.action = action;
        this.delimiter = delimiter;
        this.comboBox = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                Dimension parents = super.getPreferredSize();
                if (parents.width > 240) {
                    parents.width = 240;
                }
                return parents;
            }
        };
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        this.setLayout(gbl);
        this.comboBox.setMaximumRowCount(35);
        this.comboBox.putClientProperty("ComboBox.popupPrototypeDisplayValue", "The longest text in the combo popup menu. And even longer.");
        this.rebuildComboBox();
        con.gridwidth = horizontalLayout ? 3 : 0;
        con.fill = 2;
        con.weightx = 1.0;
        gbl.setConstraints(this.comboBox, con);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("comboBoxChanged") && e.getModifiers() == 0) {
                    return;
                }
                FieldContentSelector.this.selectionMade();
            }
        });
        this.comboBox.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.comboBox.getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FieldContentSelector.this.selectionMade();
                FieldContentSelector.this.comboBox.setPopupVisible(false);
            }
        });
        this.add(this.comboBox);
        if (horizontalLayout) {
            this.add(Box.createHorizontalStrut(Sizes.dialogUnitXAsPixel(2, this)));
        }
        JButton manage = new JButton(Globals.lang("Manage"));
        gbl.setConstraints(manage, con);
        this.add(manage);
        manage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentSelectorDialog2 csd = new ContentSelectorDialog2(FieldContentSelector.this.owner, FieldContentSelector.this.frame, panel, true, metaData, editor.getFieldName());
                Util.placeDialog(csd, FieldContentSelector.this.frame);
                csd.setVisible(true);
                FieldContentSelector.this.rebuildComboBox();
            }
        });
    }

    private void selectionMade() {
        if (this.comboBox.getSelectedIndex() == 0) {
            return;
        }
        String chosen = (String)this.comboBox.getSelectedItem();
        if (chosen == null || chosen.equals("")) {
            return;
        }
        if (!this.editor.getText().equals("")) {
            this.editor.append(this.delimiter);
        }
        this.editor.append(chosen);
        this.comboBox.setSelectedIndex(0);
        if (this.action != null) {
            this.action.actionPerformed(new ActionEvent(this.editor, 0, ""));
        }
        this.editor.requestFocus();
    }

    void rebuildComboBox() {
        this.comboBox.removeAllItems();
        this.comboBox.addItem("");
        Vector<String> items = this.metaData.getData("selector_" + this.editor.getFieldName());
        if (items != null) {
            Iterator<String> i = items.iterator();
            while (i.hasNext()) {
                this.comboBox.addItem(i.next());
            }
        }
    }
}

