/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class PdfPreviewPanel
extends JPanel {
    private PDDocument document = null;
    private JLabel picLabel;
    private final MetaData metaData;

    public PdfPreviewPanel(MetaData metaData) {
        this.metaData = metaData;
        this.picLabel = new JLabel();
        this.add(this.picLabel);
    }

    private void renderPDFFile(File file) {
        FileInputStream input;
        try {
            input = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        try {
            this.document = PDDocument.load(input);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        List pages = this.document.getDocumentCatalog().getAllPages();
        PDPage page = (PDPage)pages.get(0);
        BufferedImage image = null;
        try {
            image = page.convertToImage();
        }
        catch (Exception e1) {
            image = null;
        }
        if (image != null) {
            int width = this.getParent().getWidth();
            int height = this.getParent().getHeight();
            BufferedImage resImage = this.resizeImage(image, width, height, 1);
            ImageIcon icon = new ImageIcon(resImage);
            this.picLabel.setText(null);
            this.picLabel.setIcon(icon);
        } else {
            this.clearPreview();
        }
        try {
            this.document.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int width, int height, int type) {
        int h = originalImage.getHeight();
        int w = originalImage.getWidth();
        if (height == 0 || width == 0) {
            height = h;
            width = w;
        } else {
            float factorH = (float)height / (float)h;
            float factorW = (float)width / (float)w;
            width = factorH < factorW ? Math.round((float)w * factorH) : Math.round((float)h * factorW);
        }
        BufferedImage resizedImage = new BufferedImage(width, height, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        return resizedImage;
    }

    public void updatePanel(BibtexEntry entry) {
        if (entry == null) {
            this.clearPreview();
            return;
        }
        this.picLabel.setText("rendering preview...");
        this.picLabel.setIcon(null);
        FileListTableModel tm = new FileListTableModel();
        tm.setContent(entry.getField("file"));
        FileListEntry flEntry = null;
        for (int i = 0; i < tm.getRowCount() && !(flEntry = tm.getEntry(i)).getType().getName().toLowerCase().equals("pdf"); ++i) {
        }
        if (flEntry != null) {
            File pdfFile = Util.expandFilename(this.metaData, flEntry.getLink());
            if (pdfFile != null) {
                this.renderPDFFile(pdfFile);
            } else {
                this.clearPreview();
            }
        } else {
            this.clearPreview();
        }
    }

    private void clearPreview() {
        this.picLabel.setIcon(null);
        this.picLabel.setText(Globals.lang("no preview available"));
    }
}

